/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta.ac.js;

import com.mirth.connect.client.ui.components.rsta.ac.MirthCompletion;
import com.mirth.connect.client.ui.reference.ClassReference;
import com.mirth.connect.client.ui.reference.CodeReference;
import com.mirth.connect.client.ui.reference.Reference;
import com.mirth.connect.client.ui.reference.VariableReference;
import com.mirth.connect.model.codetemplates.CodeTemplateContextSet;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import org.fife.rsta.ac.js.IconFactory;
import org.fife.rsta.ac.js.completion.JavascriptBasicCompletion;
import org.fife.ui.autocomplete.CompletionProvider;

public class MirthJavaScriptBasicCompletion
extends JavascriptBasicCompletion
implements MirthCompletion {
    protected String id;
    protected CodeTemplateContextSet contextSet;
    protected String summary;
    protected String inputText;
    protected String iconName;

    public MirthJavaScriptBasicCompletion(CompletionProvider provider, VariableReference reference) {
        this(provider, reference.getId(), reference.getContextSet(), reference.getReplacementCode(), reference.getReplacementCode(), reference.getName(), reference.getSummary(), reference.getIconName());
    }

    public MirthJavaScriptBasicCompletion(CompletionProvider provider, CodeReference reference) {
        this(provider, reference.getId(), reference.getContextSet(), reference.getName(), reference.getReplacementCode(), null, reference.getSummary(), reference.getIconName());
    }

    public MirthJavaScriptBasicCompletion(CompletionProvider provider, ClassReference reference) {
        this(provider, reference.getId(), reference.getContextSet(), reference.getName(), reference.getName(), null, reference.getSummary(), reference.getIconName());
    }

    public MirthJavaScriptBasicCompletion(CompletionProvider provider, ClassReference reference, String alias) {
        this(provider, reference.getId(), reference.getContextSet(), alias, alias, reference.getName(), reference.getSummary(), reference.getIconName());
    }

    private MirthJavaScriptBasicCompletion(CompletionProvider provider, String id, CodeTemplateContextSet contextSet, String inputText, String replacementText, String shortDesc, String summary, String iconName) {
        super(provider, replacementText, shortDesc, summary);
        this.id = id;
        this.contextSet = contextSet;
        this.summary = summary;
        this.inputText = inputText;
        this.iconName = iconName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public CodeTemplateContextSet getContextSet() {
        return this.contextSet;
    }

    public String getInputText() {
        return StringUtils.defaultString((String)this.inputText, (String)super.getInputText());
    }

    public Icon getIcon() {
        if (StringUtils.isNotBlank((CharSequence)this.iconName)) {
            return IconFactory.getIcon((String)this.iconName);
        }
        return IconFactory.getIcon((String)IconFactory.getEmptyIcon());
    }

    public String getToolTipText() {
        String summary = this.getSummary();
        if (StringUtils.isNotBlank((CharSequence)summary)) {
            return summary.replaceAll("<a\\s*(\\s[^>]*)\\s*(?<!/)>", "<span>").replaceAll("<a\\s*(\\s[^>]*)\\s*/\\s*>", "<span/>");
        }
        return null;
    }

    public int getRelevance() {
        return 75;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MirthCompletion) {
            return ((MirthCompletion)obj).getId().equals(this.id);
        }
        if (obj instanceof Reference) {
            return ((Reference)obj).getId().equals(this.id);
        }
        return false;
    }
}

