/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta.ac.js;

import com.mirth.connect.client.ui.components.rsta.MirthRSyntaxTextArea;
import com.mirth.connect.client.ui.components.rsta.ac.MirthCompletion;
import com.mirth.connect.client.ui.components.rsta.ac.MirthCompletionCacheInterface;
import com.mirth.connect.client.ui.components.rsta.ac.js.MirthJavaScriptBasicCompletion;
import com.mirth.connect.client.ui.components.rsta.ac.js.MirthJavaScriptClassCompletion;
import com.mirth.connect.client.ui.components.rsta.ac.js.MirthJavaScriptFunctionCompletion;
import com.mirth.connect.client.ui.components.rsta.ac.js.MirthJavaScriptTemplateCompletion;
import com.mirth.connect.client.ui.components.rsta.ac.js.PartialHashMap;
import com.mirth.connect.client.ui.reference.ClassReference;
import com.mirth.connect.client.ui.reference.CodeReference;
import com.mirth.connect.client.ui.reference.ConstructorReference;
import com.mirth.connect.client.ui.reference.FunctionReference;
import com.mirth.connect.client.ui.reference.ParameterizedCodeReference;
import com.mirth.connect.client.ui.reference.Reference;
import com.mirth.connect.client.ui.reference.ReferenceListFactory;
import com.mirth.connect.client.ui.reference.VariableReference;
import com.mirth.connect.model.codetemplates.ContextType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.fife.rsta.ac.js.JavaScriptShorthandCompletionCache;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;

public class MirthJavaScriptShorthandCompletionCache
extends JavaScriptShorthandCompletionCache
implements MirthCompletionCacheInterface {
    private PartialHashMap<Completion> variableCompletionMap = new PartialHashMap();
    private PartialHashMap<Completion> classCompletionMap = new PartialHashMap();
    private PartialHashMap<Completion> constructorCompletionMap = new PartialHashMap();
    private Map<String, PartialHashMap<Completion>> functionCompletionMap = new HashMap<String, PartialHashMap<Completion>>();
    private PartialHashMap<Completion> globalFunctionCompletionMap = new PartialHashMap();
    private PartialHashMap<Completion> codeCompletionMap = new PartialHashMap();

    public MirthJavaScriptShorthandCompletionCache(DefaultCompletionProvider templateProvider, DefaultCompletionProvider commentsProvider, boolean e4xSupport) {
        super(templateProvider, commentsProvider, e4xSupport);
        for (List<Reference> list : ReferenceListFactory.getInstance().getReferences().values()) {
            this.addReferences(list);
        }
    }

    @Override
    public List<Completion> getClassCompletions(JTextComponent comp, String partialText) {
        return this.getCompletions(comp, this.classCompletionMap, partialText);
    }

    @Override
    public List<Completion> getConstructorCompletions(JTextComponent comp, String partialText) {
        return this.getCompletions(comp, this.constructorCompletionMap, partialText);
    }

    @Override
    public List<Completion> getFunctionCompletions(JTextComponent comp, String variableOrClassName, String partialText) {
        PartialHashMap<Completion> map = this.functionCompletionMap.get(variableOrClassName);
        if (MapUtils.isNotEmpty(map)) {
            return this.getCompletions(comp, map, partialText);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Completion> getGlobalFunctionCompletions(JTextComponent comp, String partialText) {
        return this.getCompletions(comp, this.globalFunctionCompletionMap, partialText);
    }

    @Override
    public List<Completion> getVariableCompletions(JTextComponent comp, String partialText) {
        return this.getCompletions(comp, this.variableCompletionMap, partialText);
    }

    @Override
    public List<Completion> getCodeCompletions(JTextComponent comp, String partialText) {
        return this.getCompletions(comp, this.codeCompletionMap, partialText);
    }

    private List<Completion> getCompletions(JTextComponent comp, PartialHashMap<Completion> map, String partialText) {
        List<Object> completions = map.getPartial(partialText);
        if (completions == null) {
            completions = Collections.emptyList();
        }
        ContextType contextType = null;
        if (comp instanceof MirthRSyntaxTextArea) {
            contextType = ((MirthRSyntaxTextArea)((Object)comp)).getContextType();
        }
        if (contextType != null) {
            Iterator<Object> it = completions.iterator();
            while (it.hasNext()) {
                Completion completion = (Completion)it.next();
                if (!(completion instanceof MirthCompletion) || ((MirthCompletion)completion).getContextSet().contains((Object)contextType)) continue;
                it.remove();
            }
        }
        return completions;
    }

    @Override
    public void removeReferences(List<Reference> references) {
        HashSet<String> referenceIds = new HashSet<String>();
        for (Reference reference : references) {
            referenceIds.add(reference.getId());
        }
        Iterator it = this.getShorthandCompletions().iterator();
        while (it.hasNext()) {
            Completion completion = (Completion)it.next();
            if (!(completion instanceof MirthCompletion) || !referenceIds.contains(((MirthCompletion)completion).getId())) continue;
            it.remove();
        }
        block8: for (Reference reference : references) {
            switch (reference.getType()) {
                case CLASS: {
                    ClassReference classReference = (ClassReference)reference;
                    this.classCompletionMap.removeValue(classReference.getName(), classReference);
                    if (!CollectionUtils.isNotEmpty(classReference.getAliases())) break;
                    for (String alias : classReference.getAliases()) {
                        this.classCompletionMap.removeValue(alias, classReference);
                    }
                    continue block8;
                }
                case FUNCTION: {
                    FunctionReference functionReference = (FunctionReference)reference;
                    if (functionReference.getFunctionDefinition() == null) break;
                    String name = functionReference.getFunctionDefinition().getName();
                    String className = functionReference.getClassName();
                    List<String> beforeDotTextList = functionReference.getBeforeDotTextList();
                    PartialHashMap<Completion> map = this.functionCompletionMap.get(className);
                    if (map != null) {
                        map.removeValue(name, functionReference);
                    }
                    if (CollectionUtils.isNotEmpty(beforeDotTextList)) {
                        for (String beforeDotText : beforeDotTextList) {
                            map = this.functionCompletionMap.get(beforeDotText);
                            if (map == null) continue;
                            map.removeValue(name, functionReference);
                        }
                    }
                    this.globalFunctionCompletionMap.removeValue(name, functionReference);
                    break;
                }
                case VARIABLE: {
                    this.variableCompletionMap.removeValue(reference.getName(), reference);
                    break;
                }
                case CODE: {
                    this.codeCompletionMap.removeValue(reference.getName(), reference);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addReferences(List<Reference> references) {
        if (CollectionUtils.isEmpty(references)) {
            return;
        }
        block6: for (Reference reference : references) {
            switch (reference.getType()) {
                case CLASS: {
                    ClassReference classReference = (ClassReference)reference;
                    MirthCompletion completion = new MirthJavaScriptClassCompletion((CompletionProvider)this.getTemplateProvider(), (ClassReference)reference);
                    this.addShorthandCompletion(completion);
                    this.classCompletionMap.put(classReference.getName(), (Completion)completion);
                    if (!CollectionUtils.isNotEmpty(classReference.getAliases())) break;
                    for (String string : classReference.getAliases()) {
                        this.addShorthandCompletion(new MirthJavaScriptClassCompletion((CompletionProvider)this.getTemplateProvider(), (ClassReference)reference, string));
                        this.classCompletionMap.put(string, (Completion)completion);
                    }
                    continue block6;
                }
                case FUNCTION: {
                    FunctionReference functionReference = (FunctionReference)reference;
                    if (functionReference.getFunctionDefinition() == null) break;
                    MirthCompletion completion = new MirthJavaScriptFunctionCompletion((CompletionProvider)this.getTemplateProvider(), functionReference);
                    if (CollectionUtils.isNotEmpty(functionReference.getBeforeDotTextList())) {
                        for (String beforeDotText : functionReference.getBeforeDotTextList()) {
                            if (StringUtils.isBlank((CharSequence)beforeDotText)) {
                                this.addShorthandCompletion(completion);
                                continue;
                            }
                            PartialHashMap<Object> map = this.functionCompletionMap.get(beforeDotText);
                            if (map == null) {
                                map = new PartialHashMap();
                                this.functionCompletionMap.put(beforeDotText, map);
                            }
                            map.put(functionReference.getFunctionDefinition().getName(), (Object)completion);
                        }
                    } else if (!(functionReference instanceof ConstructorReference) && functionReference.getClassName() == null) {
                        this.addShorthandCompletion(completion);
                        this.globalFunctionCompletionMap.put(functionReference.getFunctionDefinition().getName(), (Completion)completion);
                    }
                    if (functionReference.getClassName() != null) {
                        void var7_12;
                        PartialHashMap<Completion> partialHashMap = this.functionCompletionMap.get(functionReference.getClassName());
                        if (partialHashMap == null) {
                            PartialHashMap partialHashMap2 = new PartialHashMap();
                            this.functionCompletionMap.put(functionReference.getClassName(), partialHashMap2);
                        }
                        var7_12.put(functionReference.getFunctionDefinition().getName(), completion);
                    }
                    if (!(functionReference instanceof ConstructorReference)) break;
                    ConstructorReference constructorReference = (ConstructorReference)functionReference;
                    ArrayList<MirthJavaScriptBasicCompletion> list = this.constructorCompletionMap.get(constructorReference.getClassName());
                    if (list == null) {
                        list = new ArrayList<MirthJavaScriptBasicCompletion>();
                        this.constructorCompletionMap.put(constructorReference.getClassName(), list);
                    }
                    list.add((MirthJavaScriptBasicCompletion)completion);
                    break;
                }
                case VARIABLE: {
                    MirthCompletion completion = new MirthJavaScriptBasicCompletion((CompletionProvider)this.getTemplateProvider(), (VariableReference)reference);
                    this.addShorthandCompletion(completion);
                    this.variableCompletionMap.put(reference.getName(), (Completion)completion);
                    break;
                }
                case CODE: {
                    MirthCompletion completion = reference instanceof ParameterizedCodeReference ? new MirthJavaScriptTemplateCompletion((CompletionProvider)this.getTemplateProvider(), (ParameterizedCodeReference)reference) : new MirthJavaScriptBasicCompletion((CompletionProvider)this.getTemplateProvider(), (CodeReference)reference);
                    this.addShorthandCompletion(completion);
                    this.codeCompletionMap.put(reference.getName(), (Completion)completion);
                }
            }
        }
    }
}

