/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.rsta.ac.js;

import com.mirth.connect.client.ui.components.rsta.ac.MirthCompletionCacheInterface;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.fife.rsta.ac.js.SourceCompletionProvider;
import org.fife.ui.autocomplete.Completion;

public class MirthSourceCompletionProvider
extends SourceCompletionProvider {
    private static final Pattern PARENTHESES_PATTERN = Pattern.compile("\\([\\S\\s]*\\)");
    private MirthCompletionCacheInterface completionCache;
    private String lastCompletionsAtText = null;
    private List<Completion> lastParameterizedCompletionsAt = null;

    public MirthSourceCompletionProvider(boolean xmlSupported) {
        this(null, xmlSupported);
    }

    public MirthSourceCompletionProvider(String javaScriptEngine, boolean xmlSupported) {
        super(javaScriptEngine, xmlSupported);
    }

    public void setCompletionCache(MirthCompletionCacheInterface completionCache) {
        this.completionCache = completionCache;
    }

    protected List<Completion> getCompletionsImpl(JTextComponent comp) {
        HashSet<Completion> set = new HashSet<Completion>(super.getCompletionsImpl(comp));
        String text = StringUtils.trim((String)this.getAlreadyEnteredText(comp));
        if (StringUtils.isNotBlank((CharSequence)text)) {
            int dot = text.lastIndexOf(46);
            if (dot > 0) {
                int nextToLastDot = text.lastIndexOf(46, dot - 1);
                String identifier = nextToLastDot >= 0 ? text.substring(nextToLastDot + 1, dot).trim() : text.substring(0, dot).trim();
                int index = (identifier = PARENTHESES_PATTERN.matcher(identifier).replaceAll("").trim()).lastIndexOf(32);
                if (index >= 0) {
                    identifier = identifier.substring(index + 1);
                }
                String partialText = text.substring(dot + 1).trim();
                if (StringUtils.isNotBlank((CharSequence)identifier)) {
                    set.addAll(this.completionCache.getFunctionCompletions(comp, identifier, partialText));
                }
            } else if (text.equals("new") || text.startsWith("new ")) {
                String partialText = text.substring(3).trim();
                set.addAll(this.completionCache.getConstructorCompletions(comp, partialText));
            } else {
                set.addAll(this.completionCache.getVariableCompletions(comp, text));
                set.addAll(this.completionCache.getClassCompletions(comp, text));
                set.addAll(this.completionCache.getGlobalFunctionCompletions(comp, text));
                set.addAll(this.completionCache.getCodeCompletions(comp, text));
            }
        } else {
            set.addAll(this.completionCache.getVariableCompletions(comp, ""));
            set.addAll(this.completionCache.getClassCompletions(comp, ""));
            set.addAll(this.completionCache.getGlobalFunctionCompletions(comp, ""));
            set.addAll(this.completionCache.getCodeCompletions(comp, ""));
        }
        return new ArrayList<Completion>(set);
    }

    public List<Completion> getCompletionsAt(JTextComponent tc, Point p) {
        int offset;
        HashSet<Completion> completions = new HashSet<Completion>();
        List parentCompletions = super.getCompletionsAt(tc, p);
        if (CollectionUtils.isNotEmpty((Collection)parentCompletions)) {
            completions.addAll(parentCompletions);
        }
        if ((offset = tc.viewToModel(p)) < 0 || offset >= tc.getDocument().getLength()) {
            this.lastCompletionsAtText = null;
            this.lastParameterizedCompletionsAt = null;
            return new ArrayList<Completion>(completions);
        }
        Segment s = new Segment();
        Document doc = tc.getDocument();
        Element root = doc.getDefaultRootElement();
        int line = root.getElementIndex(offset);
        Element elem = root.getElement(line);
        int start = elem.getStartOffset();
        int end2 = elem.getEndOffset() - 1;
        try {
            int endOffs;
            int startOffs;
            doc.getText(start, end2 - start, s);
            for (startOffs = s.offset + (offset - start) - 1; startOffs >= s.offset && Character.isLetterOrDigit(s.array[startOffs]); --startOffs) {
            }
            for (endOffs = s.offset + (offset - start); endOffs < s.offset + s.count && Character.isLetterOrDigit(s.array[endOffs]); ++endOffs) {
            }
            int len = endOffs - startOffs - 1;
            if (len <= 0) {
                this.lastParameterizedCompletionsAt = null;
                return new ArrayList<Completion>(completions);
            }
            String text = new String(s.array, startOffs + 1, len);
            if (text.equals(this.lastCompletionsAtText)) {
                if (CollectionUtils.isNotEmpty(this.lastParameterizedCompletionsAt)) {
                    completions.addAll(this.lastParameterizedCompletionsAt);
                }
                return new ArrayList<Completion>(completions);
            }
            this.lastCompletionsAtText = text;
            this.lastParameterizedCompletionsAt = this.completionCache.getClassCompletions(tc, text);
            if (CollectionUtils.isNotEmpty(this.lastParameterizedCompletionsAt)) {
                completions.addAll(this.lastParameterizedCompletionsAt);
            }
            return new ArrayList<Completion>(completions);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            this.lastCompletionsAtText = null;
            this.lastParameterizedCompletionsAt = null;
            return new ArrayList<Completion>(completions);
        }
    }
}

