/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.tag;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.components.tag.AutoCompletionDelegate;
import com.mirth.connect.client.ui.components.tag.AutoCompletionProvider;
import com.mirth.connect.client.ui.components.tag.FilterCompletion;
import com.mirth.connect.client.ui.components.tag.SearchFilterListener;
import com.mirth.connect.client.ui.components.tag.TagCompletion;
import com.mirth.connect.client.ui.components.tag.TagCompletionRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.scene.web.WebEngine;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import netscape.javascript.JSObject;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;

public class AutoCompletionPopupWindow
extends JTextField {
    private static int UP_ARROW_KEY = 38;
    private static int DOWN_ARROW_KEY = 40;
    private static int ESCAPE_KEY = 27;
    private static int ENTER_KEY = 13;
    private AutoCompletionDelegate completionDelegate;
    private AutoCompletionProvider provider;
    private WebEngine engineCtrl;
    private String currentlyEnteredText = "";
    private List<SearchFilterListener> updateSearchListeners = new ArrayList<SearchFilterListener>();

    public AutoCompletionPopupWindow() {
        this.setVisible(false);
        this.setBackground(Color.white);
        this.setFocusable(true);
        this.initComponents();
    }

    @Override
    public Rectangle modelToView(int pos) throws BadLocationException {
        return new Rectangle(this.getLocation(), new Dimension(50, 24));
    }

    private void initComponents() {
        this.provider = new AutoCompletionProvider();
        this.provider.setAutoActivationRules(true, null);
        this.provider.setListCellRenderer(new TagCompletionRenderer());
        this.completionDelegate = new AutoCompletionDelegate((CompletionProvider)this.provider, this);
        this.completionDelegate.setAutoCompleteSingleChoices(false);
        this.completionDelegate.install(this);
    }

    public void createTagOnFocusLost() {
        this.translateKey(ENTER_KEY, "");
    }

    public void setTag(String tagName, String tagType) {
        this.doCall("insertTag", tagName, tagType);
        this.currentlyEnteredText = "";
        this.hidePopup();
        PlatformUI.MIRTH_FRAME.setSaveEnabled(PlatformUI.MIRTH_FRAME.currentContentPage == PlatformUI.MIRTH_FRAME.channelEditPanel);
    }

    public void setWebEngine(WebEngine engineCtrl) {
        this.engineCtrl = engineCtrl;
    }

    public void clear() {
        this.currentlyEnteredText = "";
    }

    public void closePopupWindow() {
        this.hidePopup();
        this.setFocus(false);
    }

    public void setTags(Set<FilterCompletion> tags) {
        this.provider.clear();
        for (FilterCompletion tag : tags) {
            this.provider.addCompletion((Completion)new TagCompletion((CompletionProvider)this.provider, tag.getName(), tag.getType(), tag.getBackgroundColor(), tag.getIcon()));
        }
    }

    public void showPopup(String completionText) {
        this.showPopup(completionText, false);
    }

    public void showPopup(String completionText, boolean force) {
        if (force || StringUtils.isNotBlank((CharSequence)completionText)) {
            this.currentlyEnteredText = completionText;
            this.setText(completionText);
            this.completionDelegate.doCompletion();
        } else {
            this.hidePopup();
        }
    }

    public void hidePopup() {
        this.completionDelegate.hideChildWindows();
        if (this.completionDelegate.isPopupVisible()) {
            this.completionDelegate.hidePopupWindow();
        }
    }

    public void closePopup() {
        if (StringUtils.isEmpty((CharSequence)this.currentlyEnteredText)) {
            this.hidePopup();
        }
    }

    public void translateKey(Integer keyCode, String completionText) {
        if (!this.isFocusOwner()) {
            this.requestFocusInWindow();
        }
        if (keyCode == UP_ARROW_KEY) {
            this.completionDelegate.moveUp();
        } else if (keyCode == DOWN_ARROW_KEY) {
            if (this.completionDelegate.isPopupVisible()) {
                this.completionDelegate.moveDown();
            } else {
                this.showPopup(completionText, true);
            }
        } else if (keyCode == ENTER_KEY) {
            String tagText = this.currentlyEnteredText;
            if (this.completionDelegate.isPopupVisible()) {
                tagText = this.completionDelegate.getSelectedValue();
            } else if (StringUtils.isNotEmpty((CharSequence)tagText)) {
                this.setTag(tagText, "name");
            }
        } else if (keyCode == ESCAPE_KEY && this.completionDelegate.isPopupVisible()) {
            this.hidePopup();
        }
    }

    public void addUpdateSearchListener(SearchFilterListener updateSearchListener) {
        if (!this.updateSearchListeners.contains(updateSearchListener)) {
            this.updateSearchListeners.add(updateSearchListener);
        }
    }

    public void updateSearchPerformed(String filterString) {
        for (SearchFilterListener listener : this.updateSearchListeners) {
            if (listener == null) continue;
            listener.doSearch(filterString);
        }
        this.hidePopup();
    }

    public void deleteTagActionPerformed(String filterString) {
        for (SearchFilterListener listener : this.updateSearchListeners) {
            if (listener == null) continue;
            listener.doDelete(filterString);
        }
    }

    public void setFocus(boolean focus) {
        this.doCall("setFocus", this.convertToJSON(focus));
    }

    private String convertToJSON(Object object) {
        String jsonData = "";
        try {
            ObjectMapper mapper = new ObjectMapper();
            jsonData = mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e.getCause(), "Error converting to JSON");
        }
        return jsonData;
    }

    private void doCall(final String method, final Object ... args) {
        try {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JSObject tokenField = (JSObject)AutoCompletionPopupWindow.this.engineCtrl.executeScript("window");
                    tokenField.call(method, args);
                }
            });
        }
        catch (Exception e) {
            PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e.getCause(), "Error in tagfield");
        }
    }
}

