/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.tag;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.IconButton;
import com.mirth.connect.client.ui.components.tag.AutoCompletionPopupWindow;
import com.mirth.connect.client.ui.components.tag.FilterCompletion;
import com.mirth.connect.client.ui.components.tag.MirthTagWebBrowser;
import com.mirth.connect.client.ui.components.tag.SearchFilterListener;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MirthTagField
extends JPanel {
    private static String TAG_TYPE = "tag";
    private static char DELIM = (char)58;
    private Frame parent;
    private Logger logger = LogManager.getLogger(this.getClass());
    private JFXPanel jfxPanel;
    private MirthTagWebBrowser mirthWebBrowser;
    private IconButton clearButton;
    private AutoCompletionPopupWindow acPopupWindow;
    private boolean restorePreferences;
    private List<Map<String, String>> cachedUserPreferenceTags = new ArrayList<Map<String, String>>();

    public MirthTagField(String preferencePrefix, final boolean channelContext, final Set<FilterCompletion> tags) {
        this.parent = PlatformUI.MIRTH_FRAME;
        boolean bl = this.restorePreferences = !channelContext;
        if (StringUtils.isNotBlank((CharSequence)preferencePrefix)) {
            try {
                Properties userPreferences = this.parent.mirthClient.getUserPreferences(this.parent.getCurrentUser((Component)((Object)this.parent)).getId(), Collections.singleton("initialTags" + preferencePrefix));
                this.cachedUserPreferenceTags = this.getUserPreferenceTags(userPreferences.getProperty("initialTags" + preferencePrefix));
            }
            catch (ClientException e) {
                this.logger.error("Error restoring tag preferences.", (Throwable)e);
            }
        }
        this.setBackground(channelContext ? UIConstants.BACKGROUND_COLOR : null);
        this.initComponents(channelContext);
        this.initLayout(channelContext);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MirthTagField.this.initFX(channelContext, tags);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void initFX(boolean channelContext, Set<FilterCompletion> tags) throws Exception {
        Group root = new Group();
        Scene scene = new Scene((Parent)root);
        this.mirthWebBrowser = new MirthTagWebBrowser(this.acPopupWindow, this.cachedUserPreferenceTags, this.createAttributeMap(tags), channelContext);
        root.getChildren().add((Object)this.mirthWebBrowser);
        this.jfxPanel.setScene(scene);
        InputMap inputMap = this.jfxPanel.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "Arrow.up");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "Arrow.down");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "Arrow.left");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "Arrow.right");
        AbstractAction doNothing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        ActionMap actionMap = this.jfxPanel.getActionMap();
        actionMap.put("Arrow.up", doNothing);
        actionMap.put("Arrow.down", doNothing);
        actionMap.put("Arrow.left", doNothing);
        actionMap.put("Arrow.right", doNothing);
        this.mirthWebBrowser.setUserTags(this.cachedUserPreferenceTags, true);
    }

    private void initComponents(boolean channelContext) {
        if (channelContext) {
            this.setToolTipText("Add or remove tags here. General tag management may be done in the Settings -> Tags tab.");
        } else {
            this.setToolTipText("Enter tags or free text here. Free text will match on channel names, case insensitive.");
        }
        this.jfxPanel = new JFXPanel();
        this.jfxPanel.setBorder(BorderFactory.createLineBorder(new Color(110, 110, 110), 1, false));
        this.clearButton = new IconButton();
        this.clearButton.setIcon(UIConstants.ICON_X);
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MirthTagField.this.mirthWebBrowser.clear();
                MirthTagField.this.clearButton.setEnabled(false);
                MirthTagField.this.acPopupWindow.deleteTagActionPerformed("");
            }
        });
        this.acPopupWindow = new AutoCompletionPopupWindow();
        this.acPopupWindow.addUpdateSearchListener(new SearchFilterListener(){

            @Override
            public void doSearch(final String filterString) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MirthTagField.this.updateUserTags(filterString);
                        MirthTagField.this.clearButton.setEnabled(StringUtils.isNotBlank((CharSequence)filterString));
                    }
                });
            }

            @Override
            public void doDelete(String filterString) {
                MirthTagField.this.updateUserTags(filterString);
                MirthTagField.this.clearButton.setEnabled(StringUtils.isNotBlank((CharSequence)filterString));
            }
        });
    }

    private void initLayout(boolean channelContext) {
        this.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0, fill"));
        this.add((Component)this.acPopupWindow, "split 2");
        this.add((Component)this.jfxPanel, "h 24!, gaptop 1, growx, push");
        if (!channelContext) {
            this.add((Component)this.clearButton, "h 22!, w 22!, aligny top, gaptop 2");
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jfxPanel.setEnabled(enabled);
        this.mirthWebBrowser.setEnabled(enabled);
    }

    public void addUpdateSearchListener(SearchFilterListener searchListener) {
        this.acPopupWindow.addUpdateSearchListener(searchListener);
    }

    private void updateUserTags(String filterString) {
        try {
            this.cachedUserPreferenceTags = this.getUserPreferenceTags(filterString);
        }
        catch (Exception e) {
            this.logger.error("Error saving tag preferences.");
        }
    }

    public void createTagOnFocusLost() {
        this.acPopupWindow.createTagOnFocusLost();
    }

    public void setFocus(boolean focus) {
        this.jfxPanel.requestFocus();
        this.mirthWebBrowser.setFocus(focus);
    }

    public void closePopupWindow() {
        this.acPopupWindow.closePopupWindow();
    }

    public void setChannelTags(List<ChannelTag> tags) {
        ArrayList<Map<String, String>> tagAttributes = new ArrayList<Map<String, String>>();
        for (ChannelTag tag : tags) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("label", tag.getName());
            attributes.put("value", TAG_TYPE + DELIM + tag.getName());
            tagAttributes.add(attributes);
        }
        this.mirthWebBrowser.setUserTags(tagAttributes, true);
    }

    public void clear() {
        this.acPopupWindow.clear();
        this.mirthWebBrowser.clear();
    }

    public String getTags() {
        return this.mirthWebBrowser != null ? this.mirthWebBrowser.getTags() : "";
    }

    public Map<String, Color> getTagColors() {
        return this.mirthWebBrowser != null ? this.mirthWebBrowser.getTagColors() : new HashMap();
    }

    public boolean isFilterEnabled() {
        return this.mirthWebBrowser != null && StringUtils.isNotEmpty((CharSequence)this.mirthWebBrowser.getTags());
    }

    public void update(Set<FilterCompletion> tags, boolean channelContext, boolean updateUserTags, boolean updateController) {
        Map<String, Map<String, String>> attributeMap = this.createAttributeMap(tags);
        if (this.mirthWebBrowser != null && MapUtils.isNotEmpty(attributeMap)) {
            this.mirthWebBrowser.updateTags(attributeMap, channelContext);
            if (updateUserTags) {
                this.clearButton.setEnabled(CollectionUtils.isNotEmpty(this.cachedUserPreferenceTags));
                this.mirthWebBrowser.setUserTags(this.cachedUserPreferenceTags, updateController);
            }
        }
        if (this.acPopupWindow != null) {
            this.acPopupWindow.setTags(tags);
        }
    }

    private Map<String, Map<String, String>> createAttributeMap(Set<FilterCompletion> tags) {
        HashMap<String, Map<String, String>> tagObjectMap = new HashMap<String, Map<String, String>>();
        for (FilterCompletion tag : tags) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("background", ColorUtil.convertToHex((Color)tag.getBackgroundColor()));
            attributes.put("color", ColorUtil.convertToHex((Color)tag.getForegroundColor()));
            attributes.put("type", tag.getType());
            tagObjectMap.put(tag.getName(), attributes);
        }
        return tagObjectMap;
    }

    public void setUserPreferenceTags() {
        if (this.mirthWebBrowser != null) {
            this.mirthWebBrowser.setUserTags(this.cachedUserPreferenceTags, true);
        }
    }

    private List<Map<String, String>> getUserPreferenceTags(String userTags) {
        ArrayList<Map<String, String>> userPreferenceTags = new ArrayList<Map<String, String>>();
        try {
            if (this.restorePreferences && StringUtils.isNotBlank((CharSequence)userTags)) {
                String[] tags;
                for (String tag : tags = userTags.split(",")) {
                    Object[] tagPair = tag.split(":");
                    if (!ArrayUtils.isNotEmpty((Object[])tagPair) || tagPair.length != 2) continue;
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    String tagName = String.valueOf(tagPair[1]).trim();
                    String tagType = String.valueOf(tagPair[0]).trim();
                    attributes.put("label", tagName);
                    attributes.put("value", String.valueOf(tagType) + DELIM + tagName);
                    userPreferenceTags.add(attributes);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error saving tag preferences.");
        }
        return userPreferenceTags;
    }
}

