/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.tag;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.components.tag.AutoCompletionPopupWindow;
import com.mirth.connect.client.ui.components.tag.MirthTagWebController;
import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.layout.Region;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MirthTagWebBrowser
extends Region {
    private WebView webView;
    private WebEngine webEngine;
    private MirthTagWebController webController;
    private AutoCompletionPopupWindow popupWindow;
    private Logger logger = LogManager.getLogger((Object)((Object)this));

    public MirthTagWebBrowser(AutoCompletionPopupWindow popupWindow, List<Map<String, String>> userTags, Map<String, Map<String, String>> attributeMap, boolean channelContext) throws Exception {
        this.popupWindow = popupWindow;
        this.setHeight(24.0);
        this.setPrefWidth(200.0);
        this.initComponents(userTags, attributeMap, channelContext);
        this.getChildren().add((Object)this.webView);
    }

    private void initComponents(List<Map<String, String>> userTags, Map<String, Map<String, String>> attributeMap, boolean channelContext) throws Exception {
        this.webView = new WebView();
        this.webView.setContextMenuEnabled(false);
        this.webView.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    MirthTagWebBrowser.this.setFocus(false);
                }
            }
        });
        this.webEngine = this.webView.getEngine();
        final String tagData = this.convertToJSON(userTags);
        final String attributeData = this.convertToJSON(attributeMap);
        final String context = this.convertToJSON(channelContext);
        String html = IOUtils.toString((URL)((Object)((Object)this)).getClass().getResource("MirthTagField.html"), (String)"UTF-8");
        html = html.replace("bootstrap.min.css", ((Object)((Object)this)).getClass().getResource("bootstrap.min.css").toURI().toString());
        html = html.replace("bootstrap-tokenfield.css", ((Object)((Object)this)).getClass().getResource("bootstrap-tokenfield.css").toURI().toString());
        html = html.replace("tokenfield-typeahead.css", ((Object)((Object)this)).getClass().getResource("tokenfield-typeahead.css").toURI().toString());
        html = html.replace("bootstrap-tokenfield.js", ((Object)((Object)this)).getClass().getResource("bootstrap-tokenfield.js").toURI().toString());
        html = html.replace("jquery-ui.min.js", ((Object)((Object)this)).getClass().getResource("jquery-ui.min.js").toURI().toString());
        html = html.replace("jquery.min.js", ((Object)((Object)this)).getClass().getResource("jquery.min.js").toURI().toString());
        this.webEngine.loadContent(html);
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    JSObject init = (JSObject)MirthTagWebBrowser.this.webEngine.executeScript("window");
                    init.setMember("clickController", MirthTagWebBrowser.this.webController);
                    init.call("updateTags", attributeData, context);
                    init.call("setUserTags", tagData);
                }
            }
        });
        this.webController = new MirthTagWebController(this.popupWindow);
        this.popupWindow.setWebEngine(this.webEngine);
    }

    public void updateTags(Map<String, Map<String, String>> tagAtrributeMap, boolean channelContext) {
        this.doCall("updateTags", this.convertToJSON(tagAtrributeMap), this.convertToJSON(channelContext));
    }

    public void setFocus(boolean focus) {
        this.doCall("setFocus", this.convertToJSON(focus));
    }

    public void setEnabled(boolean enable) {
        this.doCall("setEnabled", this.convertToJSON(enable));
    }

    public void setUserTags(List<Map<String, String>> tags, boolean updateController) {
        this.doCall("setUserTags", this.convertToJSON(tags), updateController);
    }

    public void insertTag(String tagName) {
        this.doCall("insertTag", tagName);
    }

    public String getTags() {
        return this.webController.getTags();
    }

    public Map<String, Color> getTagColors() {
        return this.webController.getTagColors();
    }

    public void clear() {
        this.setUserTags(new ArrayList<Map<String, String>>(), true);
        this.webController.setTags("");
    }

    private String convertToJSON(Object object) {
        String jsonData = "";
        try {
            ObjectMapper mapper = new ObjectMapper();
            jsonData = mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e.getCause(), "Error converting to JSON");
        }
        return jsonData;
    }

    private void doCall(final String method, final Object ... args) {
        try {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        JSObject tokenField = (JSObject)MirthTagWebBrowser.this.webEngine.executeScript("window");
                        tokenField.call(method, args);
                    }
                    catch (Exception e) {
                        MirthTagWebBrowser.this.logger.error("Error calling tokenField JS method: " + method, (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e.getCause(), "Error in tagfield");
        }
    }
}

