/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.components.tag;

import com.mirth.connect.client.ui.components.tag.AutoCompletionPopupWindow;
import com.mirth.connect.util.ColorUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MirthTagWebController {
    private static int BACKSPACE = 8;
    private Logger logger = LogManager.getLogger(this.getClass());
    private String tags;
    private AutoCompletionPopupWindow popupWindow;
    private Map<String, Color> tagColorMap;

    public MirthTagWebController() {
    }

    public MirthTagWebController(AutoCompletionPopupWindow popupWindow) {
        this.tags = "";
        this.popupWindow = popupWindow;
        this.tagColorMap = new HashMap<String, Color>();
    }

    public void clearTags() {
        this.tags = null;
        this.tagColorMap = new HashMap<String, Color>();
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getTags() {
        return this.tags;
    }

    public Map<String, Color> getTagColors() {
        return this.tagColorMap;
    }

    public void updatePopupWindow(String completionText) {
        SwingUtilities.invokeLater(() -> this.popupWindow.showPopup(completionText.trim()));
    }

    public void closePopupWindow() {
        this.popupWindow.hidePopup();
    }

    public void updateTagSearch(String tagString) {
        this.tags = tagString;
        this.popupWindow.updateSearchPerformed(tagString);
    }

    public void deleteTagActionPerformed(String tagString) {
        this.tags = tagString;
        this.popupWindow.deleteTagActionPerformed(tagString);
    }

    public void translateKey(String code, String completionText) {
        Integer keyCode = Integer.parseInt(code);
        if (keyCode == BACKSPACE) {
            this.popupWindow.closePopup();
        } else {
            this.popupWindow.translateKey(keyCode, completionText);
        }
    }

    public String getColor(String tagName) {
        Color newColor = ColorUtil.getNewColor();
        this.tagColorMap.put(tagName, newColor);
        return "[\"" + ColorUtil.convertToHex((Color)newColor) + "\",\"" + ColorUtil.convertToHex((Color)ColorUtil.getForegroundColor((Color)newColor)) + "\"]";
    }

    public void log(Object message) {
        this.logger.error(message);
    }
}

