/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.editors.BaseEditorPane;
import com.mirth.connect.model.FilterTransformer;
import com.mirth.connect.model.FilterTransformerElement;
import com.mirth.connect.model.IteratorElement;
import java.util.ArrayList;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;

public abstract class FilterTransformerTreeTableNode<T extends FilterTransformer<C>, C extends FilterTransformerElement>
extends AbstractMutableTreeTableNode {
    protected BaseEditorPane<T, C> editorPane;
    protected C element;

    public FilterTransformerTreeTableNode(BaseEditorPane<T, C> editorPane, C element) {
        this.editorPane = editorPane;
        this.setElement(element);
    }

    public C getElement() {
        return this.element;
    }

    public C getElementWithChildren() {
        if (this.element instanceof IteratorElement) {
            IteratorElement iteratorElement = (IteratorElement)this.element;
            ArrayList<C> children = new ArrayList<C>();
            for (int i = 0; i < this.getChildCount(); ++i) {
                children.add(((FilterTransformerTreeTableNode)this.getChildAt(i)).getElementWithChildren());
            }
            iteratorElement.getProperties().setChildren(children);
        }
        return this.element;
    }

    public void setElement(C element) {
        this.element = element.clone();
    }

    public boolean isIteratorNode() {
        return this.element instanceof IteratorElement;
    }

    public int getColumnCount() {
        return 4;
    }

    public Object getValueAt(int column) {
        if (column == this.editorPane.numColumn) {
            return this.element.getSequenceNumber();
        }
        if (column == this.editorPane.nameColumn) {
            return new BaseEditorPane.OperatorNamePair(this.element.getName());
        }
        if (column == this.editorPane.typeColumn) {
            return this.element.getType();
        }
        if (column == this.editorPane.enabledColumn) {
            return this.element.isEnabled();
        }
        return null;
    }

    public void setValueAt(Object value, int column) {
        if (column == this.editorPane.numColumn) {
            this.element.setSequenceNumber((String)value);
        } else if (column == this.editorPane.nameColumn) {
            this.element.setName(((BaseEditorPane.OperatorNamePair)((Object)value)).getName());
        } else if (column == this.editorPane.enabledColumn) {
            this.element.setEnabled(((Boolean)value).booleanValue());
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FilterTransformerTreeTableNode) {
            try {
                return this.element.equals(((FilterTransformerTreeTableNode)((Object)obj)).getElement());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

