/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.editors.FilterTransformerTreeTableNode;
import com.mirth.connect.client.ui.editors.IteratorUtil;
import com.mirth.connect.model.FilterTransformer;
import com.mirth.connect.model.FilterTransformerElement;
import com.mirth.connect.model.IteratorElement;
import com.mirth.connect.model.IteratorProperties;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class IteratorWizardDialog<T extends FilterTransformer<C>, C extends FilterTransformerElement>
extends MirthDialog {
    private static final Color GREEN = new Color(0, 169, 0);
    private String targetSuffix;
    private List<JavaScriptSharedUtil.ExprPart> targetComponents;
    private String indexVariable;
    private List<String> ancestorIndexVariables;
    private List<String> descendantIndexVariables;
    private FilterTransformerTreeTableNode<T, C> selectedNode;
    private DefaultTreeTableModel treeTableModel;
    private TreeTableNode root;
    private List<IteratorEntry> iteratorEntries;
    private String outbound;
    private List<JavaScriptSharedUtil.ExprPart> outboundComponents;
    private boolean accepted;
    private int preferredMaxDepth = -1;
    private TreePath preferredPath = null;
    private JRadioButton createNewRadio;
    private JRadioButton chooseExistingRadio;
    private JComboBox<IteratorEntry> iteratorComboBox;
    private JLabel createNewWarningLabel;
    private JPanel createNewPanel;
    private JLabel targetLabel;
    private List<JLabel> targetComponentLabels;
    private List<JRadioButton> targetComponentRadioButtons;
    private JPanel targetPanel;
    private JScrollPane targetScrollPane;
    private JLabel outboundLabel;
    private List<JLabel> outboundComponentLabels;
    private List<JRadioButton> outboundComponentRadioButtons;
    private JPanel outboundPanel;
    private JScrollPane outboundScrollPane;
    private JLabel substitutionsLabel;
    private JLabel substitutionsTargetLabel1;
    private JLabel substitutionsTargetLabel2;
    private JLabel substitutionsTargetLabel3;
    private JLabel substitutionsTargetIndexLabel;
    private JLabel substitutionsTargetLabel4;
    private JLabel substitutionsOutboundLabel1;
    private JLabel substitutionsOutboundLabel2;
    private JLabel substitutionsOutboundLabel3;
    private JLabel substitutionsOutboundIndexLabel;
    private JLabel substitutionsOutboundLabel4;
    private JPanel substitutionsPanel;
    private JScrollPane substitutionsScrollPane;
    private JSeparator separator;
    private JButton okButton;
    private JButton cancelButton;

    public IteratorWizardDialog(String target, FilterTransformerTreeTableNode<T, C> selectedNode, TreeTableNode parent, DefaultTreeTableModel treeTableModel, String outbound) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), "Iterator Wizard", true);
        this.selectedNode = selectedNode;
        this.treeTableModel = treeTableModel;
        this.root = treeTableModel.getRoot();
        this.outbound = outbound;
        this.ancestorIndexVariables = IteratorUtil.getAncestorIndexVariables(parent);
        this.descendantIndexVariables = IteratorUtil.getDescendantIndexVariables(selectedNode);
        this.indexVariable = IteratorUtil.getValidIndexVariable(this.ancestorIndexVariables, this.descendantIndexVariables);
        this.iteratorEntries = new ArrayList<IteratorEntry>();
        this.fillIteratorEntries();
        if (StringUtils.endsWith((CharSequence)target, (CharSequence)".toString()")) {
            this.targetSuffix = ".toString()";
            target = StringUtils.removeEnd((String)target, (String)this.targetSuffix);
        }
        this.targetComponents = JavaScriptSharedUtil.getExpressionParts((String)target, (boolean)false);
        this.outboundComponents = outbound != null ? JavaScriptSharedUtil.getExpressionParts((String)outbound, (boolean)false) : new ArrayList<JavaScriptSharedUtil.ExprPart>();
        this.initComponents();
        this.initLayout();
        IteratorEntry selectedEntry = null;
        if (!this.iteratorEntries.isEmpty()) {
            FilterTransformerTreeTableNode preferred = null;
            if (parent instanceof FilterTransformerTreeTableNode) {
                preferred = (FilterTransformerTreeTableNode)parent;
            } else {
                this.findPreferred(IteratorUtil.removeIteratorVariables(target, parent));
                if (this.preferredPath != null) {
                    preferred = (FilterTransformerTreeTableNode)((Object)this.preferredPath.getLastPathComponent());
                }
            }
            if (preferred != null) {
                for (IteratorEntry entry : this.iteratorEntries) {
                    if (!Objects.equals(entry.getPath().getLastPathComponent(), (Object)preferred)) continue;
                    selectedEntry = entry;
                    break;
                }
                if (selectedEntry != null) {
                    this.iteratorComboBox.setSelectedItem(selectedEntry);
                }
            }
        }
        if (selectedEntry != null || this.targetComponents.isEmpty()) {
            this.chooseExistingRadio.setSelected(true);
            this.iteratorRadioActionPerformed(false);
        } else {
            this.createNewRadio.setSelected(true);
            this.iteratorRadioActionPerformed(true);
        }
        if (!this.targetComponents.isEmpty()) {
            int i;
            int minIndex = 0;
            if (!this.ancestorIndexVariables.isEmpty()) {
                minIndex = this.targetComponents.size();
                int i2 = this.targetComponents.size() - 1;
                while (i2 >= 0 && !this.ancestorIndexVariables.contains(this.targetComponents.get(i2).getPropertyName())) {
                    minIndex = i2--;
                }
            }
            int index = -1;
            for (i = minIndex; !(i >= this.targetComponentRadioButtons.size() || this.targetComponentRadioButtons.get(i).isVisible() && (index = i) > 0); ++i) {
            }
            if (index < 0) {
                for (i = 0; !(i >= minIndex || this.targetComponentRadioButtons.get(i).isVisible() && (index = i) > 0); ++i) {
                }
            }
            if (index >= 0) {
                this.targetComponentRadioButtons.get(index).setSelected(true);
                this.targetComponentRadioButtonActionPerformed(index);
            }
            if (!(this.outboundComponents.isEmpty() || index < this.outboundComponents.size() && this.outboundComponentRadioButtons.get(index).isVisible())) {
                for (i = 0; i < this.outboundComponentRadioButtons.size(); ++i) {
                    if (!this.outboundComponentRadioButtons.get(i).isVisible()) continue;
                    this.outboundComponentRadioButtons.get(i).setSelected(true);
                    this.outboundComponentRadioButtonActionPerformed(i);
                    break;
                }
            }
        }
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo((Component)((Object)PlatformUI.MIRTH_FRAME));
        this.okButton.requestFocus();
        this.setVisible(true);
    }

    private void fillIteratorEntries() {
        Enumeration en = this.root.children();
        while (en.hasMoreElements()) {
            this.fillIteratorEntries((TreeTableNode)en.nextElement(), 0);
        }
    }

    private void fillIteratorEntries(TreeTableNode parent, int depth) {
        if (parent instanceof FilterTransformerTreeTableNode && ((FilterTransformerTreeTableNode)parent).isIteratorNode() && (this.selectedNode == null || !Objects.equals(parent, this.selectedNode))) {
            this.iteratorEntries.add(new IteratorEntry(new TreePath(this.treeTableModel.getPathToRoot(parent)), depth));
            Enumeration en = parent.children();
            while (en.hasMoreElements()) {
                this.fillIteratorEntries((TreeTableNode)en.nextElement(), depth + 1);
            }
        }
    }

    private void findPreferred(String expression) {
        Enumeration en = this.root.children();
        while (en.hasMoreElements()) {
            this.findPreferred((TreeTableNode)en.nextElement(), expression, 0);
        }
    }

    private void findPreferred(TreeTableNode parent, String expression, int depth) {
        FilterTransformerTreeTableNode node;
        if (parent instanceof FilterTransformerTreeTableNode && (this.selectedNode == null || !Objects.equals(parent, this.selectedNode)) && (node = (FilterTransformerTreeTableNode)parent).isIteratorNode()) {
            IteratorElement iterator = (IteratorElement)node.getElement();
            for (String prefix : iterator.getProperties().getPrefixSubstitutions()) {
                if (!StringUtils.startsWith((CharSequence)expression, (CharSequence)prefix)) continue;
                if (depth > this.preferredMaxDepth) {
                    this.preferredPath = new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)node));
                    this.preferredMaxDepth = depth;
                }
                String replaced = prefix + "[" + iterator.getProperties().getIndexVariable() + "]" + StringUtils.removeStart((String)expression, (String)prefix);
                Enumeration en = parent.children();
                while (en.hasMoreElements()) {
                    this.findPreferred((TreeTableNode)en.nextElement(), replaced, depth + 1);
                }
            }
        }
    }

    public boolean wasAccepted() {
        return this.accepted;
    }

    public boolean isCreateNew() {
        return this.iteratorEntries.isEmpty() || this.createNewRadio.isSelected();
    }

    public FilterTransformerTreeTableNode<T, C> getSelectedParent() {
        IteratorEntry entry = (IteratorEntry)this.iteratorComboBox.getSelectedItem();
        return (FilterTransformerTreeTableNode)((Object)entry.getPath().getLastPathComponent());
    }

    public void fillIteratorProperties(IteratorProperties<C> props) {
        if (!this.targetComponents.isEmpty()) {
            int i;
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < this.targetComponentRadioButtons.size(); ++i) {
                builder.append(this.targetComponents.get(i).getValue());
                if (this.targetComponentRadioButtons.get(i).isSelected()) break;
            }
            props.setTarget(builder.toString());
            props.getPrefixSubstitutions().add(props.getTarget());
            if (!this.outboundComponents.isEmpty()) {
                builder = new StringBuilder();
                for (i = 0; i < this.outboundComponentRadioButtons.size(); ++i) {
                    builder.append(this.outboundComponents.get(i).getValue());
                    if (this.outboundComponentRadioButtons.get(i).isSelected()) break;
                }
                props.getPrefixSubstitutions().add(builder.toString());
            } else if (StringUtils.equals((CharSequence)this.targetComponents.get(0).getValue(), (CharSequence)"msg") && StringUtils.startsWith((CharSequence)props.getTarget(), (CharSequence)"msg")) {
                props.getPrefixSubstitutions().add("tmp" + StringUtils.removeStart((String)props.getTarget(), (String)"msg"));
            }
        }
        props.setIndexVariable(this.indexVariable);
    }

    private void initComponents() {
        this.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        this.getContentPane().setBackground(this.getBackground());
        ButtonGroup selectIteratorButtonGroup = new ButtonGroup();
        this.createNewRadio = new JRadioButton("Create New Iterator");
        this.createNewRadio.setBackground(this.getBackground());
        this.createNewRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IteratorWizardDialog.this.iteratorRadioActionPerformed(true);
            }
        });
        selectIteratorButtonGroup.add(this.createNewRadio);
        this.chooseExistingRadio = new JRadioButton("Choose Existing Iterator");
        this.chooseExistingRadio.setBackground(this.getBackground());
        this.chooseExistingRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IteratorWizardDialog.this.iteratorRadioActionPerformed(false);
            }
        });
        selectIteratorButtonGroup.add(this.chooseExistingRadio);
        this.iteratorComboBox = new JComboBox<IteratorEntry>(new Vector<IteratorEntry>(this.iteratorEntries));
        this.createNewWarningLabel = new JLabel("<html>Not enough information available to select iteration target. A new blank Iterator will be added.</html>");
        this.createNewWarningLabel.setVisible(false);
        this.createNewPanel = new JPanel();
        this.createNewPanel.setBackground(this.getBackground());
        this.targetLabel = new JLabel("Select the part of the object to iterate on:");
        this.targetComponentLabels = new ArrayList<JLabel>();
        this.targetComponentRadioButtons = new ArrayList<JRadioButton>();
        ButtonGroup targetButtonGroup = new ButtonGroup();
        for (int i = 0; i < this.targetComponents.size(); ++i) {
            final int index = i;
            JavaScriptSharedUtil.ExprPart component = this.targetComponents.get(index);
            JLabel label = new JLabel(component.getValue());
            this.targetComponentLabels.add(label);
            JRadioButton radioButton = new JRadioButton();
            radioButton.setBackground(this.getBackground());
            radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    IteratorWizardDialog.this.targetComponentRadioButtonActionPerformed(index);
                }
            });
            if (i + 1 < this.targetComponents.size() && this.ancestorIndexVariables.contains(this.targetComponents.get(i + 1).getPropertyName())) {
                radioButton.setVisible(false);
                radioButton.setEnabled(false);
            } else {
                targetButtonGroup.add(radioButton);
            }
            this.targetComponentRadioButtons.add(radioButton);
        }
        this.targetPanel = new JPanel();
        this.targetPanel.setBackground(this.getBackground());
        this.targetScrollPane = new JScrollPane(this.targetPanel);
        this.targetScrollPane.setBorder(BorderFactory.createEmptyBorder());
        if (!this.outboundComponents.isEmpty()) {
            this.outboundLabel = new JLabel("Select the part of the outbound message to iterate through:");
            this.outboundComponentLabels = new ArrayList<JLabel>();
            this.outboundComponentRadioButtons = new ArrayList<JRadioButton>();
            ButtonGroup outboundButtonGroup = new ButtonGroup();
            for (int i = 0; i < this.outboundComponents.size(); ++i) {
                final int index = i;
                JavaScriptSharedUtil.ExprPart component = this.outboundComponents.get(index);
                JLabel label = new JLabel(component.getValue());
                this.outboundComponentLabels.add(label);
                JRadioButton radioButton = new JRadioButton();
                radioButton.setBackground(this.getBackground());
                radioButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        IteratorWizardDialog.this.outboundComponentRadioButtonActionPerformed(index);
                    }
                });
                if (i + 1 < this.outboundComponents.size() && this.ancestorIndexVariables.contains(this.outboundComponents.get(i + 1).getPropertyName())) {
                    radioButton.setVisible(false);
                    radioButton.setEnabled(false);
                } else {
                    outboundButtonGroup.add(radioButton);
                }
                this.outboundComponentRadioButtons.add(radioButton);
            }
            this.outboundPanel = new JPanel();
            this.outboundPanel.setBackground(this.getBackground());
            this.outboundScrollPane = new JScrollPane(this.outboundPanel);
            this.outboundScrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        this.substitutionsLabel = new JLabel("The following drag-and-drop substitutions will be made:");
        this.substitutionsTargetLabel1 = new JLabel();
        this.substitutionsTargetLabel2 = new JLabel(" -> ");
        this.substitutionsTargetLabel3 = new JLabel();
        this.substitutionsTargetIndexLabel = new JLabel("<html><b>[" + StringEscapeUtils.escapeHtml4((String)this.indexVariable) + "]</b></html>");
        this.substitutionsTargetIndexLabel.setForeground(GREEN);
        this.substitutionsTargetLabel4 = new JLabel();
        if (!this.outboundComponents.isEmpty()) {
            this.substitutionsOutboundLabel1 = new JLabel();
            this.substitutionsOutboundLabel2 = new JLabel(" -> ");
            this.substitutionsOutboundLabel3 = new JLabel();
            this.substitutionsOutboundIndexLabel = new JLabel("<html><b>[" + StringEscapeUtils.escapeHtml4((String)this.indexVariable) + "]</b></html>");
            this.substitutionsOutboundIndexLabel.setForeground(GREEN);
            this.substitutionsOutboundLabel4 = new JLabel();
        }
        this.substitutionsPanel = new JPanel();
        this.substitutionsPanel.setBackground(this.getBackground());
        this.substitutionsScrollPane = new JScrollPane(this.substitutionsPanel);
        this.substitutionsScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.separator = new JSeparator(0);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IteratorWizardDialog.this.accepted = true;
                IteratorWizardDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IteratorWizardDialog.this.dispose();
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3"));
        if (!this.iteratorEntries.isEmpty()) {
            this.add((Component)this.createNewRadio, "split 2");
            this.add(this.chooseExistingRadio);
            this.add(this.iteratorComboBox, "newline, sx, growx, w 100:");
        }
        this.add((Component)this.createNewWarningLabel, "newline, grow");
        this.createNewPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, gapx 0"));
        this.createNewPanel.add((Component)this.targetLabel, "sx");
        this.targetPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 0, gap 0"));
        for (JLabel label : this.targetComponentLabels) {
            this.targetPanel.add((Component)label, "align center");
        }
        for (int i = 0; i < this.targetComponentRadioButtons.size(); ++i) {
            this.targetPanel.add((Component)this.targetComponentRadioButtons.get(i), (i == 0 ? "newline, " : "") + "align center");
        }
        this.createNewPanel.add((Component)this.targetScrollPane, "newline, gapleft 30, growx, h 32:50, sx");
        if (!this.outboundComponents.isEmpty()) {
            this.createNewPanel.add((Component)this.outboundLabel, "newline, sx");
            this.outboundPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 0, gap 0"));
            for (JLabel label : this.outboundComponentLabels) {
                this.outboundPanel.add((Component)label, "align center");
            }
            for (int i = 0; i < this.outboundComponentRadioButtons.size(); ++i) {
                this.outboundPanel.add((Component)this.outboundComponentRadioButtons.get(i), (i == 0 ? "newline, " : "") + "align center");
            }
            this.createNewPanel.add((Component)this.outboundScrollPane, "newline, gapleft 30, growx, h 32:50, sx");
        }
        this.createNewPanel.add((Component)this.substitutionsLabel, "newline, sx");
        this.substitutionsPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 0, gap 0"));
        this.substitutionsPanel.add(this.substitutionsTargetLabel1);
        this.substitutionsPanel.add(this.substitutionsTargetLabel2);
        this.substitutionsPanel.add((Component)this.substitutionsTargetLabel3, "split 3, gapright 0");
        this.substitutionsPanel.add((Component)this.substitutionsTargetIndexLabel, "gapleft 0, gapright 0");
        this.substitutionsPanel.add((Component)this.substitutionsTargetLabel4, "gapleft 0");
        if (!this.outboundComponents.isEmpty()) {
            this.substitutionsPanel.add((Component)this.substitutionsOutboundLabel1, "newline");
            this.substitutionsPanel.add(this.substitutionsOutboundLabel2);
            this.substitutionsPanel.add((Component)this.substitutionsOutboundLabel3, "split 3, gapright 0");
            this.substitutionsPanel.add((Component)this.substitutionsOutboundIndexLabel, "gapleft 0, gapright 0");
            this.substitutionsPanel.add((Component)this.substitutionsOutboundLabel4, "gapleft 0");
        }
        this.createNewPanel.add((Component)this.substitutionsScrollPane, "newline, sx, growx, h " + (!this.outboundComponents.isEmpty() ? "32:50" : "14:32") + ", gapleft 30");
        this.add((Component)this.createNewPanel, "newline, grow");
        this.add((Component)new JPanel(), "newline, grow, sx, push, h 0:0");
        this.add((Component)this.separator, "newline, growx, sx, pushx");
        this.add((Component)this.okButton, "newline, right, sx, split 2, w 45!");
        this.add((Component)this.cancelButton, "w 45!");
    }

    private void targetComponentRadioButtonActionPerformed(int index) {
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        StringBuilder builder3 = new StringBuilder();
        this.substitutionsTargetIndexLabel.setVisible(false);
        for (int i = 0; i < this.targetComponents.size(); ++i) {
            JavaScriptSharedUtil.ExprPart component = this.targetComponents.get(i);
            JLabel label = this.targetComponentLabels.get(i);
            if (i <= index) {
                label.setText("<html><b>" + StringEscapeUtils.escapeHtml4((String)component.getValue()) + "</b></html>");
                label.setForeground(GREEN);
            } else {
                label.setText(component.getValue());
                label.setForeground(Color.BLACK);
            }
            builder1.append(component.getValue());
            if (i <= index) {
                builder2.append(component.getValue());
                if (i != index) continue;
                this.substitutionsTargetIndexLabel.setVisible(true);
                continue;
            }
            builder3.append(component.getValue());
        }
        this.substitutionsTargetLabel1.setText(builder1.toString());
        this.substitutionsTargetLabel3.setText(builder2.toString());
        this.substitutionsTargetLabel4.setText(builder3.toString());
        if (!this.outboundComponents.isEmpty() && index < this.outboundComponents.size() && this.outboundComponentRadioButtons.get(index).isVisible()) {
            this.outboundComponentRadioButtons.get(index).setSelected(true);
            this.outboundComponentRadioButtonActionPerformed(index);
        }
    }

    private void outboundComponentRadioButtonActionPerformed(int index) {
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        StringBuilder builder3 = new StringBuilder();
        this.substitutionsOutboundIndexLabel.setVisible(false);
        for (int i = 0; i < this.outboundComponents.size(); ++i) {
            JavaScriptSharedUtil.ExprPart component = this.outboundComponents.get(i);
            JLabel label = this.outboundComponentLabels.get(i);
            if (i <= index) {
                label.setText("<html><b>" + StringEscapeUtils.escapeHtml4((String)component.getValue()) + "</b></html>");
                label.setForeground(GREEN);
            } else {
                label.setText(component.getValue());
                label.setForeground(Color.BLACK);
            }
            builder1.append(component.getValue());
            if (i <= index) {
                builder2.append(component.getValue());
                if (i != index) continue;
                this.substitutionsOutboundIndexLabel.setVisible(true);
                continue;
            }
            builder3.append(component.getValue());
        }
        this.substitutionsOutboundLabel1.setText(builder1.toString());
        this.substitutionsOutboundLabel3.setText(builder2.toString());
        this.substitutionsOutboundLabel4.setText(builder3.toString());
    }

    private void iteratorRadioActionPerformed(boolean createNew) {
        if (this.iteratorComboBox != null) {
            this.iteratorComboBox.setVisible(!createNew);
        }
        this.createNewPanel.setVisible(createNew && !this.targetComponents.isEmpty());
        this.createNewWarningLabel.setVisible(createNew && this.targetComponents.isEmpty());
        if (createNew && !this.targetComponents.isEmpty()) {
            this.setPreferredSize(new Dimension(500, !this.outboundComponents.isEmpty() ? 326 : 236));
        } else {
            this.setPreferredSize(new Dimension(487, 139));
        }
        this.pack();
    }

    private class IteratorEntry {
        private TreePath path;
        private int depth;

        public IteratorEntry(TreePath path, int depth) {
            this.path = path;
            this.depth = depth;
        }

        public TreePath getPath() {
            return this.path;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public String toString() {
            return StringUtils.repeat((char)' ', (int)(Math.max(this.depth - 1, 0) * 8)) + (this.depth > 0 ? "    \u2014 " : "") + ((FilterTransformerTreeTableNode)((Object)this.path.getLastPathComponent())).getElement().getName();
        }
    }
}

