/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.commons.io.FileUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptEditorDialog
extends MirthDialog
implements DropTargetListener {
    private Frame parent;
    private String savedScript;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JButton okButton;
    private JButton openFileButton;
    private MirthRTextScrollPane scriptContent;
    private JButton validateScriptButton;

    public JavaScriptEditorDialog(String script) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
        this.initialize(script);
    }

    public JavaScriptEditorDialog(java.awt.Frame owner, String script) {
        super((Window)owner, true);
        this.initialize(script);
    }

    public JavaScriptEditorDialog(Dialog owner, String script) {
        super((Window)owner, true);
        this.initialize(script);
    }

    private void initialize(String script) {
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initComponents();
        this.scriptContent.setSaveEnabled(false);
        this.setSavedScript(script);
        this.scriptContent.setCaretPosition(0);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JavaScriptEditorDialog.this.cancelButtonActionPerformed(null);
            }
        });
        this.pack();
        new DropTarget((Component)((Object)this.scriptContent), this);
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.setVisible(true);
    }

    public String getSavedScript() {
        return this.savedScript;
    }

    public void setSavedScript(String script) {
        this.scriptContent.setText(script);
        this.savedScript = script;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iterator = fileList.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            } else {
                dtde.rejectDrag();
            }
        }
        catch (Exception e) {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : fileList) {
                    this.scriptContent.setText(this.scriptContent.getText() + FileUtils.readFileToString((File)file, (String)"UTF-8"));
                }
            }
        }
        catch (Exception e) {
            dtde.rejectDrop();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelButton = new JButton();
        this.validateScriptButton = new JButton();
        this.scriptContent = new MirthRTextScrollPane(ContextType.CHANNEL_BATCH, true);
        this.openFileButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Script");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Close this message sender dialog.");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptEditorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.validateScriptButton.setText("Validate Script");
        this.validateScriptButton.setToolTipText("Process the message displayed in the editor above.");
        this.validateScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptEditorDialog.this.validateScriptButtonActionPerformed(evt);
            }
        });
        this.scriptContent.setBorder(BorderFactory.createEtchedBorder());
        this.openFileButton.setText("Open File...");
        this.openFileButton.setToolTipText("Open a file into the editor above.");
        this.openFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptEditorDialog.this.openFileButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setToolTipText("Close this message sender dialog.");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptEditorDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.openFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.validateScriptButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent((Component)((Object)this.scriptContent), -1, 532, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent((Component)((Object)this.scriptContent), -1, 252, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.validateScriptButton).addComponent(this.openFileButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void openFileButtonActionPerformed(ActionEvent evt) {
        String content = this.parent.browseForFileString(null);
        if (content != null) {
            this.scriptContent.setText(content);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void validateScriptButtonActionPerformed(ActionEvent evt) {
        StringBuilder sb = new StringBuilder();
        Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
        try {
            context.compileString("function rhinoWrapper() {" + this.scriptContent.getText() + "\n}", PlatformUI.MIRTH_FRAME.mirthClient.getGuid(), 1, null);
            sb.append("JavaScript was successfully validated.");
        }
        catch (EvaluatorException e) {
            sb.append("Error on line " + e.lineNumber() + ": " + e.getMessage() + " of the current script.");
        }
        catch (Exception e) {
            sb.append("Unknown error occurred during validation.");
        }
        Context.exit();
        this.parent.alertInformation(this, sb.toString());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.savedScript = this.scriptContent.getText();
        this.dispose();
    }
}

