/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.TemplatePanel;
import com.mirth.connect.client.ui.TransformerType;
import com.mirth.connect.client.ui.TreePanel;
import com.mirth.connect.model.datatype.DataTypeProperties;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;

public class MessageTemplatePanel
extends JPanel {
    private ActionListener templateTitleListener;
    private JSplitPane split;
    private TemplatePanel templatePanelInbound;
    private TemplatePanel templatePanelOutbound;

    public MessageTemplatePanel() {
        this.initComponents();
    }

    public MessageTemplatePanel(ActionListener templateTitleListener) {
        this.templateTitleListener = templateTitleListener;
        this.initComponents();
        this.templatePanelInbound.setInbound(true);
        this.templatePanelOutbound.setInbound(false);
        try {
            this.split.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        MessageTemplatePanel.this.split.setDividerLocation(0.5);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.split.setOneTouchExpandable(true);
        ((TitledBorder)this.templatePanelInbound.getBorder()).setTitle("Inbound Message Template");
        ((TitledBorder)this.templatePanelOutbound.getBorder()).setTitle("Outbound Message Template");
    }

    public void setDataTypeEnabled(boolean inboundDataType, boolean inboundProperties, boolean outboundDataType, boolean outboundProperties, TransformerType transformerType) {
        this.templatePanelInbound.setDataTypeEnabled(inboundDataType, inboundProperties, transformerType);
        this.templatePanelOutbound.setDataTypeEnabled(outboundDataType, outboundProperties, transformerType);
    }

    public void hideOutbound() {
        this.split.setBottomComponent(null);
        this.split.setDividerSize(0);
        this.split.setOneTouchExpandable(false);
    }

    public void showOutbound() {
        this.split.setBottomComponent(this.templatePanelOutbound);
        this.split.setDividerSize(6);
        this.split.setDividerLocation(0.5);
        this.split.setResizeWeight(0.5);
        this.split.setOneTouchExpandable(true);
    }

    public void setInboundTreePanel(TreePanel tree) {
        this.templatePanelInbound.setTreePanel(tree);
    }

    public void setOutboundTreePanel(TreePanel tree) {
        this.templatePanelOutbound.setTreePanel(tree);
    }

    public TemplatePanel getInboundTemplatePanel() {
        return this.templatePanelInbound;
    }

    public TemplatePanel getOutboundTemplatePanel() {
        return this.templatePanelOutbound;
    }

    public String getInboundMessage() {
        return this.templatePanelInbound.getMessage();
    }

    public String getOutboundMessage() {
        return this.templatePanelOutbound.getMessage();
    }

    public void setInboundMessage(String msg) {
        this.templatePanelInbound.setMessage(msg);
    }

    public void setOutboundMessage(String msg) {
        this.templatePanelOutbound.setMessage(msg);
    }

    public void clearInboundMessage() {
        this.templatePanelInbound.clearMessage();
    }

    public void clearOutboundMessage() {
        this.templatePanelOutbound.clearMessage();
    }

    public void setInboundDataType(String dataType) {
        this.templatePanelInbound.setDataType(dataType);
    }

    public void setOutboundDataType(String dataType) {
        this.templatePanelOutbound.setDataType(dataType);
    }

    public String getInboundDataType() {
        return this.templatePanelInbound.getDataType();
    }

    public String getOutboundDataType() {
        return this.templatePanelOutbound.getDataType();
    }

    public DataTypeProperties getInboundDataProperties() {
        return this.templatePanelInbound.getDataProperties();
    }

    public DataTypeProperties getOutboundDataProperties() {
        return this.templatePanelOutbound.getDataProperties();
    }

    public void setInboundDataProperties(DataTypeProperties p) {
        this.templatePanelInbound.setDataProperties(p);
    }

    public void setOutboundDataProperties(DataTypeProperties p) {
        this.templatePanelOutbound.setDataProperties(p);
    }

    public void resizePanes() {
        this.split.setDividerLocation(0.5);
        this.split.setResizeWeight(0.5);
    }

    private void initComponents() {
        this.split = new JSplitPane();
        this.templatePanelInbound = new TemplatePanel(this.templateTitleListener);
        this.templatePanelOutbound = new TemplatePanel(this.templateTitleListener);
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.split.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.split.setOrientation(0);
        this.split.setLeftComponent(this.templatePanelInbound);
        this.split.setRightComponent(this.templatePanelOutbound);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.split, GroupLayout.Alignment.TRAILING, -1, 288, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.split, GroupLayout.Alignment.TRAILING, -2, 500, Short.MAX_VALUE));
    }
}

