/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors;

import com.mirth.connect.client.ui.FunctionList;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TransformerType;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.VariableListHandler;
import com.mirth.connect.client.ui.editors.BaseEditorPane;
import com.mirth.connect.client.ui.editors.MessageTemplatePanel;
import com.mirth.connect.client.ui.editors.MessageTreePanel;
import com.mirth.connect.client.ui.panels.reference.VariableReferenceTable;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.model.datatype.DataTypeProperties;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class TabbedTemplatePanel
extends JPanel {
    private ContextType contextType;
    private BaseEditorPane<?, ?> editorPane;
    private JTabbedPane tabbedPane;
    private JPanel referencePanel;
    private JSplitPane referenceSplitPane;
    private Map<ContextType, FunctionList> functionListMap;
    private JScrollPane variableListScrollPane;
    private VariableReferenceTable variableTable;
    private MessageTreePanel messageTreePanel;
    private MessageTemplatePanel messageTemplatePanel;

    public TabbedTemplatePanel(BaseEditorPane<?, ?> editorPane) {
        this.editorPane = editorPane;
        this.initComponents();
        this.initLayout();
    }

    public void setFilterView() {
        this.messageTreePanel.hideOutbound();
        this.messageTemplatePanel.hideOutbound();
        this.messageTreePanel.getInboundTreePanel().setFilterView();
        this.messageTreePanel.getOutboundTreePanel().setFilterView();
    }

    public void setTransformerView() {
        this.messageTreePanel.showOutbound();
        this.messageTemplatePanel.showOutbound();
        this.messageTreePanel.getInboundTreePanel().setTransformerView();
        this.messageTreePanel.getOutboundTreePanel().setTransformerView();
    }

    public void setSourceView() {
        boolean inboundEnabled = true;
        if (PlatformUI.MIRTH_FRAME.channelEditPanel.getRequiredInboundDataType() != null) {
            inboundEnabled = false;
        }
        boolean outboundEnabled = true;
        if (PlatformUI.MIRTH_FRAME.channelEditPanel.getRequiredOutboundDataType() != null) {
            outboundEnabled = false;
        }
        this.messageTemplatePanel.setDataTypeEnabled(inboundEnabled, true, outboundEnabled, true, TransformerType.SOURCE);
        this.setContextType(ContextType.SOURCE_FILTER_TRANSFORMER);
    }

    public void setDestinationView(boolean isResponse) {
        this.messageTemplatePanel.setDataTypeEnabled(isResponse, true, true, true, isResponse ? TransformerType.RESPONSE : TransformerType.DESTINATION);
        this.setContextType(isResponse ? ContextType.DESTINATION_RESPONSE_TRANSFORMER : ContextType.DESTINATION_FILTER_TRANSFORMER);
    }

    public void resizePanes() {
        this.referenceSplitPane.setDividerLocation(0.5);
        this.referenceSplitPane.setResizeWeight(0.5);
        this.messageTreePanel.resizePanes();
        this.messageTemplatePanel.resizePanes();
    }

    public void updateVariables(Set<String> rules, Set<String> steps) {
        if (rules != null && steps != null) {
            rules.addAll(steps);
        }
        this.variableTable.updateVariables(rules);
    }

    public void populateConnectors(List<Connector> connectors) {
        ((VariableListHandler)this.variableTable.getTransferHandler()).populateConnectors(connectors);
    }

    public String getIncomingMessage() {
        return this.messageTemplatePanel.getInboundMessage();
    }

    public void setIncomingMessage(String msg) {
        this.messageTemplatePanel.setInboundMessage(msg);
    }

    public String getOutgoingMessage() {
        return this.messageTemplatePanel.getOutboundMessage();
    }

    public void setOutgoingMessage(String msg) {
        this.messageTemplatePanel.setOutboundMessage(msg);
    }

    public void setIncomingDataType(String dataType) {
        this.messageTemplatePanel.setInboundDataType(dataType);
    }

    public void setOutgoingDataType(String dataType) {
        this.messageTemplatePanel.setOutboundDataType(dataType);
    }

    public String getIncomingDataType() {
        return this.messageTemplatePanel.getInboundDataType();
    }

    public String getOutgoingDataType() {
        return this.messageTemplatePanel.getOutboundDataType();
    }

    public void setIncomingDataProperties(DataTypeProperties properties) {
        this.messageTemplatePanel.setInboundDataProperties(properties);
    }

    public void setOutgoingDataProperties(DataTypeProperties properties) {
        this.messageTemplatePanel.setOutboundDataProperties(properties);
    }

    public DataTypeProperties getIncomingDataProperties() {
        return this.messageTemplatePanel.getInboundDataProperties();
    }

    public DataTypeProperties getOutgoingDataProperties() {
        return this.messageTemplatePanel.getOutboundDataProperties();
    }

    public void setDefaultComponent() {
        this.tabbedPane.setSelectedIndex(0);
        this.functionListMap.get(this.contextType).setDefaultDropDownValue();
    }

    public void setContextType(ContextType contextType) {
        this.contextType = contextType;
        FunctionList functionList = this.functionListMap.get(contextType);
        if (functionList == null) {
            functionList = new FunctionList(contextType);
            functionList.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.functionListMap.put(contextType, functionList);
        }
        this.referenceSplitPane.setTopComponent(functionList);
    }

    public MessageTemplatePanel getMessageTemplatePanel() {
        return this.messageTemplatePanel;
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.referencePanel = new JPanel();
        this.referencePanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.referenceSplitPane = new JSplitPane();
        this.referenceSplitPane.setBackground(this.referencePanel.getBackground());
        this.referenceSplitPane.setBorder(null);
        this.referenceSplitPane.setOrientation(0);
        this.functionListMap = new HashMap<ContextType, FunctionList>();
        this.variableTable = new VariableReferenceTable("Available Variables", new String[0]);
        this.variableTable.setDragEnabled(true);
        this.variableTable.setTransferHandler(new VariableListHandler(VariableListHandler.TransferMode.JAVASCRIPT));
        this.variableListScrollPane = new JScrollPane((Component)((Object)this.variableTable));
        this.messageTreePanel = new MessageTreePanel(this.editorPane);
        ActionListener templateTitleListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!StringUtils.equals((CharSequence)TabbedTemplatePanel.this.tabbedPane.getTitleAt(2), (CharSequence)evt.getActionCommand())) {
                    TabbedTemplatePanel.this.tabbedPane.setTitleAt(2, evt.getActionCommand());
                }
            }
        };
        this.messageTemplatePanel = new MessageTemplatePanel(templateTitleListener);
        this.messageTemplatePanel.setInboundTreePanel(this.messageTreePanel.getInboundTreePanel());
        this.messageTemplatePanel.setOutboundTreePanel(this.messageTreePanel.getOutboundTreePanel());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.referencePanel.setLayout((LayoutManager)new MigLayout("insets 12 0 0 0, novisualpadding, hidemode 3, fill"));
        this.referenceSplitPane.setBottomComponent(this.variableListScrollPane);
        this.referencePanel.add((Component)this.referenceSplitPane, "grow");
        this.tabbedPane.addTab("Reference", this.referencePanel);
        this.tabbedPane.addTab("Message Trees", this.messageTreePanel);
        this.tabbedPane.addTab("Message Templates", this.messageTemplatePanel);
        this.add((Component)this.tabbedPane, "grow");
    }
}

