/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors.filter;

import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.RuleDropData;
import com.mirth.connect.client.ui.TreeTransferable;
import com.mirth.connect.client.ui.components.MirthTree;
import com.mirth.connect.client.ui.editors.BaseEditorPane;
import com.mirth.connect.client.ui.editors.FilterTreeTableNode;
import com.mirth.connect.client.ui.util.VariableListUtil;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.Filter;
import com.mirth.connect.model.IteratorRule;
import com.mirth.connect.model.Rule;
import com.mirth.connect.model.datatype.DataTypeProperties;
import com.mirth.connect.plugins.FilterRulePlugin;
import com.mirth.connect.plugins.FilterTransformerTypePlugin;
import com.mirth.connect.plugins.IteratorRulePlugin;
import com.mirth.connect.util.StringUtil;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class FilterPane
extends BaseEditorPane<Filter, Rule> {
    public static final String RULE_BUILDER = "Rule Builder";
    private Map<String, FilterTransformerTypePlugin<Filter, Rule>> sourcePlugins;
    private Map<String, FilterTransformerTypePlugin<Filter, Rule>> destinationPlugins;
    private IteratorRulePlugin iteratorPlugin;
    private String originalInboundDataType;
    private DataTypeProperties originalInboundDataTypeProperties;
    private String originalInboundTemplate;

    @Override
    protected Class<?> getContainerClass() {
        return Filter.class;
    }

    @Override
    protected String getContainerName() {
        return "Filter";
    }

    @Override
    protected String getElementName() {
        return "Rule";
    }

    @Override
    protected boolean allowOperatorEdit(int rowIndex, int columnIndex) {
        TreePath path = this.treeTable.getPathForRow(rowIndex);
        if (path != null) {
            TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
            return node.getParent().getIndex((TreeNode)node) > 0;
        }
        return false;
    }

    @Override
    protected void updateTable() {
        this.updateOperations();
    }

    private void updateOperations() {
        this.updateOperations(this.treeTableModel.getRoot());
    }

    private void updateOperations(TreeTableNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeTableNode child = node.getChildAt(i);
            BaseEditorPane.OperatorNamePair pair = (BaseEditorPane.OperatorNamePair)((Object)this.treeTableModel.getValueAt((Object)child, this.nameColumn));
            if (i == 0) {
                this.treeTableModel.setValueAt((Object)new BaseEditorPane.OperatorNamePair(null, pair.getName()), (Object)child, this.nameColumn);
            } else if (pair.getOperator() == null) {
                this.treeTableModel.setValueAt((Object)new BaseEditorPane.OperatorNamePair(Rule.Operator.AND, pair.getName()), (Object)child, this.nameColumn);
            }
            this.updateOperations(child);
        }
    }

    @Override
    protected boolean useOperatorColumn() {
        return true;
    }

    @Override
    protected Object getOperator(Rule element) {
        return element.getOperator();
    }

    @Override
    protected void setOperator(Rule element, Object value) {
        element.setOperator((Rule.Operator)value);
    }

    @Override
    protected Map<String, FilterTransformerTypePlugin<Filter, Rule>> getPlugins() {
        if (this.sourcePlugins == null || this.destinationPlugins == null) {
            this.sourcePlugins = new TreeMap<String, FilterTransformerTypePlugin<Filter, Rule>>();
            this.destinationPlugins = new TreeMap<String, FilterTransformerTypePlugin<Filter, Rule>>();
            for (Map.Entry<String, FilterRulePlugin> entry : LoadedExtensions.getInstance().getFilterRulePlugins().entrySet()) {
                this.sourcePlugins.put(entry.getKey(), entry.getValue());
                if (entry.getValue().onlySourceConnector()) continue;
                this.destinationPlugins.put(entry.getKey(), entry.getValue());
            }
            if (this.iteratorPlugin == null) {
                this.iteratorPlugin = new IteratorRulePlugin("Iterator");
            }
            this.sourcePlugins.put(this.iteratorPlugin.getPluginPointName(), this.iteratorPlugin);
            this.destinationPlugins.put(this.iteratorPlugin.getPluginPointName(), this.iteratorPlugin);
        }
        if (this.getConnector() != null && this.getConnector().getMetaDataId() == 0) {
            return this.sourcePlugins;
        }
        return this.destinationPlugins;
    }

    protected FilterTreeTableNode createTreeTableNode(Rule element) {
        FilterTreeTableNode node = new FilterTreeTableNode(this, element);
        if (element instanceof IteratorRule) {
            for (Rule child : ((IteratorRule)element).getProperties().getChildren()) {
                node.add((MutableTreeTableNode)this.createTreeTableNode(child));
            }
        }
        return node;
    }

    @Override
    protected void doAccept(Connector connector, Filter properties, boolean response) {
        connector.setFilter(properties);
        connector.getTransformer().setInboundDataType(this.getInboundDataType());
        connector.getTransformer().setInboundProperties(this.getInboundDataTypeProperties());
        connector.getTransformer().setInboundTemplate(this.getInboundTemplate());
    }

    @Override
    public Filter getProperties() {
        Filter props = new Filter();
        props.setElements(this.getElements());
        return props;
    }

    @Override
    public void doSetProperties(Connector connector, Filter properties, boolean response, boolean overwriteOriginal) {
        if (overwriteOriginal) {
            this.originalInboundDataType = connector.getTransformer().getInboundDataType();
            this.originalInboundDataTypeProperties = connector.getTransformer().getInboundProperties().clone();
            this.originalInboundTemplate = connector.getTransformer().getInboundTemplate();
        }
        this.setElements(properties.getElements());
        this.setInboundDataType(connector.getTransformer().getInboundDataType());
        this.setInboundDataTypeProperties(connector.getTransformer().getInboundProperties());
        this.setInboundTemplate(connector.getTransformer().getInboundTemplate());
        this.templatePanel.setFilterView();
    }

    @Override
    protected boolean isModified(Filter properties) {
        return super.isModified(properties) || !StringUtils.equals((CharSequence)this.originalInboundDataType, (CharSequence)this.getInboundDataType()) || !Objects.equals(this.originalInboundDataTypeProperties, this.getInboundDataTypeProperties()) || !StringUtil.equalsIgnoreNull((String)this.originalInboundTemplate, (String)this.getInboundTemplate());
    }

    @Override
    public void addNewElement() {
        this.addNewElement("", "", "", RULE_BUILDER);
    }

    @Override
    protected void getRuleVariables(Connector connector, Set<String> concatenatedRules, boolean includeLocalVars) {
        VariableListUtil.getRuleVariables(concatenatedRules, this.getProperties(), includeLocalVars);
    }

    @Override
    protected void getStepVariables(Connector connector, Set<String> concatenatedSteps, boolean includeLocalVars, int viewRow) {
        VariableListUtil.getStepVariables(concatenatedSteps, connector.getTransformer(), includeLocalVars, viewRow);
    }

    @Override
    protected boolean handleDragEnter(DropTargetDragEvent dtde, Transferable tr) throws UnsupportedFlavorException, IOException {
        if (tr.isDataFlavorSupported(TreeTransferable.RULE_DATA_FLAVOR)) {
            dtde.acceptDrag(3);
            return true;
        }
        return false;
    }

    @Override
    protected void handleDrop(DropTargetDropEvent dtde, Transferable tr) throws UnsupportedFlavorException, IOException {
        Object transferData;
        if (tr.isDataFlavorSupported(TreeTransferable.RULE_DATA_FLAVOR) && (transferData = tr.getTransferData(TreeTransferable.RULE_DATA_FLAVOR)) instanceof RuleDropData) {
            RuleDropData data = (RuleDropData)transferData;
            this.addNewElement(MirthTree.constructNodeDescription(data.getNode()), "", data.getMapping(), RULE_BUILDER, true);
        }
    }
}

