/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.editors.filter;

import com.mirth.connect.client.ui.editors.IteratorPanel;
import com.mirth.connect.model.IteratorElement;
import com.mirth.connect.model.IteratorRule;
import com.mirth.connect.model.Rule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.apache.commons.lang3.text.WordUtils;

public class IteratorRulePanel
extends IteratorPanel<Rule> {
    private JLabel acceptMessageLabel;
    private JComboBox<AcceptMessageValue> acceptMessageComboBox;
    private JLabel acceptMessageLabel2;
    private JLabel breakEarlyLabel;
    private JRadioButton breakEarlyYesRadio;
    private JRadioButton breakEarlyNoRadio;

    @Override
    public Rule getDefaults() {
        IteratorRule rule;
        rule.setName(this.getName("...", (rule = new IteratorRule()).getProperties().isIntersectIterations() ? AcceptMessageValue.ALL : AcceptMessageValue.AT_LEAST_ONE));
        return rule;
    }

    @Override
    protected IteratorElement<Rule> newIteratorElement() {
        return new IteratorRule();
    }

    @Override
    public Rule getProperties() {
        IteratorRule props = (IteratorRule)super.getProperties();
        props.getProperties().setIntersectIterations((AcceptMessageValue)((Object)this.acceptMessageComboBox.getSelectedItem()) == AcceptMessageValue.ALL);
        props.getProperties().setBreakEarly(this.breakEarlyYesRadio.isSelected());
        return props;
    }

    @Override
    public void setProperties(Rule properties) {
        super.setProperties(properties);
        IteratorRule props = (IteratorRule)properties;
        if (props.getProperties().isIntersectIterations()) {
            this.acceptMessageComboBox.setSelectedItem((Object)AcceptMessageValue.ALL);
        } else {
            this.acceptMessageComboBox.setSelectedItem((Object)AcceptMessageValue.AT_LEAST_ONE);
        }
        if (props.getProperties().isBreakEarly()) {
            this.breakEarlyYesRadio.setSelected(true);
        } else {
            this.breakEarlyNoRadio.setSelected(true);
        }
    }

    @Override
    protected String getName(String target) {
        return this.getName(target, (AcceptMessageValue)((Object)this.acceptMessageComboBox.getSelectedItem()));
    }

    @Override
    public void setName(IteratorElement<Rule> properties) {
        IteratorRule props = (IteratorRule)properties;
        props.setName(this.getName(props.getProperties().getTarget(), props.getProperties().isIntersectIterations() ? AcceptMessageValue.ALL : AcceptMessageValue.AT_LEAST_ONE));
    }

    private String getName(String target, AcceptMessageValue acceptMessageValue) {
        StringBuilder name = new StringBuilder();
        name.append("Accept message if ").append(acceptMessageValue.toString().toLowerCase()).append(" of the iterations return");
        if (acceptMessageValue == AcceptMessageValue.AT_LEAST_ONE) {
            name.append('s');
        }
        name.append(" true for each ").append(target);
        return name.toString();
    }

    @Override
    protected void initComponents() {
        this.acceptMessageLabel = new JLabel("Accept Message If:");
        this.acceptMessageComboBox = new JComboBox<AcceptMessageValue>(AcceptMessageValue.values());
        this.acceptMessageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (IteratorRulePanel.this.acceptMessageComboBox.getSelectedItem() == AcceptMessageValue.ALL) {
                    IteratorRulePanel.this.acceptMessageLabel2.setText("<html>of the iterations return <b>true</b></html>");
                } else {
                    IteratorRulePanel.this.acceptMessageLabel2.setText("<html>of the iterations returns <b>true</b></html>");
                }
                IteratorRulePanel.this.updateName();
            }
        });
        this.acceptMessageLabel2 = new JLabel("<html>of the iterations returns <b>true</b></html>");
        this.breakEarlyLabel = new JLabel("Break Early:");
        ButtonGroup breakEarlyButtonGroup = new ButtonGroup();
        String toolTipText = "<html>If this is enabled, the iterator loop will terminate<br/>as quickly as possible. For example if \"At Least One\"<br/>is chosen above, the loop will terminate as soon as<br/>the first iteration returns <b>true</b>.</html>";
        this.breakEarlyYesRadio = new JRadioButton("Yes");
        this.breakEarlyYesRadio.setBackground(this.getBackground());
        this.breakEarlyYesRadio.setToolTipText(toolTipText);
        breakEarlyButtonGroup.add(this.breakEarlyYesRadio);
        this.breakEarlyNoRadio = new JRadioButton("No");
        this.breakEarlyNoRadio.setBackground(this.getBackground());
        this.breakEarlyNoRadio.setToolTipText(toolTipText);
        breakEarlyButtonGroup.add(this.breakEarlyNoRadio);
    }

    @Override
    protected void addMiddleComponents() {
        this.add((Component)this.acceptMessageLabel, "newline, right, gapafter 6");
        this.add(this.acceptMessageComboBox, "split 2");
        this.add(this.acceptMessageLabel2);
        this.add((Component)this.breakEarlyLabel, "newline, right, gapafter 6");
        this.add((Component)this.breakEarlyYesRadio, "split 2");
        this.add(this.breakEarlyNoRadio);
    }

    private static enum AcceptMessageValue {
        AT_LEAST_ONE,
        ALL;


        public String toString() {
            return WordUtils.capitalizeFully((String)super.toString().replace('_', ' '));
        }
    }
}

