/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.extensionmanager;

import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.donkey.util.ResourceUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.UUID;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ExtensionUtil {
    public String getURLContents(String address) {
        StringBuilder builder = new StringBuilder();
        try {
            URL url = new URL(address);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String str = null;
            while ((str = in.readLine()) != null) {
                builder.append(str);
                builder.append("\r\n");
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.toString();
    }

    public String getDynamicURL(String url, String pluginVersion, String name) {
        return url.replaceAll("\\$\\{mirthVersion\\}", PlatformUI.SERVER_VERSION).replaceAll("\\$\\{version\\}", pluginVersion).replaceAll("\\$\\{name\\}", URLEncoder.encode(name)).replaceAll("\\$\\{serverid\\}", PlatformUI.SERVER_ID);
    }

    public String getDynamicURL(String url, String pluginVersion, String name, String id) {
        return url.replaceAll("\\$\\{mirthVersion\\}", PlatformUI.SERVER_VERSION).replaceAll("\\$\\{version\\}", pluginVersion).replaceAll("\\$\\{name\\}", URLEncoder.encode(name)).replaceAll("\\$\\{serverid\\}", PlatformUI.SERVER_ID).replaceAll("\\$\\{id\\}", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadFileToDisk(String address, JLabel statusLabel, JProgressBar progressBar) {
        block11: {
            File file;
            InputStream in = null;
            FileOutputStream out = null;
            DecimalFormat formatter = new DecimalFormat("#.00");
            try {
                int input;
                File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".zip");
                URL url = new URL(address);
                out = new FileOutputStream(tempFile);
                URLConnection connection = url.openConnection();
                int length = connection.getContentLength();
                in = connection.getInputStream();
                if (length != -1) {
                    progressBar.setMaximum(length);
                } else {
                    progressBar.setIndeterminate(true);
                }
                byte[] buffer = new byte[1024];
                float output = 0.0f;
                while ((input = in.read(buffer)) != -1) {
                    out.write(buffer, 0, input);
                    output += (float)input;
                    if (length != -1) {
                        progressBar.setValue(progressBar.getValue() + input);
                        statusLabel.setText("Downloaded: " + formatter.format(output / 1000.0f) + " Kbytes/" + formatter.format(length / 1000) + " Kbytes");
                        continue;
                    }
                    statusLabel.setText("Downloaded: " + formatter.format(output / 1000.0f) + " Kbytes");
                }
                if (length != -1) {
                    progressBar.setValue(0);
                } else {
                    progressBar.setIndeterminate(false);
                }
                file = tempFile;
                ResourceUtil.closeResourceQuietly((Closeable)in);
            }
            catch (Exception e) {
                statusLabel.setText("Could not download file.");
                break block11;
            }
            finally {
                ResourceUtil.closeResourceQuietly(in);
                ResourceUtil.closeResourceQuietly(out);
            }
            ResourceUtil.closeResourceQuietly((Closeable)out);
            return file;
        }
        return null;
    }
}

