/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.connectors;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorPanel;
import com.mirth.connect.client.ui.util.PortUsageDialog;
import com.mirth.connect.donkey.model.channel.ListenerConnectorProperties;
import com.mirth.connect.donkey.model.channel.ListenerConnectorPropertiesInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ListenerSettingsPanel
extends JPanel {
    public static final String FIELD_PORT = ListenerSettingsPanel.class.getSimpleName() + ".PORT";
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private MirthTextField addressField;
    private JLabel addressLabel;
    private MirthRadioButton allRadio;
    private ButtonGroup listenerButtonGroup;
    private MirthTextField portField;
    private JLabel portLabel;
    private MirthRadioButton specificRadio;
    private JButton portsInUse;

    public ListenerSettingsPanel() {
        this.initComponents();
        this.initLayout();
    }

    public void setProperties(ListenerConnectorPropertiesInterface propertiesInterface) {
        ListenerConnectorProperties properties = propertiesInterface.getListenerConnectorProperties();
        this.addressField.setText(properties.getHost());
        this.updateAddressRadio();
        this.portField.setText(properties.getPort());
    }

    public void fillProperties(ListenerConnectorPropertiesInterface propertiesInterface) {
        ListenerConnectorProperties properties = propertiesInterface.getListenerConnectorProperties();
        properties.setHost(this.addressField.getText());
        properties.setPort(this.portField.getText());
    }

    public boolean checkProperties(ListenerConnectorPropertiesInterface propertiesInterface, boolean highlight) {
        ListenerConnectorProperties properties = propertiesInterface.getListenerConnectorProperties();
        boolean valid = true;
        if (properties.getHost().length() == 0) {
            valid = false;
            if (highlight) {
                this.addressField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (properties.getPort().length() == 0) {
            valid = false;
            if (highlight) {
                this.portField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.addressField.setBackground(null);
        this.portField.setBackground(null);
    }

    private void updateAddressRadio() {
        if (this.addressField.getText().equals(new ListenerConnectorProperties(null).getHost())) {
            this.allRadio.setSelected(true);
            this.allRadioActionPerformed(null);
        } else {
            this.specificRadio.setSelected(true);
            this.specificRadioActionPerformed(null);
        }
    }

    private void initComponents() {
        this.listenerButtonGroup = new ButtonGroup();
        this.addressLabel = new JLabel();
        this.allRadio = new MirthRadioButton();
        this.specificRadio = new MirthRadioButton();
        this.addressField = new MirthTextField();
        this.portLabel = new JLabel();
        this.portField = new MirthTextField();
        this.portsInUse = new JButton();
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Listener Settings", 0, 0, new Font("Tahoma", 1, 11)));
        this.addressLabel.setText("Local Address:");
        this.allRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.allRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.listenerButtonGroup.add(this.allRadio);
        this.allRadio.setText("All interfaces");
        this.allRadio.setToolTipText("<html>If checked, the connector will listen on all interfaces, using address 0.0.0.0.</html>");
        this.allRadio.setMargin(new Insets(0, 0, 0, 0));
        this.allRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListenerSettingsPanel.this.allRadioActionPerformed(evt);
            }
        });
        this.specificRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.specificRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.listenerButtonGroup.add(this.specificRadio);
        this.specificRadio.setText("Specific interface:");
        this.specificRadio.setToolTipText("<html>If checked, the connector will listen on the specific interface address defined.</html>");
        this.specificRadio.setMargin(new Insets(0, 0, 0, 0));
        this.specificRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListenerSettingsPanel.this.specificRadioActionPerformed(evt);
            }
        });
        this.addressField.setToolTipText("The DNS domain name or IP address on which the web service should listen for connections.");
        this.portLabel.setText("Local Port:");
        this.portField.setToolTipText("The port on which the web service should listen for connections.");
        this.portField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ListenerSettingsPanel.this.portFieldKeyReleased(evt);
            }
        });
        this.portsInUse.setText("Ports in Use");
        this.portsInUse.setToolTipText("<html>View all listener ports currently used by BridgeLink.<br>Any port number can be entered even if it's already in use;<br>however, only one channel can be deployed per port.</html>");
        this.portsInUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListenerSettingsPanel.this.portsInUseActionPerformed(evt);
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 8 0 8, novisualpadding", "[right]12[fill]12[left, fill]"));
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.add(this.addressLabel);
        this.add(this.allRadio);
        this.add(this.specificRadio);
        this.add((Component)this.addressField, "width 150");
        this.add((Component)this.portLabel, "newline");
        this.add((Component)this.portField, "grow");
        this.add(this.portsInUse);
    }

    private void allRadioActionPerformed(ActionEvent evt) {
        this.addressField.setText(new ListenerConnectorProperties(null).getHost());
        this.addressField.setEnabled(false);
    }

    private void specificRadioActionPerformed(ActionEvent evt) {
        this.addressField.setEnabled(true);
    }

    private void portFieldKeyReleased(KeyEvent evt) {
        ((ConnectorPanel)this.getParent()).updatedField(FIELD_PORT);
    }

    private void portsInUseActionPerformed(ActionEvent evt) {
        PortUsageDialog dialog = new PortUsageDialog((Window)((Object)this.parent));
    }
}

