/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.connectors;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthTimePicker;
import com.mirth.connect.client.ui.panels.connectors.AdvancedPollingSettingsDialog;
import com.mirth.connect.donkey.model.channel.CronProperty;
import com.mirth.connect.donkey.model.channel.PollConnectorProperties;
import com.mirth.connect.donkey.model.channel.PollConnectorPropertiesAdvanced;
import com.mirth.connect.donkey.model.channel.PollConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.PollingType;
import com.mirth.connect.donkey.util.PollConnectorJobHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DateFormatter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class PollingSettingsPanel
extends JPanel {
    private static String POLLING_FREQUENCY_MILLISECONDS = "milliseconds";
    private static String POLLING_FREQUENCY_SECONDS = "seconds";
    private static String POLLING_FREQUENCY_MINUTES = "minutes";
    private static String POLLING_FREQUENCY_HOURS = "hours";
    private static String defaultCronJob = "*/5 * * * * ?";
    private String lastSelectedPollingType;
    private PollConnectorProperties nextFireTimeProperties;
    private PollConnectorPropertiesAdvanced cachedAdvancedConnectorProperties;
    private boolean channelContext;
    private Set<String> invalidExpressions;
    private JLabel scheduleTypeLabel;
    private MirthComboBox scheduleTypeComboBox;
    private ActionListener scheduleTypeActionListener;
    private JLabel nextPollLabel;
    private MirthRadioButton yesStartPollRadioButton;
    private MirthRadioButton noStartPollRadioButton;
    private ButtonGroup pollOnStartButtonGroup;
    private MirthTimePicker pollingTimePicker;
    private JPanel pollingFrequencySettingsPanel;
    private MirthTextField pollingFrequencyField;
    private MirthComboBox pollingFrequencyTypeComboBox;
    private JPanel pollingCronSettingsPanel;
    private MirthTable cronJobsTable;
    private ColorHighlighter errorHighlighter;
    private JScrollPane cronScrollPane;
    private JButton addJobButton;
    private JButton deleteJobButton;
    private JLabel timeSettingsLabel;
    private JButton advancedSettingsButton;
    private JPanel scheduleSettingsPanel;

    public PollingSettingsPanel(boolean channelContext) {
        this.channelContext = channelContext;
        this.initComponents();
        this.initLayout();
        this.cachedAdvancedConnectorProperties = new PollConnectorPropertiesAdvanced();
    }

    public void setProperties(PollConnectorPropertiesInterface propertiesInterface) {
        this.setProperties(propertiesInterface.getPollConnectorProperties());
    }

    public void fillProperties(PollConnectorPropertiesInterface propertiesInterface) {
        PollConnectorProperties properties = null;
        properties = propertiesInterface != null ? propertiesInterface.getPollConnectorProperties() : new PollConnectorProperties();
        String selectedPollingType = (String)this.scheduleTypeComboBox.getSelectedItem();
        properties.setPollOnStart(this.yesStartPollRadioButton.isSelected());
        if (selectedPollingType.equals(PollingType.INTERVAL.getDisplayName())) {
            properties.setPollingType(PollingType.INTERVAL);
            String type = (String)this.pollingFrequencyTypeComboBox.getSelectedItem();
            int frequency = NumberUtils.toInt((String)this.pollingFrequencyField.getText(), (int)0);
            if (type.equals(POLLING_FREQUENCY_HOURS)) {
                frequency *= 3600000;
            } else if (type.equals(POLLING_FREQUENCY_MINUTES)) {
                frequency *= 60000;
            } else if (type.equals(POLLING_FREQUENCY_SECONDS)) {
                frequency *= 1000;
            }
            properties.setPollingFrequency(frequency);
        } else if (selectedPollingType.equals(PollingType.TIME.getDisplayName())) {
            properties.setPollingType(PollingType.TIME);
            try {
                SimpleDateFormat timeDateFormat = new SimpleDateFormat("hh:mm aa");
                DateFormatter timeFormatter = new DateFormatter(timeDateFormat);
                Date timeDate = (Date)timeFormatter.stringToValue(this.pollingTimePicker.getDate());
                Calendar timeCalendar = Calendar.getInstance();
                timeCalendar.setTime(timeDate);
                properties.setPollingHour(timeCalendar.get(11));
                properties.setPollingMinute(timeCalendar.get(12));
            }
            catch (ParseException timeDateFormat) {}
        } else if (selectedPollingType.equals(PollingType.CRON.getDisplayName())) {
            properties.setPollingType(PollingType.CRON);
            ArrayList<CronProperty> cronJobs = new ArrayList<CronProperty>();
            for (int rowCount = 0; rowCount < this.cronJobsTable.getRowCount(); ++rowCount) {
                String description = (String)this.cronJobsTable.getValueAt(rowCount, 1);
                String expression = (String)this.cronJobsTable.getValueAt(rowCount, 0);
                if (!StringUtils.isNotBlank((CharSequence)expression)) continue;
                cronJobs.add(new CronProperty(description, expression));
            }
            properties.setCronJobs(cronJobs);
        }
        properties.setPollConnectorPropertiesAdvanced(this.cachedAdvancedConnectorProperties);
        selectedPollingType = null;
        if (properties != null) {
            this.nextFireTimeProperties = properties.clone();
        }
    }

    public boolean checkProperties(PollConnectorPropertiesInterface propertiesInterface, boolean highlight) {
        PollConnectorProperties properties = null;
        if (propertiesInterface != null) {
            properties = propertiesInterface.getPollConnectorProperties();
        } else {
            this.fillProperties(null);
            properties = this.nextFireTimeProperties.clone();
        }
        boolean valid = true;
        this.pollingFrequencyField.setBackground(null);
        if (properties.getPollingType().equals((Object)PollingType.INTERVAL)) {
            int frequency = properties.getPollingFrequency();
            if (frequency <= 0 || frequency >= 86400000) {
                valid = false;
            }
            if (highlight && !valid) {
                this.pollingFrequencyField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (properties.getPollingType().equals((Object)PollingType.CRON)) {
            if (this.cronJobsTable.getRowCount() == 0) {
                valid = false;
            } else {
                this.invalidExpressions = new HashSet<String>();
                this.cronJobsTable.removeHighlighter((Highlighter)this.errorHighlighter);
                for (int index = 0; index < this.cronJobsTable.getRowCount(); ++index) {
                    String cronExpression = (String)this.cronJobsTable.getValueAt(index, 0);
                    if (!StringUtils.isBlank((CharSequence)cronExpression) && PollConnectorJobHandler.validateExpression((String)cronExpression)) continue;
                    this.invalidExpressions.add(cronExpression);
                    valid = false;
                }
                if (!valid) {
                    this.cronJobsTable.addHighlighter((Highlighter)this.errorHighlighter);
                }
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.setInvalidProperties(false, false);
    }

    public void setInvalidProperties(boolean invalidFrequency, boolean invalidJobs) {
        this.pollingFrequencyField.setBackground(invalidFrequency ? UIConstants.INVALID_COLOR : null);
        this.cronJobsTable.removeHighlighter((Highlighter)this.errorHighlighter);
        if (invalidJobs) {
            this.cronJobsTable.addHighlighter((Highlighter)this.errorHighlighter);
        }
    }

    public void updateInvalidExpressions(Set<String> invalidExpressions) {
        this.invalidExpressions = invalidExpressions;
    }

    private void initComponents() {
        this.scheduleTypeLabel = new JLabel("Schedule Type:");
        this.scheduleTypeComboBox = new MirthComboBox();
        this.scheduleTypeComboBox.setToolTipText("<html>This connector polls to determine when new messages have arrived.<br>Select \"Interval\" to poll each n units of time.<br>Select \"Time\" to poll once a day at the specified time.<br>Select \"Cron\" to poll at the specified cron expression(s).</html>");
        this.scheduleTypeComboBox.addItem(PollingType.INTERVAL.getDisplayName());
        this.scheduleTypeComboBox.addItem(PollingType.TIME.getDisplayName());
        this.scheduleTypeComboBox.addItem(PollingType.CRON.getDisplayName());
        this.scheduleTypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PollingSettingsPanel.this.scheduleTypeActionPerformed();
                PollingSettingsPanel.this.updateNextFireTime();
            }
        };
        this.nextPollLabel = new JLabel("Next poll at: ");
        this.yesStartPollRadioButton = new MirthRadioButton("Yes");
        this.yesStartPollRadioButton.setToolTipText("<html>Select Yes to immediately poll once on start.<br/>All subsequent polling will follow the specified schedule.</html>");
        this.yesStartPollRadioButton.setBackground(UIConstants.BACKGROUND_COLOR);
        this.yesStartPollRadioButton.setFocusable(false);
        this.noStartPollRadioButton = new MirthRadioButton("No");
        this.noStartPollRadioButton.setToolTipText("<html>Select Yes to immediately poll once on start.<br/>All subsequent polling will follow the specified schedule.</html>");
        this.noStartPollRadioButton.setBackground(UIConstants.BACKGROUND_COLOR);
        this.noStartPollRadioButton.setSelected(true);
        this.noStartPollRadioButton.setFocusable(false);
        this.pollOnStartButtonGroup = new ButtonGroup();
        this.pollOnStartButtonGroup.add(this.yesStartPollRadioButton);
        this.pollOnStartButtonGroup.add(this.noStartPollRadioButton);
        this.pollingTimePicker = new MirthTimePicker();
        this.pollingTimePicker.setToolTipText("The time of day to poll.");
        this.pollingTimePicker.setVisible(false);
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.pollingTimePicker.getEditor();
        JFormattedTextField textField = editor.getTextField();
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                PollingSettingsPanel.this.updateNextFireTime();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.pollingFrequencySettingsPanel = new JPanel();
        this.pollingFrequencySettingsPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.pollingFrequencySettingsPanel.setVisible(true);
        this.pollingFrequencyField = new MirthTextField();
        this.pollingFrequencyField.setToolTipText("<html>The specified repeating time interval.<br/>Units must be less than 24 hours of time<br/>when converted to milliseconds.</html>");
        this.pollingFrequencyField.setSize(new Dimension(200, 20));
        this.pollingFrequencyField.setDocument(new MirthFieldConstraints(0, false, false, true));
        this.pollingFrequencyField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PollingSettingsPanel.this.updateNextFireTime();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PollingSettingsPanel.this.updateNextFireTime();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.pollingFrequencyTypeComboBox = new MirthComboBox();
        this.pollingFrequencyTypeComboBox.setToolTipText("The interval's unit of time.");
        this.pollingFrequencyTypeComboBox.addItem(POLLING_FREQUENCY_MILLISECONDS);
        this.pollingFrequencyTypeComboBox.addItem(POLLING_FREQUENCY_SECONDS);
        this.pollingFrequencyTypeComboBox.addItem(POLLING_FREQUENCY_MINUTES);
        this.pollingFrequencyTypeComboBox.addItem(POLLING_FREQUENCY_HOURS);
        this.pollingFrequencyTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PollingSettingsPanel.this.updateNextFireTime();
            }
        });
        this.pollingCronSettingsPanel = new JPanel();
        this.pollingCronSettingsPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.pollingCronSettingsPanel.setVisible(false);
        this.cronJobsTable = new MirthTable();
        Object[][] tableData = new Object[0][1];
        this.cronJobsTable.setModel(new RefreshTableModel(tableData, new String[]{"Expression", "Description"}));
        this.cronJobsTable.setOpaque(true);
        this.cronJobsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.cronJobsTable.getTableHeader().setReorderingAllowed(false);
        this.cronJobsTable.setSortable(false);
        this.cronJobsTable.setSelectionMode(0);
        this.cronJobsTable.getColumnModel().getColumn(0).setResizable(false);
        this.cronJobsTable.getColumnModel().getColumn(0).setCellEditor(new CronTableCellEditor(true));
        this.cronJobsTable.getColumnModel().getColumn(1).setResizable(false);
        this.cronJobsTable.getColumnModel().getColumn(1).setCellEditor(new CronTableCellEditor(true));
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.cronJobsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        HighlightPredicate errorHighlighterPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String cronExpression;
                return adapter.column == PollingSettingsPanel.this.cronJobsTable.getColumnViewIndex("Expression") && PollingSettingsPanel.this.invalidExpressions.contains(cronExpression = (String)PollingSettingsPanel.this.cronJobsTable.getValueAt(adapter.row, adapter.column));
            }
        };
        this.errorHighlighter = new ColorHighlighter(errorHighlighterPredicate, Color.PINK, Color.BLACK, Color.PINK, Color.BLACK);
        String tooltip = "<html><head><style>td {text-align:center;}</style></head>Cron expressions must be in Quartz format with at least 6 fields.<br/><br/>Format:<table><tr><td>Field</td><td>Required</td><td>Values</td><td>Special Characters</td></tr><tr><td>Seconds</td><td>YES</td><td>0-59</td><td>, - * /</td></tr><tr><td>Minutes</td><td>YES</td><td>0-59</td><td>, - * /</td></tr><tr><td>Hours</td><td>YES</td><td>0-23</td><td>, - * /</td></tr><tr><td>Day of Month</td><td>YES</td><td>1-31</td><td>, - * ? / L W</td></tr><tr><td>Month</td><td>YES</td><td>1-12 or JAN-DEC</td><td>, - * /</td></tr><tr><td>Day of Week</td><td>YES</td><td>1-7 or SUN-SAT</td><td>, - * ? / L #</td></tr><tr><td>Year</td><td>NO</td><td>empty, 1970-2099</td><td>, - * /</td></tr></table><br/>Special Characters:<br/> &nbsp <b>*</b> : all values<br/> &nbsp <b>?</b> : no specific value<br/> &nbsp <b>-</b> : used to specify ranges<br/> &nbsp <b>,</b> : used to specify list of values<br/> &nbsp <b>/</b> : used to specify increments<br/> &nbsp <b>L</b> : used to specify the last of<br/> &nbsp <b>W</b> : used to specify the nearest weekday<br/> &nbsp <b>#</b> : used to specify the nth day of the month<br/><br/>Example: 0 */5 8-17 * * ? means to fire every 5 minutes starting at 8am<br/>and ending at 5pm everyday<br/><br/><b>Note:</b> Support for specifying both a day-of-week and day-of-month<br/>is not yet supported. A ? must be used in one of these fields.</html>";
        this.cronJobsTable.setToolTipText(tooltip);
        this.cronJobsTable.getTableHeader().setToolTipText(tooltip);
        this.cronScrollPane = new JScrollPane();
        this.cronScrollPane.getViewport().add((Component)((Object)this.cronJobsTable));
        this.addJobButton = new JButton("Add");
        this.addJobButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ((DefaultTableModel)PollingSettingsPanel.this.cronJobsTable.getModel()).addRow(new Vector());
                int rowSelectionNumber = PollingSettingsPanel.this.cronJobsTable.getRowCount() - 1;
                PollingSettingsPanel.this.cronJobsTable.setRowSelectionInterval(rowSelectionNumber, rowSelectionNumber);
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                Boolean enabled = PollingSettingsPanel.this.deleteJobButton.isEnabled();
                if (!enabled.booleanValue()) {
                    PollingSettingsPanel.this.deleteJobButton.setEnabled(true);
                }
                PollingSettingsPanel.this.updateNextFireTime();
            }
        });
        this.deleteJobButton = new JButton("Delete");
        this.deleteJobButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int rowSelectionNumber = PollingSettingsPanel.this.cronJobsTable.getSelectedRow();
                if (rowSelectionNumber > -1) {
                    DefaultTableModel model = (DefaultTableModel)PollingSettingsPanel.this.cronJobsTable.getModel();
                    model.removeRow(rowSelectionNumber);
                    if (--rowSelectionNumber > -1) {
                        PollingSettingsPanel.this.cronJobsTable.setRowSelectionInterval(rowSelectionNumber, rowSelectionNumber);
                    } else if (PollingSettingsPanel.this.cronJobsTable.getRowCount() > 0) {
                        PollingSettingsPanel.this.cronJobsTable.setRowSelectionInterval(0, 0);
                    }
                    if (PollingSettingsPanel.this.cronJobsTable.getRowCount() == 0) {
                        PollingSettingsPanel.this.deleteJobButton.setEnabled(false);
                    }
                }
                PollingSettingsPanel.this.updateNextFireTime();
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            }
        });
        this.deleteJobButton.setEnabled(false);
        this.advancedSettingsButton = new JButton(new ImageIcon(Frame.class.getResource("images/wrench.png")));
        this.advancedSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PollingSettingsPanel.this.lastSelectedPollingType = StringUtils.isBlank((CharSequence)PollingSettingsPanel.this.lastSelectedPollingType) ? "Interval" : PollingSettingsPanel.this.lastSelectedPollingType;
                new AdvancedPollingSettingsDialog(PollingSettingsPanel.this.lastSelectedPollingType, PollingSettingsPanel.this.cachedAdvancedConnectorProperties, PollingSettingsPanel.this.channelContext);
                PollingSettingsPanel.this.updateNextFireTime();
            }
        });
        this.timeSettingsLabel = new JLabel("Interval:");
        this.timeSettingsLabel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.scheduleSettingsPanel = new JPanel();
        this.scheduleSettingsPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        if (!this.channelContext) {
            this.scheduleTypeComboBox.setToolTipText("<html>Select the pruning schedule type.<br>Select \"Interval\" to prune each n units of time.<br>Select \"Time\" to prune once a day at the specified time.<br>Select \"Cron\" to prune at the specified cron expression(s).</html>");
            this.pollingFrequencyField.setToolTipText("<html>The specified repeating time interval.<br/>Units must be between 1 and 24 hours of time<br/>when converted to milliseconds.</html>");
        }
    }

    public void enableComponents(boolean enable) {
        this.scheduleTypeLabel.setEnabled(enable);
        this.scheduleTypeComboBox.setEnabled(enable);
        this.pollingTimePicker.setEnabled(enable);
        this.pollingFrequencySettingsPanel.setEnabled(enable);
        this.pollingFrequencyField.setEnabled(enable);
        this.pollingFrequencyTypeComboBox.setEnabled(enable);
        this.cronJobsTable.setEnabled(enable);
        this.cronScrollPane.setEnabled(enable);
        this.addJobButton.setEnabled(enable);
        this.deleteJobButton.setEnabled(enable);
        this.timeSettingsLabel.setEnabled(enable);
        this.advancedSettingsButton.setEnabled(enable);
        this.scheduleSettingsPanel.setEnabled(enable);
    }

    public PollConnectorProperties getProperties() {
        this.fillProperties(null);
        return this.nextFireTimeProperties;
    }

    public void setProperties(PollConnectorProperties properties) {
        List cronJobs;
        this.scheduleTypeComboBox.removeActionListener(this.scheduleTypeActionListener);
        this.clearProperties();
        if (properties.getPollingType().equals((Object)PollingType.INTERVAL)) {
            String frequencyType = POLLING_FREQUENCY_MILLISECONDS;
            int frequency = properties.getPollingFrequency();
            if (frequency % 3600000 == 0) {
                frequency /= 3600000;
                frequencyType = POLLING_FREQUENCY_HOURS;
            } else if (frequency % 60000 == 0) {
                frequency /= 60000;
                frequencyType = POLLING_FREQUENCY_MINUTES;
            } else if (frequency % 1000 == 0) {
                frequency /= 1000;
                frequencyType = POLLING_FREQUENCY_SECONDS;
            }
            this.pollingFrequencyField.setText(String.valueOf(frequency));
            this.pollingFrequencyTypeComboBox.setSelectedItem(frequencyType);
        } else if (properties.getPollingType().equals((Object)PollingType.TIME)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm aa");
            Calendar timeCalendar = Calendar.getInstance();
            timeCalendar.set(11, properties.getPollingHour());
            timeCalendar.set(12, properties.getPollingMinute());
            this.pollingTimePicker.setDate(dateFormat.format(timeCalendar.getTime()));
        } else if (properties.getPollingType().equals((Object)PollingType.CRON) && (cronJobs = properties.getCronJobs()) != null && cronJobs.size() > 0) {
            DefaultTableModel model = (DefaultTableModel)this.cronJobsTable.getModel();
            model.setNumRows(0);
            for (CronProperty property : cronJobs) {
                model.addRow(new Object[]{property.getExpression(), property.getDescription()});
            }
            this.deleteJobButton.setEnabled(true);
        }
        this.nextFireTimeProperties = properties.clone();
        String pollingType = properties.getPollingType().getDisplayName();
        this.yesStartPollRadioButton.setSelected(properties.isPollOnStart());
        this.scheduleTypeComboBox.setSelectedItem(pollingType);
        this.enableComponents(pollingType);
        this.cachedAdvancedConnectorProperties = properties.getPollConnectorPropertiesAdvanced();
        this.scheduleTypeComboBox.addActionListener(this.scheduleTypeActionListener);
    }

    private void scheduleTypeActionPerformed() {
        String selectedType = (String)this.scheduleTypeComboBox.getSelectedItem();
        if (!(this.lastSelectedPollingType == null || !this.channelContext || this.isDefaultProperties() && this.cachedAdvancedConnectorProperties.equals((Object)new PollConnectorPropertiesAdvanced()))) {
            if (!selectedType.equals(this.lastSelectedPollingType) && JOptionPane.showConfirmDialog((Component)((Object)PlatformUI.MIRTH_FRAME), "Are you sure you would like to change the polling type and lose all of the current properties?", "Select an Option", 0) == 0) {
                this.clearProperties();
                this.enableComponents(selectedType);
            } else {
                this.scheduleTypeComboBox.setSelectedItem(this.lastSelectedPollingType);
            }
        } else {
            this.scheduleTypeComboBox.setSelectedItem(selectedType);
            this.enableComponents(selectedType);
        }
        this.updateNextFireTime();
    }

    private void enableComponents(String selectedType) {
        if (selectedType.equals(PollingType.INTERVAL.getDisplayName())) {
            this.timeSettingsLabel.setText("Interval:");
            ((MigLayout)this.getLayout()).setComponentConstraints((Component)this.timeSettingsLabel, (Object)"newline, right");
        } else if (selectedType.equals(PollingType.TIME.getDisplayName())) {
            this.timeSettingsLabel.setText("Time:");
            ((MigLayout)this.getLayout()).setComponentConstraints((Component)this.timeSettingsLabel, (Object)"newline, right");
        } else if (selectedType.equals(PollingType.CRON.getDisplayName())) {
            this.timeSettingsLabel.setText("Cron Jobs:");
            ((MigLayout)this.getLayout()).setComponentConstraints((Component)this.timeSettingsLabel, (Object)"newline, right, top");
        }
        this.pollingFrequencySettingsPanel.setVisible(selectedType.equals(PollingType.INTERVAL.getDisplayName()));
        this.pollingTimePicker.setVisible(selectedType.equals(PollingType.TIME.getDisplayName()));
        this.pollingCronSettingsPanel.setVisible(selectedType.equals(PollingType.CRON.getDisplayName()));
        this.advancedSettingsButton.setVisible(!selectedType.equals(PollingType.CRON.getDisplayName()));
        this.scheduleTypeComboBox.setSelectedItem(selectedType);
        this.lastSelectedPollingType = selectedType;
    }

    private boolean isDefaultProperties() {
        boolean isDefault = true;
        if (this.channelContext) {
            if (this.lastSelectedPollingType.equals(PollingType.INTERVAL.getDisplayName())) {
                if (!this.pollingFrequencyField.getText().equalsIgnoreCase("5")) {
                    isDefault = false;
                }
                if (this.pollingFrequencyTypeComboBox.getSelectedIndex() != 1) {
                    isDefault = false;
                }
            }
            if (this.lastSelectedPollingType.equals(PollingType.CRON.getDisplayName())) {
                isDefault = this.cronJobsTable.getRowCount() == 1 ? this.cronJobsTable.getValueAt(0, 0).equals(defaultCronJob) : false;
            }
        }
        return isDefault;
    }

    private void clearProperties() {
        this.scheduleTypeComboBox.setSelectedItem(PollingType.INTERVAL.getDisplayName());
        this.noStartPollRadioButton.setSelected(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm aa");
        this.pollingTimePicker.setDate(dateFormat.format(Calendar.getInstance().getTime()));
        DefaultTableModel model = (DefaultTableModel)this.cronJobsTable.getModel();
        for (int index = model.getRowCount() - 1; index >= 0; --index) {
            model.removeRow(index);
        }
        Vector<String> row = new Vector<String>();
        if (this.channelContext) {
            this.pollingFrequencyTypeComboBox.setSelectedItem(POLLING_FREQUENCY_SECONDS);
            this.pollingFrequencyField.setText("5");
            row.add(defaultCronJob);
            row.add("Run every 5 seconds.");
        } else {
            this.pollingFrequencyTypeComboBox.setSelectedItem(POLLING_FREQUENCY_HOURS);
            this.pollingFrequencyField.setText("1");
            row.add("0 0 */1 * * ?");
            row.add("Run hourly.");
        }
        model.addRow(row);
        this.cachedAdvancedConnectorProperties = new PollConnectorPropertiesAdvanced();
    }

    public void updateNextFireTime() {
        if (this.channelContext && this.nextFireTimeProperties != null) {
            this.fillProperties(null);
            boolean isCron = this.nextFireTimeProperties.getPollingType().equals((Object)PollingType.CRON);
            if (isCron || this.checkProperties(null, false)) {
                try {
                    PollConnectorJobHandler handler = new PollConnectorJobHandler(this.nextFireTimeProperties, PlatformUI.MIRTH_FRAME.mirthClient.getGuid(), false);
                    handler.configureJob(null, null, "DummyJob");
                    this.nextPollLabel.setText("Next poll at: " + handler.getNextFireTime());
                }
                catch (Exception e) {
                    StringBuilder builder = new StringBuilder();
                    if (isCron) {
                        String error = e.getMessage();
                        if (e.getMessage().contains("is invalid,.")) {
                            builder.append(error.substring(0, error.length() - 2));
                            builder.append(". ");
                        }
                        builder.append(e.getCause().getMessage());
                    } else {
                        builder.append(e.getMessage());
                    }
                    this.nextPollLabel.setText(builder.toString());
                }
            }
        }
    }

    private void initLayout() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        if (this.channelContext) {
            this.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0, gap 6 4", "[]12[]"));
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Polling Settings", 0, 0, new Font("Tahoma", 1, 11)));
            this.add((Component)this.scheduleTypeLabel, "right");
            this.add((Component)this.scheduleTypeComboBox, "split");
            this.add((Component)this.nextPollLabel, "gapbefore 6");
            this.add((Component)new JLabel("Poll Once on Start:"), "newline, right");
            this.add((Component)this.yesStartPollRadioButton, "split");
            this.add((Component)this.noStartPollRadioButton, "gapbefore 5");
        } else {
            this.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0, gap 6 6", "[]12[]"));
            this.add((Component)this.scheduleTypeLabel, "right");
            this.add(this.scheduleTypeComboBox);
        }
        this.add((Component)this.timeSettingsLabel, "newline, right");
        this.scheduleSettingsPanel.setLayout((LayoutManager)new MigLayout("novisualpadding, hidemode 3, insets 0, gap 6 6"));
        this.scheduleSettingsPanel.add((Component)this.pollingTimePicker, "w 70!");
        this.pollingFrequencySettingsPanel.setLayout((LayoutManager)new MigLayout("novisualpadding, insets 0, gap 6 6"));
        this.pollingFrequencySettingsPanel.add((Component)this.pollingFrequencyField, "w 75!, left");
        this.pollingFrequencySettingsPanel.add((Component)this.pollingFrequencyTypeComboBox, "left");
        this.scheduleSettingsPanel.add(this.pollingFrequencySettingsPanel);
        this.pollingCronSettingsPanel.setLayout((LayoutManager)new MigLayout("novisualpadding, insets 0, gap 6 6"));
        this.pollingCronSettingsPanel.add((Component)this.cronScrollPane, "h 74!, w 400!");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, insets 0, gap 6 6"));
        buttonPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        buttonPanel.add((Component)this.addJobButton, "wrap, w 50!");
        buttonPanel.add((Component)this.deleteJobButton, "w 50!");
        this.pollingCronSettingsPanel.add((Component)buttonPanel, "top");
        this.scheduleSettingsPanel.add(this.pollingCronSettingsPanel);
        this.add((Component)this.scheduleSettingsPanel, "split");
        this.add((Component)this.advancedSettingsButton, "gapbefore 6, h 21!, w 22!");
    }

    private class CronTableCellEditor
    extends TextFieldCellEditor {
        boolean checkProperties;

        public CronTableCellEditor(boolean checkProperties) {
            this.checkProperties = checkProperties;
        }

        public boolean checkUniqueProperty(String property) {
            boolean exists = false;
            for (int i = 0; i < PollingSettingsPanel.this.cronJobsTable.getRowCount(); ++i) {
                boolean isDuplicateExpression;
                boolean bl = isDuplicateExpression = PollingSettingsPanel.this.cronJobsTable.getValueAt(i, 0) != null && ((String)PollingSettingsPanel.this.cronJobsTable.getValueAt(i, 0)).equals(property);
                if (!isDuplicateExpression) continue;
                exists = true;
            }
            return exists;
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            boolean editable = super.isCellEditable(evt);
            if (editable) {
                PollingSettingsPanel.this.deleteJobButton.setEnabled(false);
            }
            return editable;
        }

        @Override
        protected boolean valueChanged(String value) {
            PollingSettingsPanel.this.deleteJobButton.setEnabled(true);
            if (this.checkProperties && (value.length() == 0 || this.checkUniqueProperty(value))) {
                return false;
            }
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            boolean stopCellEditing = super.stopCellEditing();
            PollingSettingsPanel.this.updateNextFireTime();
            return stopCellEditing;
        }
    }
}

