/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.export;

public enum ArchiveFormat {
    ZIP("zip", null),
    TAR_GZ("tar", "gz"),
    TAR_BZ2("tar", "bzip2");

    private String archiver;
    private String compressor;
    private String label;

    private ArchiveFormat(String archiver, String compressor) {
        this.archiver = archiver;
        this.compressor = compressor;
        if (compressor == null) {
            this.label = archiver;
        } else {
            if (compressor.equals("bzip2")) {
                compressor = "bz2";
            }
            this.label = archiver + "." + compressor;
        }
    }

    public String getArchiver() {
        return this.archiver;
    }

    public String getCompressor() {
        return this.compressor;
    }

    public String toString() {
        return this.label;
    }

    public static ArchiveFormat lookup(String archiver, String compressor) {
        for (ArchiveFormat archiveFormat : ArchiveFormat.values()) {
            if (!archiveFormat.getArchiver().equals(archiver) || (compressor != null || archiveFormat.getCompressor() != null) && !archiveFormat.getCompressor().equals(compressor)) continue;
            return archiveFormat;
        }
        return null;
    }
}

