/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.export;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthTextPane;
import com.mirth.connect.client.ui.components.MirthVariableList;
import com.mirth.connect.client.ui.panels.export.ArchiveFormat;
import com.mirth.connect.client.ui.panels.export.ExportFormat;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.util.messagewriter.EncryptionType;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class MessageExportPanel
extends JPanel {
    private static final String ARCHIVER_MODE_PATTERN = "[timestamp]/[channel id]";
    private static final String EXPORT_MODE_PATTERN = "[timestamp]";
    private static final String XML_EXPORT_FORMAT = "XML serialized message";
    private static final String NO_COMPRESSION = "none";
    private Preferences userPreferences;
    private boolean archiverMode;
    private boolean initialized;
    private Component[] archiveComponents;
    private MirthVariableList varList = new MirthVariableList();
    private JScrollPane varListScrollPane = new JScrollPane();
    private JPanel varListPanel = new JPanel();
    private ButtonGroup archiveButtonGroup = new ButtonGroup();
    private JLabel archiveLabel = new JLabel("Enable Archiving:");
    private JRadioButton archiveYes = new MirthRadioButton("Yes");
    private JRadioButton archiveNo = new MirthRadioButton("No");
    private JLabel archiverBlockSizeLabel = new JLabel("Archiver Block Size:");
    private JTextField archiverBlockSizeField = new MirthTextField();
    private JLabel contentLabel = new JLabel("Content:");
    private JComboBox contentComboBox = new MirthComboBox();
    private JCheckBox encryptCheckBox = new MirthCheckBox("Encrypt");
    private JCheckBox attachmentsCheckBox = new MirthCheckBox("Include Attachments");
    private JLabel compressLabel = new JLabel("Compression:");
    private JComboBox compressComboBox = new MirthComboBox();
    private JLabel passwordProtectionLabel = new JLabel("Password Protect:");
    private JRadioButton passwordYesButton = new MirthRadioButton("Yes");
    private JRadioButton passwordNoButton = new MirthRadioButton("No");
    private ButtonGroup passwordButtonGroup = new ButtonGroup();
    private JLabel passwordLabel = new JLabel("Password:");
    private MirthPasswordField passwordField = new MirthPasswordField();
    private MirthComboBox encryptionComboBox = new MirthComboBox();
    private JLabel exportToLabel = new JLabel("Export To:");
    private ButtonGroup exportButtonGroup = new ButtonGroup();
    private JRadioButton exportServerRadio = new MirthRadioButton("Server");
    private JRadioButton exportLocalRadio = new MirthRadioButton("My Computer");
    private JButton browseButton = new MirthButton("Browse...");
    private JLabel rootPathLabel = new JLabel("Root Path:");
    private JTextField rootPathTextField = new MirthTextField();
    private JLabel filePatternLabel = new JLabel("File Pattern:");
    private JScrollPane filePatternScrollPane = new JScrollPane();
    private JTextPane filePatternTextPane = new MirthTextPane();
    private JLabel rootPathExtLabel = new JLabel();

    public MessageExportPanel(Preferences userPreferences, boolean archiverMode, boolean allowLocalExport) {
        this.userPreferences = userPreferences;
        this.archiverMode = archiverMode;
        this.initComponents();
        this.initLayout(allowLocalExport);
        this.initialized = true;
    }

    public boolean isArchiveEnabled() {
        return this.archiveYes.isSelected();
    }

    public void setArchiveEnabled(boolean archiveEnabled) {
        if (archiveEnabled) {
            this.archiveYes.setSelected(true);
            this.archiveNo.setSelected(false);
        } else {
            this.archiveYes.setSelected(false);
            this.archiveNo.setSelected(true);
        }
        this.archiveChanged();
    }

    public String getArchiverBlockSize() {
        return this.archiverBlockSizeField.getText();
    }

    public void setArchiverBlockSize(String size) {
        this.archiverBlockSizeField.setText(size);
    }

    public boolean isIncludeAttachments() {
        return this.attachmentsCheckBox.isSelected();
    }

    public void setIncludeAttachments(boolean includeAttachments) {
        this.attachmentsCheckBox.setSelected(includeAttachments);
    }

    public boolean isExportLocal() {
        return this.exportLocalRadio.isSelected();
    }

    public void setExportLocal(boolean exportLocal) {
        this.exportLocalRadio.setSelected(exportLocal);
        this.exportServerRadio.setSelected(!exportLocal);
        this.exportDestinationChanged();
    }

    public MessageWriterOptions getMessageWriterOptions() {
        MessageWriterOptions options = new MessageWriterOptions();
        if (this.contentComboBox.getSelectedItem() instanceof ExportFormat) {
            ExportFormat exportFormat = (ExportFormat)this.contentComboBox.getSelectedItem();
            options.setContentType(exportFormat.getContentType());
            options.setDestinationContent(exportFormat.isDestination());
        }
        options.setEncrypt(this.encryptCheckBox.isSelected());
        if (this.compressComboBox.getSelectedItem() instanceof ArchiveFormat) {
            ArchiveFormat archiveFormat = (ArchiveFormat)((Object)this.compressComboBox.getSelectedItem());
            options.setArchiveFormat(archiveFormat.getArchiver());
            options.setCompressFormat(archiveFormat.getCompressor());
        }
        options.setPasswordEnabled(this.passwordYesButton.isSelected());
        options.setPassword(new String(this.passwordField.getPassword()));
        options.setEncryptionType(EncryptionType.fromDisplayName((String)((String)this.encryptionComboBox.getSelectedItem())));
        options.setIncludeAttachments(this.attachmentsCheckBox.isSelected());
        options.setRootFolder(this.rootPathTextField.getText());
        options.setFilePattern(this.filePatternTextPane.getText());
        return options;
    }

    public void setMessageWriterOptions(MessageWriterOptions options) {
        if (options.getContentType() == null) {
            this.contentComboBox.setSelectedItem(XML_EXPORT_FORMAT);
        } else {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.contentComboBox.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ExportFormat exportFormat;
                Object element = model.getElementAt(i);
                if (!(element instanceof ExportFormat) || !(exportFormat = (ExportFormat)element).getContentType().equals((Object)options.getContentType()) || exportFormat.isDestination() != options.isDestinationContent()) continue;
                this.contentComboBox.setSelectedItem(exportFormat);
            }
        }
        this.encryptCheckBox.setSelected(options.isEncrypt());
        ArchiveFormat archiveFormat = ArchiveFormat.lookup(options.getArchiveFormat(), options.getCompressFormat());
        if (archiveFormat == null) {
            this.compressComboBox.setSelectedItem(NO_COMPRESSION);
        } else {
            this.compressComboBox.setSelectedItem((Object)archiveFormat);
        }
        this.passwordYesButton.setSelected(options.isPasswordEnabled());
        this.passwordNoButton.setSelected(!this.passwordYesButton.isSelected());
        this.passwordField.setText(options.getPassword());
        this.compressComboBoxChanged();
        this.updatePasswordFields(!this.passwordNoButton.isSelected());
        this.rootPathTextField.setText(options.getRootFolder());
        this.filePatternTextPane.setText(options.getFilePattern());
        this.repaint();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.initialized) {
            this.archiveYes.setBackground(color);
            this.archiveNo.setBackground(color);
            this.encryptCheckBox.setBackground(color);
            this.attachmentsCheckBox.setBackground(color);
            this.exportServerRadio.setBackground(color);
            this.exportLocalRadio.setBackground(color);
            this.passwordYesButton.setBackground(color);
            this.passwordNoButton.setBackground(color);
        }
    }

    public String validate(boolean highlight) {
        this.resetInvalidProperties();
        StringBuilder builder = new StringBuilder();
        if (!this.isEnabled() || this.archiveNo.isSelected()) {
            return null;
        }
        String archiverBlockSize = this.archiverBlockSizeField.getText();
        if (this.archiverMode && this.archiveYes.isSelected() && (StringUtils.isBlank((CharSequence)archiverBlockSize) || Integer.parseInt(archiverBlockSize) <= 0 || Integer.parseInt(archiverBlockSize) > 1000)) {
            builder.append("Archiver block size must be between 1 and 1000. The recommended value for most servers is 50.");
            builder.append("\n");
            if (highlight) {
                this.archiverBlockSizeField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (StringUtils.isBlank((CharSequence)this.rootPathTextField.getText())) {
            builder.append("Root path is required.");
            builder.append("\n");
            if (highlight) {
                this.rootPathTextField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (StringUtils.isBlank((CharSequence)this.filePatternTextPane.getText())) {
            builder.append("File pattern is required.");
            builder.append("\n");
            if (highlight) {
                this.filePatternTextPane.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (this.passwordYesButton.isSelected() && StringUtils.isBlank((CharSequence)new String(this.passwordField.getPassword()))) {
            builder.append("A password is required.");
            builder.append("\n");
            if (highlight) {
                this.passwordField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return builder.toString();
    }

    public void resetInvalidProperties() {
        this.rootPathTextField.setBackground(this.getBackground());
        this.filePatternTextPane.setBackground(this.getBackground());
        this.archiverBlockSizeField.setBackground(this.getBackground());
        this.passwordField.setBackground(this.getBackground());
    }

    private void initComponents() {
        this.contentComboBox.setToolTipText("<html>The content that will be exported: Either the entire message serialized into XML, or a specific content type<br />from either the source connector message or the destination connector messages.</html>");
        this.encryptCheckBox.setToolTipText("<html>If checked, the exported message content will be encrypted.</html>");
        this.attachmentsCheckBox.setToolTipText("<html>If checked and the content type is set to XML serialized message,<br/>the exported message will contain any attachments.</html>");
        this.compressComboBox.setToolTipText("<html>When compression is enabled, the files/folders created according to the<br />File Pattern will be put into a compressed file in the Root Path.</html>");
        this.passwordYesButton.setToolTipText("<html>Select Yes to allow password protected zip files.</html>");
        this.passwordNoButton.setToolTipText("<html>Select Yes to allow password protected zip files.</html>");
        this.passwordField.setToolTipText("<html>The password used to protect zip files.</html>");
        this.encryptionComboBox.setToolTipText("<html>The algorithm used to encrypt password-protected zip files.</html>");
        this.exportServerRadio.setToolTipText("<html>Store exported files on the BridgeLink Server, in the Root Path specified below.</html>");
        this.exportLocalRadio.setToolTipText("<html>Store exported files on this computer, in the Root Path specified below.</html>");
        this.rootPathTextField.setToolTipText("<html>The root path to store the exported files/folders or compressed file.<br/>Relative paths will be resolved against the BridgeLink Server home directory.</html>");
        this.filePatternTextPane.setToolTipText("<html>The file/folder pattern in which to write the exported message files.<br />Variables from the Variables list to the right may be used in the pattern.</html>");
        this.archiverBlockSizeField.setToolTipText("<html>The number of messages that will be cached by the archiver. Increase this value<br/>to improve performance. Decrease this value to reduce memory usage. This value<br/>must be between 1 and 1000. The recommended value for most servers is 50.</html>");
        this.archiveYes = new MirthRadioButton("Yes");
        this.archiveNo = new MirthRadioButton("No");
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        model.addElement(XML_EXPORT_FORMAT);
        model.addElement(new ExportFormat(false, "Source", ContentType.RAW));
        model.addElement(new ExportFormat(false, "Source", ContentType.PROCESSED_RAW));
        model.addElement(new ExportFormat(false, "Source", ContentType.TRANSFORMED));
        model.addElement(new ExportFormat(false, "Source", ContentType.ENCODED));
        model.addElement(new ExportFormat(false, "Source", ContentType.RESPONSE));
        model.addElement(new ExportFormat(true, "Destination", ContentType.RAW));
        model.addElement(new ExportFormat(true, "Destination", ContentType.TRANSFORMED));
        model.addElement(new ExportFormat(true, "Destination", ContentType.ENCODED));
        model.addElement(new ExportFormat(true, "Destination", ContentType.SENT));
        model.addElement(new ExportFormat(true, "Destination", ContentType.RESPONSE));
        model.addElement(new ExportFormat(true, "Destination", ContentType.PROCESSED_RESPONSE));
        model.addElement(new ExportFormat(false, "", ContentType.SOURCE_MAP));
        model.addElement(new ExportFormat(false, "", ContentType.CHANNEL_MAP));
        model.addElement(new ExportFormat(false, "", ContentType.RESPONSE_MAP));
        this.contentComboBox.setModel(model);
        this.contentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MessageExportPanel.this.contentComboBox.getSelectedItem().toString().equalsIgnoreCase(MessageExportPanel.XML_EXPORT_FORMAT)) {
                    MessageExportPanel.this.attachmentsCheckBox.setEnabled(false);
                    MessageExportPanel.this.attachmentsCheckBox.setSelected(false);
                } else {
                    MessageExportPanel.this.attachmentsCheckBox.setEnabled(true);
                }
            }
        });
        model = new DefaultComboBoxModel();
        model.addElement(NO_COMPRESSION);
        for (ArchiveFormat archiveFormat : ArchiveFormat.values()) {
            model.addElement((Object)archiveFormat);
        }
        this.compressComboBox.setModel(model);
        this.passwordProtectionLabel.setEnabled(false);
        this.passwordButtonGroup.add(this.passwordYesButton);
        this.passwordYesButton.setEnabled(false);
        this.passwordYesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageExportPanel.this.updatePasswordFields(true);
            }
        });
        this.passwordButtonGroup.add(this.passwordNoButton);
        this.passwordNoButton.setEnabled(false);
        this.passwordNoButton.setSelected(true);
        this.passwordNoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageExportPanel.this.updatePasswordFields(false);
            }
        });
        this.updatePasswordFields(false);
        DefaultComboBoxModel<String> encryptionModel = new DefaultComboBoxModel<String>();
        encryptionModel.addElement(EncryptionType.STANDARD.getDisplayName());
        encryptionModel.addElement(EncryptionType.AES128.getDisplayName());
        encryptionModel.addElement(EncryptionType.AES256.getDisplayName());
        this.encryptionComboBox.setModel(encryptionModel);
        this.encryptionComboBox.setSelectedItem(EncryptionType.AES128.getDisplayName());
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("Message ID");
        variables.add("Server ID");
        variables.add("Channel ID");
        variables.add("Original File Name");
        variables.add("Formatted Message Date");
        variables.add("Formatted Current Date");
        variables.add("Timestamp");
        variables.add("Unique ID");
        variables.add("Count");
        this.varListScrollPane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.varListPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.varListPanel.setBorder(BorderFactory.createEmptyBorder());
        this.varListPanel.setLayout(new BorderLayout());
        this.varListPanel.add(this.varListScrollPane);
        this.varListScrollPane.setViewportView((Component)((Object)this.varList));
        this.varList.setListData(variables.toArray());
        this.archiveButtonGroup.add(this.archiveYes);
        this.archiveButtonGroup.add(this.archiveNo);
        this.archiveYes.setSelected(true);
        this.archiverBlockSizeField.setDocument(new MirthFieldConstraints(4, false, false, true));
        if (this.archiverMode) {
            this.rootPathExtLabel.setText("/[timestamp]/[channel id]/");
        } else {
            this.rootPathExtLabel.setVisible(false);
        }
        this.exportButtonGroup.add(this.exportServerRadio);
        this.exportButtonGroup.add(this.exportLocalRadio);
        this.exportServerRadio.setSelected(true);
        this.browseButton.setEnabled(false);
        this.filePatternTextPane.setText("${message.channelId}_message_${message.messageId}.xml");
        this.filePatternScrollPane.setViewportView(this.filePatternTextPane);
        this.archiveComponents = new Component[]{this.archiverBlockSizeLabel, this.archiverBlockSizeField, this.contentLabel, this.contentComboBox, this.encryptCheckBox, this.attachmentsCheckBox, this.varList, this.varListScrollPane, this.varListPanel, this.compressLabel, this.compressComboBox, this.exportToLabel, this.exportServerRadio, this.exportLocalRadio, this.browseButton, this.rootPathLabel, this.rootPathTextField, this.rootPathExtLabel, this.filePatternLabel, this.filePatternScrollPane, this.filePatternTextPane};
        this.archiveYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageExportPanel.this.archiveChanged();
            }
        });
        this.archiveNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageExportPanel.this.archiveChanged();
            }
        });
        this.compressComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageExportPanel.this.compressComboBoxChanged();
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageExportPanel.this.browseSelected();
            }
        });
        this.exportServerRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageExportPanel.this.exportDestinationChanged();
            }
        });
        this.exportLocalRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageExportPanel.this.exportDestinationChanged();
            }
        });
    }

    private void updatePasswordFields(boolean enabled) {
        this.passwordLabel.setEnabled(enabled);
        this.passwordField.setEnabled(enabled);
        this.encryptionComboBox.setEnabled(enabled);
    }

    private void browseSelected() {
        File currentDir;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (this.userPreferences != null && (currentDir = new File(this.userPreferences.get("currentDirectory", ""))).exists()) {
            chooser.setCurrentDirectory(currentDir);
        }
        if (chooser.showOpenDialog(this.getParent()) == 0) {
            if (this.userPreferences != null) {
                this.userPreferences.put("currentDirectory", chooser.getCurrentDirectory().getPath());
            }
            this.rootPathTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void archiveChanged() {
        if (this.archiveYes.isSelected()) {
            for (Component component : this.archiveComponents) {
                component.setEnabled(true);
            }
        } else {
            this.resetInvalidProperties();
            for (Component component : this.archiveComponents) {
                component.setEnabled(false);
            }
        }
    }

    private void exportDestinationChanged() {
        if (this.exportServerRadio.isSelected()) {
            this.rootPathTextField.setText(null);
            this.browseButton.setEnabled(false);
        } else {
            this.rootPathTextField.setText(null);
            this.browseButton.setEnabled(true);
        }
    }

    private void compressComboBoxChanged() {
        Object archiveFormat = this.compressComboBox.getSelectedItem();
        boolean isArchiveableFormat = archiveFormat instanceof ArchiveFormat;
        if (isArchiveableFormat) {
            this.rootPathExtLabel.setText("/" + (this.archiverMode ? ARCHIVER_MODE_PATTERN : EXPORT_MODE_PATTERN) + "." + String.valueOf(archiveFormat));
            this.rootPathExtLabel.setVisible(true);
        } else if (this.archiverMode) {
            this.rootPathExtLabel.setText("/[timestamp]/[channel id]/");
        } else {
            this.rootPathExtLabel.setVisible(false);
        }
        boolean enabled = isArchiveableFormat && archiveFormat == ArchiveFormat.ZIP;
        this.passwordProtectionLabel.setEnabled(enabled);
        this.passwordYesButton.setEnabled(enabled);
        this.passwordNoButton.setEnabled(enabled);
        this.updatePasswordFields(enabled && this.passwordYesButton.isSelected());
        if (!enabled) {
            this.passwordNoButton.setSelected(true);
            this.passwordField.setText("");
            this.encryptionComboBox.setSelectedItem(EncryptionType.AES256.getDisplayName());
        }
    }

    private void initLayout(boolean allowLocalExport) {
        String rowGap = "2";
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0, wrap, fillx, hidemode 3", "[right]12[left, grow][170!]", ""));
        if (this.archiverMode) {
            this.add(this.archiveLabel);
            this.add((Component)this.archiveYes, "split 2");
            this.add((Component)this.archiveNo, "wrap");
            this.add(this.archiverBlockSizeLabel);
            this.add((Component)this.archiverBlockSizeField, "w 71!, h 22!, gapbottom " + rowGap);
            this.add((Component)this.varListPanel, "spany, growy, width 170!");
        }
        this.add(this.contentLabel);
        this.add((Component)this.contentComboBox, "split 3, gapbottom " + rowGap);
        this.add((Component)this.encryptCheckBox, "gapleft 8");
        this.add((Component)this.attachmentsCheckBox, "gapleft 8");
        if (!this.archiverMode) {
            this.add((Component)this.varListPanel, "spany, growy, width 170!");
        }
        this.add(this.compressLabel);
        this.add((Component)this.compressComboBox, "gapbottom " + rowGap);
        this.add(this.passwordProtectionLabel);
        this.add((Component)this.passwordYesButton, "split 3");
        this.add(this.passwordNoButton);
        this.add((Component)this.encryptionComboBox, "h 22!, w 96!, gapbottom " + rowGap);
        this.add(this.passwordLabel);
        this.add((Component)this.passwordField, "h 22!, w 170!, gapbottom " + rowGap);
        if (allowLocalExport) {
            this.add(this.exportToLabel);
            this.add((Component)this.exportServerRadio, "split 3");
            this.add(this.exportLocalRadio);
            this.add((Component)this.browseButton, "gapbottom " + rowGap);
        }
        this.add(this.rootPathLabel);
        this.add((Component)this.rootPathTextField, "grow, split 2, height 22!, gapbottom " + rowGap);
        this.add((Component)this.rootPathExtLabel, "hidemode 2");
        this.add((Component)this.filePatternLabel, "newline, aligny top");
        this.add((Component)this.filePatternScrollPane, "grow, push, split 2");
        this.add((Component)new JLabel(), "gapbottom " + rowGap);
    }
}

