/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.panels.reference;

import com.mirth.connect.client.ui.VariableListHandler;
import com.mirth.connect.client.ui.VariableTransferable;
import com.mirth.connect.client.ui.panels.reference.ReferenceTable;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateProperties;
import com.mirth.connect.util.CodeTemplateUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class ReferenceListHandler
extends TransferHandler {
    private List<CodeTemplate> listItems;

    public ReferenceListHandler(List<CodeTemplate> listItems) {
        this.listItems = listItems;
    }

    public void setListItems(List<CodeTemplate> listItems) {
        this.listItems = listItems;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        try {
            if (this.listItems == null) {
                return null;
            }
            ReferenceTable reftable = (ReferenceTable)((Object)c);
            if (reftable == null) {
                return null;
            }
            int currRow = reftable.convertRowIndexToModel(reftable.getSelectedRow());
            String text = "";
            if (currRow >= 0 && currRow < reftable.getModel().getRowCount() && currRow < this.listItems.size()) {
                CodeTemplate template = this.listItems.get(currRow);
                if (template.getType() == CodeTemplateProperties.CodeTemplateType.FUNCTION) {
                    text = template.getFunctionDefinition().getTransferData();
                } else if (template.getType() == CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE) {
                    text = CodeTemplateUtil.stripDocumentation((String)template.getCode());
                }
            }
            return new VariableTransferable(text, VariableListHandler.TransferMode.RAW);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] df) {
        return false;
    }
}

