/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.reference;

import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.reference.ClassReference;
import com.mirth.connect.client.ui.reference.ConstructorReference;
import com.mirth.connect.client.ui.reference.FunctionReference;
import com.mirth.connect.client.ui.reference.Reference;
import com.mirth.connect.model.Parameters;
import com.mirth.connect.model.codetemplates.CodeTemplateContextSet;
import com.mirth.connect.model.codetemplates.CodeTemplateFunctionDefinition;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.ModifierSet;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.visitor.VoidVisitor;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;

public class ClassVisitor
extends VoidVisitorAdapter<Object> {
    private static final Pattern JAVADOC_ANNOTATION_PATTERN = Pattern.compile("(?<!\\{)@(?<key>\\w+)\\s+(?<value>([^@]|(?<=\\{)@)*)");
    private List<String> inputTextList;
    private List<Reference> references = new ArrayList<Reference>();

    public ClassVisitor(List<String> inputTextList) {
        this.inputTextList = inputTextList;
    }

    public static List<Reference> getReferencesByCompilationUnit(CompilationUnit compilationUnit, List<String> inputTextList) {
        ClassVisitor visitor = new ClassVisitor(inputTextList);
        visitor.visit(compilationUnit, null);
        return visitor.getReferences();
    }

    public void visit(PackageDeclaration n, Object arg) {
        n.getName().accept((VoidVisitor)this, arg);
    }

    public void visit(QualifiedNameExpr n, Object arg) {
        n.getQualifier().accept((VoidVisitor)this, arg);
        if (arg instanceof StringBuilder) {
            ((StringBuilder)arg).append('.');
        }
        this.visit((NameExpr)n, arg);
    }

    public void visit(NameExpr n, Object arg) {
        if (arg instanceof StringBuilder) {
            ((StringBuilder)arg).append(n.getName());
        }
    }

    public void visit(CompilationUnit n, Object arg) {
        String packageName = null;
        if (n.getPackage() != null) {
            StringBuilder builder = new StringBuilder();
            this.visit(n.getPackage(), (Object)builder);
            packageName = builder.toString();
        }
        super.visit(n, packageName);
    }

    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        String comment;
        List implementsList;
        String className = n.getName();
        String packageName = (String)arg;
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body><b>");
        if (StringUtils.isNotBlank((CharSequence)packageName)) {
            builder.append("package ");
            builder.append(packageName);
        }
        builder.append("<br/><h3><a href=\"");
        builder.append(PlatformUI.SERVER_URL);
        builder.append(UIConstants.USER_API_LOCATION);
        if (StringUtils.isNotBlank((CharSequence)packageName)) {
            builder.append(packageName.replace(".", "/"));
            builder.append('/');
            builder.append(className);
            builder.append(".html");
        }
        builder.append("\">");
        builder.append(n.isInterface() ? "Interface " : "Class ");
        builder.append(className);
        builder.append("</a></h3></b><hr/><code>");
        if (!ModifierSet.isPublic((int)n.getModifiers())) {
            return;
        }
        builder.append("public ");
        if (ModifierSet.isStatic((int)n.getModifiers())) {
            builder.append("static ");
        }
        if (ModifierSet.isAbstract((int)n.getModifiers())) {
            builder.append("abstract ");
        }
        if (ModifierSet.isFinal((int)n.getModifiers())) {
            builder.append("final ");
        }
        if (ModifierSet.isNative((int)n.getModifiers())) {
            builder.append("native ");
        }
        if (ModifierSet.isSynchronized((int)n.getModifiers())) {
            builder.append("synchronized ");
        }
        if (ModifierSet.isTransient((int)n.getModifiers())) {
            builder.append("transient ");
        }
        if (ModifierSet.isVolatile((int)n.getModifiers())) {
            builder.append("volatile ");
        }
        if (n.isInterface()) {
            builder.append("interface ");
        } else {
            builder.append("class ");
        }
        builder.append(className);
        List extendsList = n.getExtends();
        if (CollectionUtils.isNotEmpty((Collection)extendsList)) {
            ClassOrInterfaceType type = (ClassOrInterfaceType)extendsList.get(0);
            builder.append("<br/>extends ");
            builder.append(type.getName());
        }
        if (CollectionUtils.isNotEmpty((Collection)(implementsList = n.getImplements()))) {
            builder.append("<br/>implements ");
            Iterator it = implementsList.iterator();
            while (it.hasNext()) {
                ClassOrInterfaceType type = (ClassOrInterfaceType)it.next();
                builder.append(type.getName());
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
        }
        builder.append("</code><br/><br/>");
        if (n.getJavaDoc() != null && StringUtils.isNotBlank((CharSequence)(comment = StringUtils.trim((String)n.getJavaDoc().getContent())))) {
            builder.append(this.encode(this.convertComment(comment)));
        }
        String summary = builder.toString();
        this.references.add(new ClassReference(CodeTemplateContextSet.getGlobalContextSet(), null, className, this.inputTextList, summary));
        if (n.getMembers() != null) {
            for (BodyDeclaration member : n.getMembers()) {
                member.accept((VoidVisitor)this, (Object)className);
            }
        }
    }

    public void visit(ConstructorDeclaration n, Object arg) {
        this.addMethod(true, (String)arg, n.getName(), n.getName(), n.getModifiers(), n.getJavaDoc(), n.getParameters());
    }

    public void visit(MethodDeclaration n, Object arg) {
        this.addMethod(false, (String)arg, n.getName(), n.getType().toString(), n.getModifiers(), n.getJavaDoc(), n.getParameters());
    }

    private void addMethod(boolean constructor, String className, String name, String type, int modifiers, JavadocComment javadoc, List<Parameter> parameters) {
        String iconName = null;
        if (ModifierSet.isPublic((int)modifiers)) {
            iconName = ModifierSet.isStatic((int)modifiers) ? "public_static_function" : "methpub_obj";
        } else {
            return;
        }
        Object comment = null;
        CaseInsensitiveMap parameterComments = new CaseInsensitiveMap();
        Object returnComment = constructor ? "A new " + name + " object." : null;
        String deprecatedComment = null;
        if (javadoc != null && StringUtils.isNotBlank((CharSequence)(comment = StringUtils.trim((String)javadoc.getContent())))) {
            Matcher matcher = JAVADOC_ANNOTATION_PATTERN.matcher((CharSequence)comment);
            while (matcher.find() && matcher.groupCount() >= 2) {
                Object key = matcher.group("key");
                String value = this.convertComment(matcher.group("value"));
                if (((String)key).equalsIgnoreCase("param")) {
                    int index = value.indexOf(32);
                    if (index >= 0) {
                        key = value.substring(0, index).trim();
                        value = value.substring(index).trim();
                    } else {
                        key = value;
                        value = "";
                    }
                    parameterComments.put(key, value);
                    continue;
                }
                if (((String)key).equalsIgnoreCase("return")) {
                    returnComment = value;
                    continue;
                }
                if (!((String)key).equalsIgnoreCase("deprecated")) continue;
                deprecatedComment = value;
            }
            comment = this.convertComment((String)comment);
            if (StringUtils.isNotBlank(deprecatedComment)) {
                comment = "<b>Deprecated.</b> <em>" + deprecatedComment + "</em><br/><br/>" + (String)comment;
            }
        }
        Parameters params = new Parameters();
        if (CollectionUtils.isNotEmpty(parameters)) {
            for (Parameter parameter : parameters) {
                String parameterName = parameter.getId().getName();
                params.add(parameterName, parameter.getType().toString(), (String)parameterComments.get(parameterName));
            }
        }
        FunctionReference reference = constructor ? new ConstructorReference(CodeTemplateContextSet.getGlobalContextSet(), null, name, name, (String)comment, null, new CodeTemplateFunctionDefinition(name, (List)params, type, (String)returnComment)) : new FunctionReference(CodeTemplateContextSet.getGlobalContextSet(), null, className, name, (String)comment, null, new CodeTemplateFunctionDefinition(name, (List)params, type, (String)returnComment), this.inputTextList);
        if (StringUtils.isNotBlank(deprecatedComment)) {
            reference.setDeprecated(true);
        }
        reference.setIconName(iconName);
        this.references.add(reference);
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    private String convertComment(String comment) {
        return comment.replaceAll("(?m)^[\\s*]*", "").replaceAll("\\{@\\w*\\s*(#[^\\}\\s]*)?\\s*(?<value>[^\\}]*)\\s*\\}", "${value}").replaceAll("(\r\n|\r|\n)@[\\S\\s]*", "").replaceAll("\r\n|\r|\n", " ").replaceAll("\\s{2,}", " ").trim();
    }

    private String encode(String str) {
        return str.replace("<", "&lt;").replace(">", "&gt;");
    }
}

