/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.util;

import com.mirth.connect.model.Filter;
import com.mirth.connect.model.Rule;
import com.mirth.connect.model.Step;
import com.mirth.connect.model.Transformer;
import com.mirth.connect.util.ScriptBuilderException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class VariableListUtil {
    static final String COMMENT_SIMPLE_PATTERN = "//.*";
    static final String COMMENT_BLOCK_PATTERN = "/\\*(?:.|[\\n\\r])*?\\*/";
    static final String GLOBAL_AND_CHANNEL_VARIABLE_PATTERN = "(?<![A-Za-z0-9_$])(?:channel|global|globalChannel|response)Map\\s*\\.\\s*put\\s*\\(\\s*(['\"])(((?!(?<!\\\\)\\1).)*)\\1|(?<![A-Za-z0-9_$])\\$(?:g|gc|c|r)\\s*\\(\\s*(['\"])(((?!(?<!\\\\)\\4).)*)\\4(?=\\s*,)";
    static final String LOCAL_VARIABLE_PATTERN = "(?<![A-Za-z0-9_$])(?:channel|global|globalChannel|response|connector)Map\\s*\\.\\s*put\\s*\\(\\s*(['\"])(((?!(?<!\\\\)\\1).)*)\\1|(?<![A-Za-z0-9_$])\\$(?:g|gc|c|r|co)\\s*\\(\\s*(['\"])(((?!(?<!\\\\)\\4).)*)\\4(?=\\s*,)";
    static final int FULL_NAME_MATCHER_INDEX = 2;
    static final int SHORT_NAME_MATCHER_INDEX = 5;

    public static void getStepVariables(Set<String> targetSet, Transformer transformer, boolean includeLocalVars) {
        VariableListUtil.getStepVariables(targetSet, transformer, includeLocalVars, -1);
    }

    public static void getStepVariables(Set<String> targetSet, Transformer transformer, boolean includeLocalVars, int row) {
        List connectorSteps = transformer.getElements();
        Iterator stepIterator = connectorSteps.iterator();
        String varPattern = GLOBAL_AND_CHANNEL_VARIABLE_PATTERN;
        if (includeLocalVars) {
            varPattern = LOCAL_VARIABLE_PATTERN;
        }
        int currentRow = 0;
        while (stepIterator.hasNext() && (row <= -1 || row > currentRow)) {
            ++currentRow;
            Step step = (Step)stepIterator.next();
            if (!step.isEnabled()) continue;
            Pattern pattern = Pattern.compile(varPattern);
            try {
                String script = step.getScript(false);
                if (!StringUtils.isNotEmpty((CharSequence)script)) continue;
                String scriptWithoutComments = VariableListUtil.getScriptWithoutComments(script);
                Matcher matcher = pattern.matcher(scriptWithoutComments);
                while (matcher.find()) {
                    targetSet.add(VariableListUtil.getMapKey(matcher));
                }
            }
            catch (ScriptBuilderException scriptBuilderException) {
            }
        }
    }

    public static void getRuleVariables(Set<String> targetSet, Filter filter, boolean includeLocalVars) {
        VariableListUtil.getRuleVariables(targetSet, filter, includeLocalVars, -1);
    }

    public static void getRuleVariables(Set<String> targetSet, Filter filter, boolean includeLocalVars, int row) {
        List connectorRules = filter.getElements();
        Iterator ruleIterator = connectorRules.iterator();
        String varPattern = GLOBAL_AND_CHANNEL_VARIABLE_PATTERN;
        if (includeLocalVars) {
            varPattern = LOCAL_VARIABLE_PATTERN;
        }
        int currentRow = 0;
        while (ruleIterator.hasNext() && (row <= -1 || row > currentRow)) {
            ++currentRow;
            Rule rule = (Rule)ruleIterator.next();
            if (!rule.isEnabled()) continue;
            Pattern pattern = Pattern.compile(varPattern);
            try {
                String script = rule.getScript(false);
                if (!StringUtils.isNotEmpty((CharSequence)script)) continue;
                String scriptWithoutComments = VariableListUtil.getScriptWithoutComments(script);
                Matcher matcher = pattern.matcher(scriptWithoutComments);
                while (matcher.find()) {
                    targetSet.add(VariableListUtil.getMapKey(matcher));
                }
            }
            catch (ScriptBuilderException scriptBuilderException) {
            }
        }
    }

    private static String getScriptWithoutComments(String script) {
        String scriptWithoutSimpleComments = null;
        String scriptWithoutCommentBlocks = null;
        String scriptWithoutComments = null;
        try {
            scriptWithoutSimpleComments = script.replaceAll(COMMENT_SIMPLE_PATTERN, "");
            scriptWithoutCommentBlocks = scriptWithoutSimpleComments.replaceAll(COMMENT_BLOCK_PATTERN, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scriptWithoutComments = scriptWithoutCommentBlocks != null ? scriptWithoutCommentBlocks : (scriptWithoutSimpleComments != null ? scriptWithoutSimpleComments : script);
        return scriptWithoutComments;
    }

    private static String getMapKey(Matcher matcher) {
        String key = matcher.group(2);
        if (key == null) {
            key = matcher.group(5);
        }
        return StringEscapeUtils.unescapeEcmaScript((String)key);
    }
}

