/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import java.util.Properties;
import java.util.Set;

public abstract class ClientPlugin {
    protected String pluginName;
    protected Frame parent = PlatformUI.MIRTH_FRAME;

    public ClientPlugin(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Properties getPropertiesFromServer() throws ClientException {
        return this.getPropertiesFromServer(null);
    }

    public Properties getPropertiesFromServer(Set<String> propertyKeys) throws ClientException {
        return this.parent.mirthClient.getPluginProperties(this.pluginName, propertyKeys);
    }

    public void setPropertiesToServer(Properties properties) throws ClientException {
        this.setPropertiesToServer(properties, false);
    }

    public void setPropertiesToServer(Properties properties, boolean mergeProperties) throws ClientException {
        this.parent.mirthClient.setPluginProperties(this.pluginName, properties, mergeProperties);
    }

    public abstract String getPluginPointName();

    public abstract void start();

    public abstract void stop();

    public abstract void reset();
}

