/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dicomviewer;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.plugins.AttachmentViewer;
import ij.gui.ImageWindow;
import ij.plugin.DICOM;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class DICOMViewer
extends AttachmentViewer {
    public DICOMViewer(String name) {
        super(name);
    }

    @Override
    public boolean handleMultiple() {
        return true;
    }

    @Override
    public void viewAttachments(String channelId, Long messageId, String attachmentId) {
        try {
            ConnectorMessage message = this.parent.messageBrowser.getSelectedConnectorMessage();
            byte[] rawImage = org.apache.commons.codec.binary.StringUtils.getBytesUsAscii((String)this.parent.mirthClient.getDICOMMessage(message));
            BufferedInputStream bis = new BufferedInputStream((InputStream)new Base64InputStream((InputStream)new ByteArrayInputStream(rawImage)));
            bis.mark(128);
            if (bis.read(new byte[128], 0, 128) != 128) {
                IOUtils.closeQuietly((InputStream)bis);
                throw new Exception("Attachment is not a valid DICOM file.");
            }
            bis.reset();
            DICOM dcm = new DICOM(bis);
            dcm.run("DICOM Image Viewer");
            dcm.show();
            ImageWindow window = dcm.getWindow();
            if (window != null) {
                Dimension dlgSize = window.getSize();
                Dimension frmSize = this.parent.getSize();
                Point loc = this.parent.getLocation();
                if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
                    dcm.getWindow().setLocationRelativeTo(null);
                } else {
                    dcm.getWindow().setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
                }
            } else {
                this.parent.alertError((Component)((Object)this.parent), "Unable to load DICOM attachment.");
            }
        }
        catch (Exception e) {
            this.parent.alertThrowable((Component)((Object)this.parent), e);
        }
    }

    @Override
    public boolean isContentTypeViewable(String contentType) {
        return StringUtils.containsIgnoreCase((CharSequence)contentType, (CharSequence)"dicom");
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void reset() {
    }

    @Override
    public String getPluginPointName() {
        return "DICOM Viewer";
    }
}

