/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth;

import com.google.common.base.Strings;
import com.mirth.connect.client.ui.AbstractConnectorPropertiesPanel;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.connectors.http.HttpDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.InvalidConnectorPluginProperties;
import com.mirth.connect.plugins.ConnectorPropertiesPlugin;
import com.mirth.connect.plugins.httpauth.HttpAuthConnectorPluginProperties;
import com.mirth.connect.plugins.httpauth.NoneHttpAuthProperties;
import com.mirth.connect.plugins.httpauth.basic.BasicHttpAuthProperties;
import com.mirth.connect.plugins.httpauth.custom.CustomHttpAuthProperties;
import com.mirth.connect.plugins.httpauth.digest.DigestHttpAuthProperties;
import com.mirth.connect.plugins.httpauth.javascript.JavaScriptHttpAuthDialog;
import com.mirth.connect.plugins.httpauth.javascript.JavaScriptHttpAuthProperties;
import com.mirth.connect.plugins.httpauth.oauth2.OAuth2HttpAuthProperties;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.mozilla.javascript.Context;

public class HttpAuthConnectorPropertiesPanel
extends AbstractConnectorPropertiesPanel {
    private static final String SCRIPT_DEFAULT = "<Default Script Set>";
    private static final String SCRIPT_SET = "<Custom Script Set>";
    private HttpAuthConnectorPluginProperties.AuthType selectedAuthType = HttpAuthConnectorPluginProperties.AuthType.NONE;
    private boolean forceAuthTypeChange = false;
    private String jsScript = "";
    private static final ImageIcon ICON_WRENCH = new ImageIcon(com.mirth.connect.client.ui.Frame.class.getResource("images/wrench.png"));
    private JLabel typeLabel;
    private JComboBox typeComboBox;
    private JLabel basicRealmLabel;
    private JTextField basicRealmField;
    private JLabel basicCredentialsLabel;
    private JPanel basicCredentialsPanel;
    private MirthRadioButton useBasicCredentialsTableRadio;
    private MirthRadioButton useBasicCredentialsVariableRadio;
    private MirthTextField basicCredentialsVariableField;
    private MirthTable basicCredentialsTable;
    private JScrollPane basicCredentialsTableScrollPane;
    private JButton basicCredentialsNewButton;
    private JButton basicCredentialsDeleteButton;
    private JLabel digestRealmLabel;
    private JTextField digestRealmField;
    private JLabel digestAlgorithmLabel;
    private JRadioButton digestAlgorithmMD5Radio;
    private JRadioButton digestAlgorithmMD5SessRadio;
    private JRadioButton digestAlgorithmBothRadio;
    private JLabel digestQOPLabel;
    private JCheckBox digestQOPAuthCheckBox;
    private JCheckBox digestQOPAuthIntCheckBox;
    private JLabel digestOpaqueLabel;
    private JTextField digestOpaqueField;
    private JLabel digestCredentialsLabel;
    private JPanel digestCredentialsPanel;
    private MirthRadioButton useDigestCredentialsTableRadio;
    private MirthRadioButton useDigestCredentialsVariableRadio;
    private MirthTextField digestCredentialsVariableField;
    private MirthTable digestCredentialsTable;
    private JScrollPane digestCredentialsTableScrollPane;
    private JButton digestCredentialsNewButton;
    private JButton digestCredentialsDeleteButton;
    private JLabel jsScriptLabel;
    private JTextField jsScriptField;
    private JLabel customClassNameLabel;
    private JTextField customClassNameField;
    private JLabel customPropertiesLabel;
    private JPanel customPropertiesPanel;
    private MirthTable customPropertiesTable;
    private JScrollPane customPropertiesTableScrollPane;
    private JButton customPropertiesNewButton;
    private JButton customPropertiesDeleteButton;
    private JLabel oauth2TokenLabel;
    private JComboBox oauth2TokenLocationComboBox;
    private JTextField oauth2TokenField;
    private JLabel oauth2VerificationURLLabel;
    private JTextField oauth2VerificationURLField;
    private AbstractConnectorPropertiesPanel connectorPropertiesPanel;

    public HttpAuthConnectorPropertiesPanel() {
        this.initComponents();
        this.initToolTips();
        this.initLayout();
    }

    @Override
    public ConnectorPluginProperties getProperties() {
        return this.getProperties((HttpAuthConnectorPluginProperties.AuthType)this.typeComboBox.getSelectedItem());
    }

    private HttpAuthConnectorPluginProperties getProperties(HttpAuthConnectorPluginProperties.AuthType authType) {
        if (authType == HttpAuthConnectorPluginProperties.AuthType.BASIC) {
            BasicHttpAuthProperties props = new BasicHttpAuthProperties();
            props.setRealm(this.basicRealmField.getText());
            if (this.basicCredentialsTable.isEditing()) {
                this.basicCredentialsTable.getCellEditor().stopCellEditing();
                this.basicCredentialsTable.clearSelection();
            }
            for (int row = 0; row < this.basicCredentialsTable.getModel().getRowCount(); ++row) {
                props.getCredentialsMap().put((String)this.basicCredentialsTable.getModel().getValueAt(row, 0), (String)this.basicCredentialsTable.getModel().getValueAt(row, 1));
            }
            props.setCredentialsVariable(this.basicCredentialsVariableField.getText());
            props.setUseCredentialsVariable(this.useBasicCredentialsVariableRadio.isSelected());
            return props;
        }
        if (authType == HttpAuthConnectorPluginProperties.AuthType.DIGEST) {
            DigestHttpAuthProperties props = new DigestHttpAuthProperties();
            props.setRealm(this.digestRealmField.getText());
            if (this.digestAlgorithmMD5Radio.isSelected()) {
                props.setAlgorithms(new HashSet<DigestHttpAuthProperties.Algorithm>(Arrays.asList(DigestHttpAuthProperties.Algorithm.MD5)));
            } else if (this.digestAlgorithmMD5SessRadio.isSelected()) {
                props.setAlgorithms(new HashSet<DigestHttpAuthProperties.Algorithm>(Arrays.asList(DigestHttpAuthProperties.Algorithm.MD5_SESS)));
            } else {
                props.setAlgorithms(new HashSet<DigestHttpAuthProperties.Algorithm>(Arrays.asList(DigestHttpAuthProperties.Algorithm.values())));
            }
            HashSet<DigestHttpAuthProperties.QOPMode> qopModes = new HashSet<DigestHttpAuthProperties.QOPMode>();
            if (this.digestQOPAuthCheckBox.isSelected()) {
                qopModes.add(DigestHttpAuthProperties.QOPMode.AUTH);
            }
            if (this.digestQOPAuthIntCheckBox.isSelected()) {
                qopModes.add(DigestHttpAuthProperties.QOPMode.AUTH_INT);
            }
            props.setQopModes(qopModes);
            props.setOpaque(this.digestOpaqueField.getText());
            if (this.digestCredentialsTable.isEditing()) {
                this.digestCredentialsTable.getCellEditor().stopCellEditing();
                this.digestCredentialsTable.clearSelection();
            }
            for (int row = 0; row < this.digestCredentialsTable.getModel().getRowCount(); ++row) {
                props.getCredentialsMap().put((String)this.digestCredentialsTable.getModel().getValueAt(row, 0), (String)this.digestCredentialsTable.getModel().getValueAt(row, 1));
            }
            props.setCredentialsVariable(this.digestCredentialsVariableField.getText());
            props.setUseCredentialsVariable(this.useDigestCredentialsVariableRadio.isSelected());
            return props;
        }
        if (authType == HttpAuthConnectorPluginProperties.AuthType.JAVASCRIPT) {
            JavaScriptHttpAuthProperties props = new JavaScriptHttpAuthProperties();
            props.setScript(this.jsScript);
            return props;
        }
        if (authType == HttpAuthConnectorPluginProperties.AuthType.CUSTOM) {
            CustomHttpAuthProperties props = new CustomHttpAuthProperties();
            props.setAuthenticatorClass(this.customClassNameField.getText());
            if (this.customPropertiesTable.isEditing()) {
                this.customPropertiesTable.getCellEditor().stopCellEditing();
                this.customPropertiesTable.clearSelection();
            }
            for (int row = 0; row < this.customPropertiesTable.getModel().getRowCount(); ++row) {
                props.getProperties().put((String)this.customPropertiesTable.getModel().getValueAt(row, 0), (String)this.customPropertiesTable.getModel().getValueAt(row, 1));
            }
            return props;
        }
        if (authType == HttpAuthConnectorPluginProperties.AuthType.OAUTH2_VERIFICATION) {
            OAuth2HttpAuthProperties props = new OAuth2HttpAuthProperties();
            props.setTokenLocation((OAuth2HttpAuthProperties.TokenLocation)this.oauth2TokenLocationComboBox.getSelectedItem());
            props.setLocationKey(this.oauth2TokenField.getText());
            props.setVerificationURL(this.oauth2VerificationURLField.getText());
            if (this.connectorPropertiesPanel != null) {
                HashSet<ConnectorPluginProperties> connectorPluginProperties = new HashSet<ConnectorPluginProperties>();
                connectorPluginProperties.add(this.connectorPropertiesPanel.getProperties());
                props.setConnectorPluginProperties(connectorPluginProperties);
            }
            return props;
        }
        return new NoneHttpAuthProperties();
    }

    @Override
    public void setProperties(ConnectorProperties connectorProperties, ConnectorPluginProperties properties, Connector.Mode mode, String transportName) {
        this.forceAuthTypeChange = true;
        this.typeComboBox.setSelectedItem(((HttpAuthConnectorPluginProperties)properties).getAuthType());
        this.authTypeChanged();
        this.forceAuthTypeChange = false;
        this.setProperties(connectorProperties, properties);
    }

    private void setProperties(ConnectorProperties connectorProperties, ConnectorPluginProperties properties) {
        if (properties instanceof BasicHttpAuthProperties) {
            BasicHttpAuthProperties props = (BasicHttpAuthProperties)properties;
            this.basicRealmField.setText(props.getRealm());
            Object[][] data = new Object[props.getCredentialsMap().size()][2];
            int i = 0;
            for (Map.Entry entry : props.getCredentialsMap().entrySet()) {
                data[i][0] = entry.getKey();
                data[i][1] = entry.getValue();
                ++i;
            }
            ((RefreshTableModel)this.basicCredentialsTable.getModel()).refreshDataVector(data);
            if (props.isUseCredentialsVariable()) {
                this.useBasicCredentialsVariableRadio.setSelected(true);
            } else {
                this.useBasicCredentialsTableRadio.setSelected(true);
            }
            this.basicCredentialsVariableField.setText(props.getCredentialsVariable());
            this.useBasicCredentialsVariableFieldsEnabled(props.isUseCredentialsVariable());
        } else if (properties instanceof DigestHttpAuthProperties) {
            DigestHttpAuthProperties props = (DigestHttpAuthProperties)properties;
            this.digestRealmField.setText(props.getRealm());
            if (props.getAlgorithms().contains(DigestHttpAuthProperties.Algorithm.MD5) && props.getAlgorithms().contains(DigestHttpAuthProperties.Algorithm.MD5_SESS)) {
                this.digestAlgorithmBothRadio.setSelected(true);
            } else if (props.getAlgorithms().contains(DigestHttpAuthProperties.Algorithm.MD5)) {
                this.digestAlgorithmMD5Radio.setSelected(true);
            } else if (props.getAlgorithms().contains(DigestHttpAuthProperties.Algorithm.MD5_SESS)) {
                this.digestAlgorithmMD5SessRadio.setSelected(true);
            }
            this.digestQOPAuthCheckBox.setSelected(props.getQopModes().contains(DigestHttpAuthProperties.QOPMode.AUTH));
            this.digestQOPAuthIntCheckBox.setSelected(props.getQopModes().contains(DigestHttpAuthProperties.QOPMode.AUTH_INT));
            this.digestOpaqueField.setText(props.getOpaque());
            Object[][] data = new Object[props.getCredentialsMap().size()][2];
            int i = 0;
            for (Map.Entry entry : props.getCredentialsMap().entrySet()) {
                data[i][0] = entry.getKey();
                data[i][1] = entry.getValue();
                ++i;
            }
            ((RefreshTableModel)this.digestCredentialsTable.getModel()).refreshDataVector(data);
            if (props.isUseCredentialsVariable()) {
                this.useDigestCredentialsVariableRadio.setSelected(true);
            } else {
                this.useDigestCredentialsTableRadio.setSelected(true);
            }
            this.digestCredentialsVariableField.setText(props.getCredentialsVariable());
            this.useDigestCredentialsVariableFieldsEnabled(props.isUseCredentialsVariable());
        } else if (properties instanceof JavaScriptHttpAuthProperties) {
            JavaScriptHttpAuthProperties props = (JavaScriptHttpAuthProperties)properties;
            this.jsScript = props.getScript();
            this.updateJSScriptField();
        } else if (properties instanceof CustomHttpAuthProperties) {
            CustomHttpAuthProperties props = (CustomHttpAuthProperties)properties;
            this.customClassNameField.setText(props.getAuthenticatorClass());
            Object[][] data = new Object[props.getProperties().size()][2];
            int i = 0;
            for (Map.Entry entry : props.getProperties().entrySet()) {
                data[i][0] = entry.getKey();
                data[i][1] = entry.getValue();
                ++i;
            }
            ((RefreshTableModel)this.customPropertiesTable.getModel()).refreshDataVector(data);
        } else if (properties instanceof OAuth2HttpAuthProperties) {
            OAuth2HttpAuthProperties props = (OAuth2HttpAuthProperties)properties;
            this.oauth2TokenLocationComboBox.setSelectedItem(props.getTokenLocation());
            this.oauth2TokenField.setText(props.getLocationKey());
            this.oauth2VerificationURLField.setText(props.getVerificationURL());
            if (this.connectorPropertiesPanel != null) {
                ConnectorPluginProperties pluginProperties;
                HashSet<ConnectorPluginProperties> connectorPluginProperties = props.getConnectorPluginProperties();
                if (CollectionUtils.isEmpty((Collection)connectorPluginProperties)) {
                    connectorPluginProperties = new HashSet<ConnectorPluginProperties>();
                    connectorPluginProperties.add(this.connectorPropertiesPanel.getDefaults());
                }
                if (!((pluginProperties = (ConnectorPluginProperties)connectorPluginProperties.iterator().next()) instanceof InvalidConnectorPluginProperties)) {
                    this.connectorPropertiesPanel.setProperties(connectorProperties, pluginProperties, Connector.Mode.DESTINATION, new HttpDispatcherProperties().getName());
                }
            }
        }
    }

    @Override
    public ConnectorPluginProperties getDefaults() {
        return this.getDefaultProperties(HttpAuthConnectorPluginProperties.AuthType.NONE);
    }

    private HttpAuthConnectorPluginProperties getDefaultProperties(HttpAuthConnectorPluginProperties.AuthType authType) {
        if (authType == HttpAuthConnectorPluginProperties.AuthType.BASIC) {
            return new BasicHttpAuthProperties();
        }
        if (authType == HttpAuthConnectorPluginProperties.AuthType.DIGEST) {
            return new DigestHttpAuthProperties();
        }
        if (authType == HttpAuthConnectorPluginProperties.AuthType.JAVASCRIPT) {
            return new JavaScriptHttpAuthProperties();
        }
        if (authType == HttpAuthConnectorPluginProperties.AuthType.CUSTOM) {
            return new CustomHttpAuthProperties();
        }
        if (authType == HttpAuthConnectorPluginProperties.AuthType.OAUTH2_VERIFICATION) {
            OAuth2HttpAuthProperties props = new OAuth2HttpAuthProperties();
            if (this.connectorPropertiesPanel != null) {
                HashSet<ConnectorPluginProperties> connectorPluginProperties = new HashSet<ConnectorPluginProperties>();
                connectorPluginProperties.add(this.connectorPropertiesPanel.getDefaults());
                props.setConnectorPluginProperties(connectorPluginProperties);
            }
            return props;
        }
        return new NoneHttpAuthProperties();
    }

    @Override
    public boolean checkProperties(ConnectorProperties connectorProperties, ConnectorPluginProperties properties, Connector.Mode mode, String transportName, boolean highlight) {
        boolean valid;
        block14: {
            block16: {
                block15: {
                    block13: {
                        valid = true;
                        if (!(properties instanceof BasicHttpAuthProperties)) break block13;
                        BasicHttpAuthProperties props = (BasicHttpAuthProperties)properties;
                        if (StringUtils.isBlank((CharSequence)props.getRealm())) {
                            valid = false;
                            if (highlight) {
                                this.basicRealmField.setBackground(UIConstants.INVALID_COLOR);
                            }
                        }
                        if (props.getCredentialsMap().size() == 0 && !props.isUseCredentialsVariable() || Strings.isNullOrEmpty((String)props.getCredentialsVariable()) && props.isUseCredentialsVariable()) {
                            valid = false;
                        }
                        break block14;
                    }
                    if (!(properties instanceof DigestHttpAuthProperties)) break block15;
                    DigestHttpAuthProperties props = (DigestHttpAuthProperties)properties;
                    if (StringUtils.isBlank((CharSequence)props.getRealm())) {
                        valid = false;
                        if (highlight) {
                            this.digestRealmField.setBackground(UIConstants.INVALID_COLOR);
                        }
                    }
                    if (props.getCredentialsMap().size() == 0 && !props.isUseCredentialsVariable() || Strings.isNullOrEmpty((String)props.getCredentialsVariable()) && props.isUseCredentialsVariable()) {
                        valid = false;
                    }
                    break block14;
                }
                if (!(properties instanceof CustomHttpAuthProperties)) break block16;
                CustomHttpAuthProperties props = (CustomHttpAuthProperties)properties;
                if (!StringUtils.isBlank((CharSequence)props.getAuthenticatorClass())) break block14;
                valid = false;
                if (!highlight) break block14;
                this.customClassNameField.setBackground(UIConstants.INVALID_COLOR);
                break block14;
            }
            if (properties instanceof OAuth2HttpAuthProperties) {
                OAuth2HttpAuthProperties props = (OAuth2HttpAuthProperties)properties;
                if (StringUtils.isBlank((CharSequence)props.getLocationKey())) {
                    valid = false;
                    if (highlight) {
                        this.oauth2TokenField.setBackground(UIConstants.INVALID_COLOR);
                    }
                }
                if (StringUtils.isBlank((CharSequence)props.getVerificationURL())) {
                    valid = false;
                    if (highlight) {
                        this.oauth2VerificationURLField.setBackground(UIConstants.INVALID_COLOR);
                    }
                }
                if (this.connectorPropertiesPanel != null && props.getConnectorPluginProperties() != null) {
                    for (ConnectorPluginProperties pluginProperties : props.getConnectorPluginProperties()) {
                        if (pluginProperties instanceof InvalidConnectorPluginProperties || this.connectorPropertiesPanel.checkProperties(connectorProperties, pluginProperties, Connector.Mode.DESTINATION, new HttpDispatcherProperties().getName(), highlight)) continue;
                        valid = false;
                    }
                }
            }
        }
        return valid;
    }

    @Override
    public void resetInvalidProperties() {
        this.basicRealmField.setBackground(null);
        this.digestRealmField.setBackground(null);
        this.customClassNameField.setBackground(null);
        this.oauth2TokenField.setBackground(null);
        this.oauth2VerificationURLField.setBackground(null);
    }

    @Override
    public Component[][] getLayoutComponents() {
        return null;
    }

    @Override
    public void setLayoutComponentsEnabled(boolean enabled) {
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.typeLabel = new JLabel("Authentication Type:");
        this.typeLabel.setHorizontalAlignment(4);
        this.typeComboBox = new MirthComboBox();
        this.typeComboBox.setModel(new DefaultComboBoxModel<HttpAuthConnectorPluginProperties.AuthType>(HttpAuthConnectorPluginProperties.AuthType.values()));
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpAuthConnectorPropertiesPanel.this.authTypeChanged();
            }
        });
        this.basicRealmLabel = new JLabel("Realm:");
        this.basicRealmField = new MirthTextField();
        this.basicCredentialsLabel = new JLabel("Credentials:");
        this.basicCredentialsPanel = new JPanel();
        this.basicCredentialsPanel.setBackground(this.getBackground());
        this.basicCredentialsTable = new MirthTable();
        this.basicCredentialsTable.setModel(new RefreshTableModel(new String[]{"Username", "Password"}, 0));
        this.basicCredentialsTable.setCustomEditorControls(true);
        this.basicCredentialsTable.setSelectionMode(0);
        this.basicCredentialsTable.setRowSelectionAllowed(true);
        this.basicCredentialsTable.setRowHeight(20);
        this.basicCredentialsTable.setDragEnabled(false);
        this.basicCredentialsTable.setOpaque(true);
        this.basicCredentialsTable.setSortable(false);
        this.basicCredentialsTable.getTableHeader().setReorderingAllowed(false);
        this.basicCredentialsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.basicCredentialsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        CredentialsTableCellEditor basicCredentialsTableCellEditor = new CredentialsTableCellEditor((JTable)((Object)this.basicCredentialsTable));
        this.basicCredentialsTable.getColumnExt(0).setCellEditor((TableCellEditor)basicCredentialsTableCellEditor);
        this.basicCredentialsTable.getColumnExt(1).setCellRenderer((TableCellRenderer)new PasswordCellRenderer());
        this.basicCredentialsTable.getColumnExt(1).setCellEditor((TableCellEditor)new DefaultCellEditor(new MirthPasswordField()));
        this.basicCredentialsTableScrollPane = new JScrollPane((Component)((Object)this.basicCredentialsTable));
        this.basicCredentialsNewButton = new MirthButton("New");
        this.basicCredentialsNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String username;
                boolean found;
                int num = 0;
                do {
                    username = "user" + ++num;
                    found = false;
                    for (int row = 0; row < HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.getModel().getRowCount(); ++row) {
                        if (!StringUtils.equals((CharSequence)username, (CharSequence)((String)HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.getModel().getValueAt(row, 0)))) continue;
                        found = true;
                    }
                } while (found);
                ((DefaultTableModel)HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.getModel()).addRow(new String[]{username, ""});
                HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.setRowSelectionInterval(HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.getRowCount() - 1, HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.getRowCount() - 1);
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            }
        });
        this.basicCredentialsDeleteButton = new MirthButton("Delete");
        this.basicCredentialsDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selectedRow = HttpAuthConnectorPropertiesPanel.this.getSelectedRow(HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable);
                if (selectedRow >= 0) {
                    if (HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.isEditing()) {
                        HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.getCellEditor().cancelCellEditing();
                    }
                    ((DefaultTableModel)HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.getModel()).removeRow(selectedRow);
                    int rowCount = HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.getRowCount();
                    if (selectedRow < rowCount) {
                        HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.setRowSelectionInterval(selectedRow, selectedRow);
                    } else if (rowCount > 0) {
                        HttpAuthConnectorPropertiesPanel.this.basicCredentialsTable.setRowSelectionInterval(rowCount - 1, rowCount - 1);
                    }
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                }
            }
        });
        basicCredentialsTableCellEditor.setDeleteButton(this.basicCredentialsDeleteButton);
        this.useBasicCredentialsTableRadio = new MirthRadioButton("Use Table");
        this.useBasicCredentialsTableRadio.setBackground(this.getBackground());
        this.useBasicCredentialsTableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpAuthConnectorPropertiesPanel.this.useBasicCredentialsVariableFieldsEnabled(false);
            }
        });
        this.useBasicCredentialsVariableRadio = new MirthRadioButton("Use Map:");
        this.useBasicCredentialsVariableRadio.setBackground(this.getBackground());
        this.useBasicCredentialsVariableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpAuthConnectorPropertiesPanel.this.useBasicCredentialsVariableFieldsEnabled(true);
            }
        });
        ButtonGroup basicCredentialsSourceButtonGroup = new ButtonGroup();
        basicCredentialsSourceButtonGroup.add(this.useBasicCredentialsTableRadio);
        basicCredentialsSourceButtonGroup.add(this.useBasicCredentialsVariableRadio);
        this.basicCredentialsVariableField = new MirthTextField();
        this.digestRealmLabel = new JLabel("Realm:");
        this.digestRealmField = new MirthTextField();
        this.digestAlgorithmLabel = new JLabel("Algorithms:");
        ButtonGroup digestAlgorithmButtonGroup = new ButtonGroup();
        this.digestAlgorithmMD5Radio = new MirthRadioButton(DigestHttpAuthProperties.Algorithm.MD5.toString());
        this.digestAlgorithmMD5Radio.setBackground(this.getBackground());
        digestAlgorithmButtonGroup.add(this.digestAlgorithmMD5Radio);
        this.digestAlgorithmMD5SessRadio = new MirthRadioButton(DigestHttpAuthProperties.Algorithm.MD5_SESS.toString());
        this.digestAlgorithmMD5SessRadio.setBackground(this.getBackground());
        digestAlgorithmButtonGroup.add(this.digestAlgorithmMD5SessRadio);
        this.digestAlgorithmBothRadio = new MirthRadioButton("Both");
        this.digestAlgorithmBothRadio.setBackground(this.getBackground());
        digestAlgorithmButtonGroup.add(this.digestAlgorithmBothRadio);
        this.digestQOPLabel = new JLabel("QOP Modes:");
        this.digestQOPAuthCheckBox = new MirthCheckBox(DigestHttpAuthProperties.QOPMode.AUTH.toString());
        this.digestQOPAuthCheckBox.setBackground(this.getBackground());
        this.digestQOPAuthIntCheckBox = new MirthCheckBox(DigestHttpAuthProperties.QOPMode.AUTH_INT.toString());
        this.digestQOPAuthIntCheckBox.setBackground(this.getBackground());
        this.digestOpaqueLabel = new JLabel("Opaque:");
        this.digestOpaqueField = new MirthTextField();
        this.digestCredentialsLabel = new JLabel("Credentials:");
        this.digestCredentialsPanel = new JPanel();
        this.digestCredentialsPanel.setBackground(this.getBackground());
        this.digestCredentialsTable = new MirthTable();
        this.digestCredentialsTable.setModel(new RefreshTableModel(new String[]{"Username", "Password"}, 0));
        this.digestCredentialsTable.setCustomEditorControls(true);
        this.digestCredentialsTable.setSelectionMode(0);
        this.digestCredentialsTable.setRowSelectionAllowed(true);
        this.digestCredentialsTable.setRowHeight(20);
        this.digestCredentialsTable.setDragEnabled(false);
        this.digestCredentialsTable.setOpaque(true);
        this.digestCredentialsTable.setSortable(false);
        this.digestCredentialsTable.getTableHeader().setReorderingAllowed(false);
        this.digestCredentialsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.digestCredentialsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        CredentialsTableCellEditor digestCredentialsTableCellEditor = new CredentialsTableCellEditor((JTable)((Object)this.digestCredentialsTable));
        this.digestCredentialsTable.getColumnExt(0).setCellEditor((TableCellEditor)digestCredentialsTableCellEditor);
        this.digestCredentialsTable.getColumnExt(1).setCellRenderer((TableCellRenderer)new PasswordCellRenderer());
        this.digestCredentialsTable.getColumnExt(1).setCellEditor((TableCellEditor)new DefaultCellEditor(new MirthPasswordField()));
        this.digestCredentialsTableScrollPane = new JScrollPane((Component)((Object)this.digestCredentialsTable));
        this.digestCredentialsNewButton = new MirthButton("New");
        this.digestCredentialsNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String username;
                boolean found;
                int num = 0;
                do {
                    username = "user" + ++num;
                    found = false;
                    for (int row = 0; row < HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.getModel().getRowCount(); ++row) {
                        if (!StringUtils.equals((CharSequence)username, (CharSequence)((String)HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.getModel().getValueAt(row, 0)))) continue;
                        found = true;
                    }
                } while (found);
                ((DefaultTableModel)HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.getModel()).addRow(new String[]{username, ""});
                HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.setRowSelectionInterval(HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.getRowCount() - 1, HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.getRowCount() - 1);
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            }
        });
        this.digestCredentialsDeleteButton = new MirthButton("Delete");
        this.digestCredentialsDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selectedRow = HttpAuthConnectorPropertiesPanel.this.getSelectedRow(HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable);
                if (selectedRow >= 0) {
                    if (HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.isEditing()) {
                        HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.getCellEditor().cancelCellEditing();
                    }
                    ((DefaultTableModel)HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.getModel()).removeRow(selectedRow);
                    int rowCount = HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.getRowCount();
                    if (selectedRow < rowCount) {
                        HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.setRowSelectionInterval(selectedRow, selectedRow);
                    } else if (rowCount > 0) {
                        HttpAuthConnectorPropertiesPanel.this.digestCredentialsTable.setRowSelectionInterval(rowCount - 1, rowCount - 1);
                    }
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                }
            }
        });
        digestCredentialsTableCellEditor.setDeleteButton(this.digestCredentialsDeleteButton);
        this.useDigestCredentialsTableRadio = new MirthRadioButton("Use Table");
        this.useDigestCredentialsTableRadio.setBackground(this.getBackground());
        this.useDigestCredentialsTableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpAuthConnectorPropertiesPanel.this.useDigestCredentialsVariableFieldsEnabled(false);
            }
        });
        this.useDigestCredentialsVariableRadio = new MirthRadioButton("Use Map:");
        this.useDigestCredentialsVariableRadio.setBackground(this.getBackground());
        this.useDigestCredentialsVariableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpAuthConnectorPropertiesPanel.this.useDigestCredentialsVariableFieldsEnabled(true);
            }
        });
        ButtonGroup digestCredentialsSourceButtonGroup = new ButtonGroup();
        digestCredentialsSourceButtonGroup.add(this.useDigestCredentialsTableRadio);
        digestCredentialsSourceButtonGroup.add(this.useDigestCredentialsVariableRadio);
        this.digestCredentialsVariableField = new MirthTextField();
        this.jsScriptLabel = new JLabel("Script:");
        this.jsScriptField = new JTextField();
        this.jsScriptField.setEditable(false);
        this.jsScriptField.setBackground(this.getBackground());
        this.jsScriptField.setCursor(Cursor.getPredefinedCursor(12));
        this.jsScriptField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                JavaScriptHttpAuthDialog dialog = new JavaScriptHttpAuthDialog((Frame)((Object)PlatformUI.MIRTH_FRAME), HttpAuthConnectorPropertiesPanel.this.jsScript);
                if (dialog.wasSaved()) {
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                    HttpAuthConnectorPropertiesPanel.this.jsScript = dialog.getScript();
                    HttpAuthConnectorPropertiesPanel.this.updateJSScriptField();
                }
            }
        });
        this.customClassNameLabel = new JLabel("Class Name:");
        this.customClassNameField = new MirthTextField();
        this.customPropertiesLabel = new JLabel("Properties:");
        this.customPropertiesPanel = new JPanel();
        this.customPropertiesPanel.setBackground(this.getBackground());
        this.customPropertiesTable = new MirthTable();
        this.customPropertiesTable.setModel(new RefreshTableModel(new String[]{"Name", "Value"}, 0));
        this.customPropertiesTable.setCustomEditorControls(true);
        this.customPropertiesTable.setSelectionMode(0);
        this.customPropertiesTable.setRowSelectionAllowed(true);
        this.customPropertiesTable.setRowHeight(20);
        this.customPropertiesTable.setDragEnabled(false);
        this.customPropertiesTable.setOpaque(true);
        this.customPropertiesTable.setSortable(false);
        this.customPropertiesTable.getTableHeader().setReorderingAllowed(false);
        this.customPropertiesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.customPropertiesTable.setHighlighters(new Highlighter[]{highlighter});
        }
        CredentialsTableCellEditor customPropertiesTableCellEditor = new CredentialsTableCellEditor((JTable)((Object)this.customPropertiesTable));
        this.customPropertiesTable.getColumnExt(0).setCellEditor((TableCellEditor)customPropertiesTableCellEditor);
        this.customPropertiesTable.getColumnExt(1).setCellEditor((TableCellEditor)customPropertiesTableCellEditor);
        this.customPropertiesTableScrollPane = new JScrollPane((Component)((Object)this.customPropertiesTable));
        this.customPropertiesNewButton = new MirthButton("New");
        this.customPropertiesNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String name;
                boolean found;
                int num = 0;
                do {
                    name = "Property " + ++num;
                    found = false;
                    for (int row = 0; row < HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.getModel().getRowCount(); ++row) {
                        if (!StringUtils.equals((CharSequence)name, (CharSequence)((String)HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.getModel().getValueAt(row, 0)))) continue;
                        found = true;
                    }
                } while (found);
                ((DefaultTableModel)HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.getModel()).addRow(new String[]{name, ""});
                HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.setRowSelectionInterval(HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.getRowCount() - 1, HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.getRowCount() - 1);
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            }
        });
        this.customPropertiesDeleteButton = new MirthButton("Delete");
        this.customPropertiesDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selectedRow = HttpAuthConnectorPropertiesPanel.this.getSelectedRow(HttpAuthConnectorPropertiesPanel.this.customPropertiesTable);
                if (selectedRow >= 0) {
                    if (HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.isEditing()) {
                        HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.getCellEditor().cancelCellEditing();
                    }
                    ((DefaultTableModel)HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.getModel()).removeRow(selectedRow);
                    int rowCount = HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.getRowCount();
                    if (selectedRow < rowCount) {
                        HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.setRowSelectionInterval(selectedRow, selectedRow);
                    } else if (rowCount > 0) {
                        HttpAuthConnectorPropertiesPanel.this.customPropertiesTable.setRowSelectionInterval(rowCount - 1, rowCount - 1);
                    }
                    PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
                }
            }
        });
        customPropertiesTableCellEditor.setDeleteButton(this.customPropertiesDeleteButton);
        this.oauth2TokenLabel = new JLabel("Access Token Location:");
        this.oauth2TokenLocationComboBox = new MirthComboBox();
        this.oauth2TokenLocationComboBox.setModel(new DefaultComboBoxModel<OAuth2HttpAuthProperties.TokenLocation>(OAuth2HttpAuthProperties.TokenLocation.values()));
        this.oauth2TokenField = new MirthTextField();
        this.oauth2VerificationURLLabel = new JLabel("Verification URL:");
        this.oauth2VerificationURLField = new MirthTextField();
        for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
            if (!connectorPropertiesPlugin.isConnectorPropertiesPluginSupported("HTTP Auth Connector Plugin Properties")) continue;
            this.connectorPropertiesPanel = connectorPropertiesPlugin.getConnectorPropertiesPanel();
        }
    }

    private void initToolTips() {
        this.typeComboBox.setToolTipText("Select the type of HTTP authentication to perform for incoming requests.");
        this.basicRealmField.setToolTipText("The protection space for this server.");
        this.basicCredentialsTable.setToolTipText("<html>Username and password pairs to authenticate<br/>users with. At least one pair is required.</html>");
        this.basicCredentialsTable.getColumnExt(0).setToolTipText("The username to authenticate with.");
        this.basicCredentialsTable.getColumnExt(1).setToolTipText("The password to authenticate with.");
        this.digestRealmField.setToolTipText("The protection space for this server.");
        String toolTipText = "<html>Specifies the digest algorithms supported by this server.<br/><b>&nbsp;- MD5:</b> The security data A1 will contain the username, realm, and password.<br/><b>&nbsp;- MD5-sess:</b> The security data A1 will also contain the server and client nonces.</html>";
        this.digestAlgorithmMD5Radio.setToolTipText(toolTipText);
        this.digestAlgorithmMD5SessRadio.setToolTipText(toolTipText);
        this.digestAlgorithmBothRadio.setToolTipText(toolTipText);
        toolTipText = "<html>The quality of protection modes to support.<br/><b>&nbsp;- auth:</b> Regular auth with client nonce and count in the digest.<br/><b>&nbsp;- auth-int:</b> Same as auth, but also with message integrity protection enabled.</html>";
        this.digestQOPAuthCheckBox.setToolTipText(toolTipText);
        this.digestQOPAuthIntCheckBox.setToolTipText(toolTipText);
        this.digestOpaqueField.setToolTipText("A string of data that should be returned by the client unchanged.");
        this.digestCredentialsTable.setToolTipText("<html>Username and password pairs to authenticate<br/>users with. At least one pair is required.</html>");
        this.digestCredentialsTable.getColumnExt(0).setToolTipText("The username to authenticate with.");
        this.digestCredentialsTable.getColumnExt(1).setToolTipText("The password to authenticate with.");
        this.jsScriptField.setToolTipText("<html>Click here to open the JavaScript editor dialog.<br/>The return value of this script is used to accept or reject requests.</html>");
        this.customClassNameField.setToolTipText("The fully-qualified Java class name of the Authenticator class to use.");
        this.customPropertiesTable.setToolTipText("Optional properties to pass into the Authenticator class when it is instantiated.");
        this.customPropertiesTable.getColumnExt(0).setToolTipText("The name of the property to include.");
        this.customPropertiesTable.getColumnExt(1).setToolTipText("The value of the property to include.");
        this.oauth2TokenLocationComboBox.setToolTipText("Determines where the access token is located in client requests.");
        this.oauth2TokenField.setToolTipText("The header or query parameter to pass along with the verification request.");
        this.oauth2VerificationURLField.setToolTipText("<html>The HTTP URL to perform a GET request to for access<br/>token verification. If the response code is >= 400,<br/>the authentication attempt is rejected by the server.</html>");
        this.useBasicCredentialsTableRadio.setToolTipText("<html>The table below will be used to populate credentials.</html>");
        this.useBasicCredentialsVariableRadio.setToolTipText("<html>The Java map specified by the following variable will be used to populate credentials.<br/>The map must have String keys and String values.</html>");
        this.basicCredentialsVariableField.setToolTipText("<html>The variable of a Java map to use to populate credentials.<br/>The map must have String keys and String values.</html>");
        this.useDigestCredentialsTableRadio.setToolTipText("<html>The table below will be used to populate credentials.</html>");
        this.useDigestCredentialsVariableRadio.setToolTipText("<html>The Java map specified by the following variable will be used to populate credentials.<br/>The map must have String keys and String values.</html>");
        this.digestCredentialsVariableField.setToolTipText("<html>The variable of a Java map to use to populate credentials.<br/>The map must have String keys and String values.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3", "[]12[]", ""));
        this.add((Component)this.typeLabel, "right, w 115:");
        this.add(this.typeComboBox);
        this.add((Component)this.basicRealmLabel, "newline, right");
        this.add((Component)this.basicRealmField, "w 164!");
        this.add((Component)this.basicCredentialsLabel, "newline, right");
        this.add((Component)this.useBasicCredentialsTableRadio, "split 3");
        this.add(this.useBasicCredentialsVariableRadio);
        this.add((Component)this.basicCredentialsVariableField, "w 125");
        this.basicCredentialsPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
        this.basicCredentialsPanel.add((Component)this.basicCredentialsTableScrollPane, "grow, sy, h 80!, w 300!");
        this.basicCredentialsPanel.add((Component)this.basicCredentialsNewButton, "top, w 44!");
        this.basicCredentialsPanel.add((Component)this.basicCredentialsDeleteButton, "newline, top, w 44!");
        this.add((Component)this.basicCredentialsPanel, "newline, skip 1");
        this.add((Component)this.digestRealmLabel, "newline, right");
        this.add((Component)this.digestRealmField, "w 164!");
        this.add((Component)this.digestAlgorithmLabel, "newline, right");
        this.add((Component)this.digestAlgorithmMD5Radio, "split 3");
        this.add(this.digestAlgorithmMD5SessRadio);
        this.add(this.digestAlgorithmBothRadio);
        this.add((Component)this.digestQOPLabel, "newline, right");
        this.add((Component)this.digestQOPAuthCheckBox, "split 2");
        this.add(this.digestQOPAuthIntCheckBox);
        this.add((Component)this.digestOpaqueLabel, "newline, right");
        this.add((Component)this.digestOpaqueField, "w 200!");
        this.add((Component)this.digestCredentialsLabel, "newline, right");
        this.add((Component)this.useDigestCredentialsTableRadio, "split 3");
        this.add(this.useDigestCredentialsVariableRadio);
        this.add((Component)this.digestCredentialsVariableField, "w 125");
        this.digestCredentialsPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
        this.digestCredentialsPanel.add((Component)this.digestCredentialsTableScrollPane, "grow, sy, h 80!, w 300!");
        this.digestCredentialsPanel.add((Component)this.digestCredentialsNewButton, "top, w 44!");
        this.digestCredentialsPanel.add((Component)this.digestCredentialsDeleteButton, "newline, top, w 44!");
        this.add((Component)this.digestCredentialsPanel, "newline, skip 1");
        this.add((Component)this.jsScriptLabel, "newline, right");
        this.add((Component)this.jsScriptField, "w 164!");
        this.add((Component)this.customClassNameLabel, "newline, right");
        this.add((Component)this.customClassNameField, "w 300!");
        this.add((Component)this.customPropertiesLabel, "newline, top, right");
        this.customPropertiesPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
        this.customPropertiesPanel.add((Component)this.customPropertiesTableScrollPane, "grow, sy, h 80!, w 300!");
        this.customPropertiesPanel.add((Component)this.customPropertiesNewButton, "top, w 44!");
        this.customPropertiesPanel.add((Component)this.customPropertiesDeleteButton, "newline, top, w 44!");
        this.add(this.customPropertiesPanel);
        this.add((Component)this.oauth2TokenLabel, "newline, right");
        this.add((Component)this.oauth2TokenLocationComboBox, "split 2");
        this.add((Component)this.oauth2TokenField, "w 100!");
        this.add((Component)this.oauth2VerificationURLLabel, "newline, right");
        this.add((Component)this.oauth2VerificationURLField, "w 300!");
        if (this.connectorPropertiesPanel != null && this.connectorPropertiesPanel.getLayoutComponents() != null) {
            for (Component[] row : this.connectorPropertiesPanel.getLayoutComponents()) {
                for (int column = 0; column < row.length; ++column) {
                    if (column == 0) {
                        this.add(row[column], "newline, right");
                        continue;
                    }
                    this.add(row[column]);
                }
            }
        }
    }

    private void authTypeChanged() {
        Component[] row;
        int n;
        int n2;
        Component[][] componentArray;
        HttpAuthConnectorPluginProperties.AuthType authType = (HttpAuthConnectorPluginProperties.AuthType)this.typeComboBox.getSelectedItem();
        if (!this.forceAuthTypeChange) {
            if (!this.getProperties(this.selectedAuthType).equals((Object)this.getDefaultProperties(this.selectedAuthType)) && !PlatformUI.MIRTH_FRAME.alertOkCancel((Component)((Object)PlatformUI.MIRTH_FRAME), "The current HTTP authentication properties will be lost. Are you sure you want to continue?")) {
                this.typeComboBox.setSelectedItem(this.selectedAuthType);
                return;
            }
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        }
        this.basicRealmLabel.setVisible(false);
        this.basicRealmField.setVisible(false);
        this.basicCredentialsLabel.setVisible(false);
        this.basicCredentialsPanel.setVisible(false);
        this.useBasicCredentialsTableRadio.setVisible(false);
        this.useBasicCredentialsVariableRadio.setVisible(false);
        this.basicCredentialsVariableField.setVisible(false);
        this.jsScriptLabel.setVisible(false);
        this.jsScriptField.setVisible(false);
        this.customClassNameLabel.setVisible(false);
        this.customClassNameField.setVisible(false);
        this.customPropertiesLabel.setVisible(false);
        this.customPropertiesPanel.setVisible(false);
        this.digestRealmLabel.setVisible(false);
        this.digestRealmField.setVisible(false);
        this.digestAlgorithmLabel.setVisible(false);
        this.digestAlgorithmMD5Radio.setVisible(false);
        this.digestAlgorithmMD5SessRadio.setVisible(false);
        this.digestAlgorithmBothRadio.setVisible(false);
        this.digestQOPLabel.setVisible(false);
        this.digestQOPAuthCheckBox.setVisible(false);
        this.digestQOPAuthIntCheckBox.setVisible(false);
        this.digestOpaqueLabel.setVisible(false);
        this.digestOpaqueField.setVisible(false);
        this.digestCredentialsLabel.setVisible(false);
        this.digestCredentialsPanel.setVisible(false);
        this.useDigestCredentialsTableRadio.setVisible(false);
        this.useDigestCredentialsVariableRadio.setVisible(false);
        this.digestCredentialsVariableField.setVisible(false);
        this.oauth2TokenLabel.setVisible(false);
        this.oauth2TokenLocationComboBox.setVisible(false);
        this.oauth2TokenField.setVisible(false);
        this.oauth2VerificationURLLabel.setVisible(false);
        this.oauth2VerificationURLField.setVisible(false);
        if (this.connectorPropertiesPanel != null && this.connectorPropertiesPanel.getLayoutComponents() != null) {
            componentArray = this.connectorPropertiesPanel.getLayoutComponents();
            n2 = componentArray.length;
            for (n = 0; n < n2; ++n) {
                for (Component column : row = componentArray[n]) {
                    column.setVisible(false);
                }
            }
        }
        if (authType == HttpAuthConnectorPluginProperties.AuthType.BASIC) {
            this.basicRealmLabel.setVisible(true);
            this.basicRealmField.setVisible(true);
            this.basicCredentialsLabel.setVisible(true);
            this.basicCredentialsPanel.setVisible(true);
            this.useBasicCredentialsTableRadio.setVisible(true);
            this.useBasicCredentialsVariableRadio.setVisible(true);
            this.basicCredentialsVariableField.setVisible(true);
        } else if (authType == HttpAuthConnectorPluginProperties.AuthType.DIGEST) {
            this.digestRealmLabel.setVisible(true);
            this.digestRealmField.setVisible(true);
            this.digestAlgorithmLabel.setVisible(true);
            this.digestAlgorithmMD5Radio.setVisible(true);
            this.digestAlgorithmMD5SessRadio.setVisible(true);
            this.digestAlgorithmBothRadio.setVisible(true);
            this.digestQOPLabel.setVisible(true);
            this.digestQOPAuthCheckBox.setVisible(true);
            this.digestQOPAuthIntCheckBox.setVisible(true);
            this.digestOpaqueLabel.setVisible(true);
            this.digestOpaqueField.setVisible(true);
            this.digestCredentialsLabel.setVisible(true);
            this.digestCredentialsPanel.setVisible(true);
            this.useDigestCredentialsTableRadio.setVisible(true);
            this.useDigestCredentialsVariableRadio.setVisible(true);
            this.digestCredentialsVariableField.setVisible(true);
        } else if (authType == HttpAuthConnectorPluginProperties.AuthType.JAVASCRIPT) {
            this.jsScriptLabel.setVisible(true);
            this.jsScriptField.setVisible(true);
        } else if (authType == HttpAuthConnectorPluginProperties.AuthType.CUSTOM) {
            this.customClassNameLabel.setVisible(true);
            this.customClassNameField.setVisible(true);
            this.customPropertiesLabel.setVisible(true);
            this.customPropertiesPanel.setVisible(true);
        } else if (authType == HttpAuthConnectorPluginProperties.AuthType.OAUTH2_VERIFICATION) {
            this.oauth2TokenLabel.setVisible(true);
            this.oauth2TokenLocationComboBox.setVisible(true);
            this.oauth2TokenField.setVisible(true);
            this.oauth2VerificationURLLabel.setVisible(true);
            this.oauth2VerificationURLField.setVisible(true);
            if (this.connectorPropertiesPanel != null && this.connectorPropertiesPanel.getLayoutComponents() != null) {
                componentArray = this.connectorPropertiesPanel.getLayoutComponents();
                n2 = componentArray.length;
                for (n = 0; n < n2; ++n) {
                    for (Component column : row = componentArray[n]) {
                        column.setVisible(true);
                    }
                }
            }
        }
        this.setProperties(this.connectorPanel.getDefaults(), (ConnectorPluginProperties)this.getDefaultProperties(authType));
        this.selectedAuthType = authType;
    }

    private int getSelectedRow(MirthTable table) {
        if (table.isEditing()) {
            return table.getEditingRow();
        }
        return table.getSelectedRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJSScriptField() {
        boolean equal = true;
        Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
        try {
            try {
                String decompiledSavedScript = context.decompileScript(context.compileString("function doScript() {" + this.jsScript + "}", UUID.randomUUID().toString(), 1, null), 1);
                String decompiledDefaultScript = context.decompileScript(context.compileString("function doScript() {" + new JavaScriptHttpAuthProperties().getScript() + "}", UUID.randomUUID().toString(), 1, null), 1);
                equal = StringUtils.equals((CharSequence)decompiledSavedScript, (CharSequence)decompiledDefaultScript);
            }
            catch (Exception e) {
                equal = false;
            }
        }
        finally {
            Context.exit();
        }
        if (equal) {
            this.jsScriptField.setText(SCRIPT_DEFAULT);
        } else {
            this.jsScriptField.setText(SCRIPT_SET);
        }
    }

    private void useBasicCredentialsVariableFieldsEnabled(boolean useVariable) {
        this.basicCredentialsVariableField.setEnabled(useVariable);
        this.basicCredentialsTable.setEnabled(!useVariable);
        this.basicCredentialsNewButton.setEnabled(!useVariable);
        this.basicCredentialsDeleteButton.setEnabled(!useVariable);
    }

    private void useDigestCredentialsVariableFieldsEnabled(boolean useVariable) {
        this.digestCredentialsVariableField.setEnabled(useVariable);
        this.digestCredentialsTable.setEnabled(!useVariable);
        this.digestCredentialsNewButton.setEnabled(!useVariable);
        this.digestCredentialsDeleteButton.setEnabled(!useVariable);
    }

    private class CredentialsTableCellEditor
    extends TextFieldCellEditor {
        private JTable table;
        private JButton deleteButton;

        public CredentialsTableCellEditor(JTable table) {
            this.table = table;
        }

        public void setDeleteButton(JButton deleteButton) {
            this.deleteButton = deleteButton;
        }

        @Override
        protected boolean valueChanged(String value) {
            this.deleteButton.setEnabled(true);
            for (int row = 0; row < this.table.getModel().getRowCount(); ++row) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)((String)this.table.getModel().getValueAt(row, 0)))) continue;
                return false;
            }
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            return true;
        }
    }

    private class PasswordCellRenderer
    extends JPasswordField
    implements TableCellRenderer {
        public PasswordCellRenderer() {
            this.setBorder(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setText((String)value);
            return this;
        }
    }
}

