/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.imageviewer;

import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.plugins.AttachmentViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.lang3.StringUtils;

public class ImageViewer
extends AttachmentViewer {
    private BufferedImage image;

    public ImageViewer(String name) {
        super(name);
    }

    @Override
    public boolean handleMultiple() {
        return false;
    }

    @Override
    public void viewAttachments(String channelId, Long messageId, String attachmentId) {
        JFrame frame = new JFrame("Image Viewer");
        try {
            Attachment attachment = this.parent.mirthClient.getAttachment(channelId, messageId, attachmentId);
            byte[] rawData = attachment.getContent();
            ByteArrayInputStream bis = new ByteArrayInputStream(rawData);
            this.image = ImageIO.read((InputStream)new Base64InputStream((InputStream)bis));
            if (this.image == null) {
                this.parent.alertError((Component)((Object)this.parent), "Unable to read image.");
                return;
            }
            JScrollPane pictureScrollPane = new JScrollPane(new JLabel(new ImageIcon(this.image)));
            pictureScrollPane.setHorizontalScrollBarPolicy(30);
            pictureScrollPane.setVerticalScrollBarPolicy(20);
            frame.add(pictureScrollPane);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    e.getWindow().dispose();
                }
            });
            frame.pack();
            int imageWidth = this.image.getWidth();
            int imageHeight = this.image.getHeight();
            if (imageWidth > 800 || imageHeight > 600) {
                int width = imageWidth;
                int height = imageHeight;
                if (imageWidth > 800) {
                    width = 800;
                }
                if (imageHeight > 600) {
                    height = 600;
                }
                Integer scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
                int verticalScrollBar = 0;
                int horizontalScrollBar = 0;
                if (width == 800) {
                    horizontalScrollBar = scrollBarWidth;
                }
                if (height == 600) {
                    verticalScrollBar = scrollBarWidth;
                }
                width = width + frame.getInsets().left + frame.getInsets().right + verticalScrollBar;
                height = height + frame.getInsets().top + frame.getInsets().bottom + horizontalScrollBar;
                frame.setSize(width, height);
            }
            Dimension dlgSize = frame.getSize();
            Dimension frmSize = this.parent.getSize();
            Point loc = this.parent.getLocation();
            if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
                frame.setLocationRelativeTo(null);
            } else {
                frame.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            }
            frame.setVisible(true);
        }
        catch (Exception e) {
            this.parent.alertThrowable((Component)((Object)this.parent), e);
        }
    }

    @Override
    public boolean isContentTypeViewable(String contentType) {
        return StringUtils.containsIgnoreCase((CharSequence)contentType, (CharSequence)"image");
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void reset() {
    }

    @Override
    public String getPluginPointName() {
        return "Image Viewer";
    }

    static {
        ImageIO.scanForPlugins();
    }
}

