/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.javascriptstep;

import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.editors.EditorPanel;
import com.mirth.connect.model.Step;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.plugins.javascriptstep.JavaScriptStep;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import net.miginfocom.swing.MigLayout;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptPanel
extends EditorPanel<Step> {
    private MirthRTextScrollPane scriptTextArea;

    public JavaScriptPanel() {
        this.initComponents();
        this.initLayout();
    }

    @Override
    public Step getDefaults() {
        return new JavaScriptStep();
    }

    @Override
    public Step getProperties() {
        JavaScriptStep props = new JavaScriptStep();
        props.setScript(this.scriptTextArea.getText().trim());
        return props;
    }

    @Override
    public void setProperties(Step properties) {
        JavaScriptStep props = (JavaScriptStep)properties;
        this.scriptTextArea.setText(props.getScript());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String checkProperties(Step properties, boolean highlight) {
        JavaScriptStep props = (JavaScriptStep)properties;
        try {
            Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
            context.compileString("function rhinoWrapper() {" + props.getScript() + "\n}", PlatformUI.MIRTH_FRAME.mirthClient.getGuid(), 1, null);
        }
        catch (EvaluatorException e) {
            String string = "Error on line " + e.lineNumber() + ": " + e.getMessage() + ".";
            return string;
        }
        catch (Exception e) {
            String string = "Unknown error occurred during validation.";
            return string;
        }
        finally {
            Context.exit();
        }
        return null;
    }

    @Override
    public void resetInvalidProperties() {
    }

    @Override
    public void setNameActionListener(ActionListener actionListener) {
    }

    public void setContextType(ContextType contextType) {
        this.scriptTextArea.setContextType(contextType);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.scriptTextArea = new MirthRTextScrollPane(null, true);
        this.scriptTextArea.setBorder(BorderFactory.createEtchedBorder());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
        this.add((Component)((Object)this.scriptTextArea), "grow, push");
    }
}

