/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.scriptfilestep;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.editors.EditorPanel;
import com.mirth.connect.model.Step;
import com.mirth.connect.plugins.scriptfilestep.ExternalScriptStep;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ExternalScriptPanel
extends EditorPanel<Step> {
    private JLabel infoLabel;
    private JLabel pathLabel;
    private JTextField pathField;

    public ExternalScriptPanel() {
        this.initComponents();
        this.initLayout();
    }

    @Override
    public Step getDefaults() {
        return new ExternalScriptStep();
    }

    @Override
    public Step getProperties() {
        ExternalScriptStep props = new ExternalScriptStep();
        props.setScriptPath(this.pathField.getText().trim());
        return props;
    }

    @Override
    public void setProperties(Step properties) {
        ExternalScriptStep props = (ExternalScriptStep)properties;
        this.pathField.setText(props.getScriptPath());
    }

    @Override
    public String checkProperties(Step properties, boolean highlight) {
        ExternalScriptStep props = (ExternalScriptStep)properties;
        Object errors = "";
        if (StringUtils.isBlank((CharSequence)props.getScriptPath())) {
            errors = (String)errors + "The script path cannot be blank.\n";
            if (highlight) {
                this.pathField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return errors;
    }

    @Override
    public void resetInvalidProperties() {
        this.pathField.setBackground(null);
    }

    @Override
    public void setNameActionListener(ActionListener actionListener) {
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.infoLabel = new JLabel("Enter the path of an external JavaScript file accessible from the BridgeLink server.");
        this.pathLabel = new JLabel("Script Path:");
        this.pathField = new JTextField();
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, gap 12 6"));
        this.add((Component)this.infoLabel, "sx");
        this.add(this.pathLabel);
        this.add((Component)this.pathField, "sx, growx, pushx");
    }
}

