/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.ArrayUtils;
import org.fife.ui.rsyntaxtextarea.EOLPreservingRSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class SyntaxViewUtil {
    public static void drawEOL(RSyntaxTextArea textArea, Graphics2D g, float x, float y) {
        if (textArea.getEOLMarkersVisible()) {
            g.setColor(textArea.getForegroundForTokenType(21));
            g.setFont(textArea.getFontForTokenType(21));
            if (textArea.getDocument() instanceof EOLPreservingRSyntaxDocument) {
                try {
                    int line = textArea.getLineOfOffset(textArea.viewToModel(new Point((int)x, (int)y)));
                    char[] eol = ((EOLPreservingRSyntaxDocument)((Object)textArea.getDocument())).getEOL(line);
                    if (ArrayUtils.isNotEmpty((char[])eol)) {
                        Object display = "";
                        block6: for (char c : eol) {
                            switch (c) {
                                case '\r': {
                                    display = (String)display + "\\r";
                                    continue block6;
                                }
                                case '\n': {
                                    display = (String)display + "\\n";
                                }
                            }
                        }
                        g.drawString((String)display, x, y);
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                g.drawString("\\n", x, y);
            }
        }
    }
}

