/*
 * Decompiled with CFR 0.152.
 */
package org.syntax.jedit.tokenmarker;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.swing.text.Segment;
import org.syntax.jedit.KeywordMap;
import org.syntax.jedit.tokenmarker.TokenMarker;

public class JSONTokenMarker
extends TokenMarker {
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public JSONTokenMarker() {
        this.getKeywords();
    }

    public void getKeywords() {
        if (this.keywords == null) {
            this.keywords = new KeywordMap(false);
            this.keywords.add("null", (byte)5);
            this.keywords.add("true", (byte)5);
            this.keywords.add("false", (byte)5);
        }
    }

    @Override
    protected byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        ArrayDeque lastInfo = new ArrayDeque();
        if (lineIndex != 0 && this.lineInfo[lineIndex - 1].obj != null) {
            lastInfo = (ArrayDeque)this.lineInfo[lineIndex - 1].obj;
        }
        ArrayDeque<JSONTokenState> states = new ArrayDeque<JSONTokenState>(lastInfo);
        block17: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
            } else if (token != 6 && token != 8 && Character.isDigit(c)) {
                token = (byte)11;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '\"': {
                            JSONTokenState peek = (JSONTokenState)((Object)states.peek());
                            if (peek != null) {
                                token = ((JSONTokenState)((Object)states.peek())).equals((Object)JSONTokenState.OBJECT_KEY) ? (byte)6 : (byte)8;
                            }
                            this.addToken(i1 - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i1;
                            continue block17;
                        }
                        case '-': {
                            token = (byte)11;
                            this.addToken(i1 - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i1;
                            continue block17;
                        }
                    }
                    backslash = false;
                    switch (c) {
                        case '{': {
                            this.resetState(states);
                            states.push(JSONTokenState.OBJECT_KEY);
                            break;
                        }
                        case '[': {
                            this.resetState(states);
                            states.push(JSONTokenState.ARRAY);
                            break;
                        }
                        case '}': {
                            if (states.peek() == null) break;
                            states.pop();
                            break;
                        }
                        case ']': {
                            if (states.peek() != null) {
                                states.pop();
                            }
                            this.resetState(states);
                        }
                    }
                    if (Character.isLetter(c)) {
                        this.addToken(i - this.lastOffset, token);
                        this.lastOffset = this.lastKeyword = i;
                        token = 1;
                        continue block17;
                    }
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    continue block17;
                }
                case 6: {
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    if (c != '\"') continue block17;
                    if (backslash) {
                        backslash = false;
                        continue block17;
                    }
                    if (states.peek() != null) {
                        states.pop();
                    }
                    states.push(JSONTokenState.OBJECT_VALUE);
                    token = 0;
                    continue block17;
                }
                case 8: {
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    if (c != '\"') continue block17;
                    if (backslash) {
                        backslash = false;
                        continue block17;
                    }
                    this.resetState(states);
                    token = 0;
                    continue block17;
                }
                case 11: {
                    if (!Character.isDigit(c) && c != '.' && c != 'E' && c != '+') {
                        token = 0;
                        this.resetState(states);
                    }
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                    continue block17;
                }
                case 1: {
                    if (Character.isLetter(c)) continue block17;
                    this.resetState(states);
                    if ((c == '}' || c == ']') && states.peek() != null) {
                        states.pop();
                    }
                    if (this.doKeyword(line, i, c)) continue block17;
                    token = 0;
                    this.addToken(i1 - this.lastOffset, token);
                    this.lastOffset = this.lastKeyword = i1;
                }
            }
        }
        this.lineInfo[lineIndex].obj = states;
        if (token == 1) {
            this.doKeyword(line, length, '\u0000');
            this.addToken(length - this.lastOffset, (byte)0);
        }
        return token;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }

    private void resetState(Deque<JSONTokenState> states) {
        JSONTokenState state = states.peek();
        if (state != null && state.equals((Object)JSONTokenState.OBJECT_VALUE)) {
            states.pop();
            states.push(JSONTokenState.OBJECT_KEY);
        }
    }

    private static enum JSONTokenState {
        OBJECT_KEY,
        OBJECT_VALUE,
        ARRAY;

    }
}

