/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.mapper;

import com.mirth.connect.model.FilterTransformerIterable;
import com.mirth.connect.model.IteratorProperties;
import com.mirth.connect.model.Step;
import com.mirth.connect.util.JavaScriptSharedUtil;
import com.mirth.connect.util.ScriptBuilderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MapperStep
extends Step
implements FilterTransformerIterable<Step> {
    public static final String PLUGIN_POINT = "Mapper";
    private String variable;
    private String mapping;
    private String defaultValue;
    private List<Pair<String, String>> replacements;
    private Scope scope;

    public MapperStep() {
        this.variable = "";
        this.mapping = "";
        this.defaultValue = "";
        this.replacements = new ArrayList<Pair<String, String>>();
        this.scope = Scope.CHANNEL;
    }

    public MapperStep(MapperStep props) {
        super((Step)props);
        this.variable = props.getVariable();
        this.mapping = props.getMapping();
        this.defaultValue = props.getDefaultValue();
        if (props.getReplacements() != null) {
            ArrayList<Pair<String, String>> replacements = new ArrayList<Pair<String, String>>();
            for (Pair<String, String> pair : props.getReplacements()) {
                replacements.add((Pair<String, String>)new ImmutablePair((Object)((String)pair.getLeft()), (Object)((String)pair.getRight())));
            }
            this.replacements = replacements;
        }
        this.scope = props.getScope();
    }

    public Collection<String> getResponseVariables() {
        List<String> varCollection = null;
        if (this.scope.equals((Object)Scope.RESPONSE)) {
            varCollection = Collections.singletonList(this.variable);
        }
        return varCollection;
    }

    public String getScript(boolean loadFiles) {
        String regexArray = this.buildRegexArray();
        StringBuilder script = new StringBuilder();
        script.append("var mapping;\n\n");
        script.append("try {\n\tmapping = " + (String)StringUtils.defaultIfBlank((CharSequence)this.mapping, (CharSequence)"''") + "; \n} ");
        script.append("catch (e) {\n\tmapping = '';\n}\n\n");
        if (this.scope != null) {
            script.append(this.scope.map + ".put(");
        } else {
            script.append(Scope.CHANNEL.map + ".put(");
        }
        script.append("'" + this.variable + "', ");
        String tempDefault = this.defaultValue;
        if (tempDefault.length() == 0) {
            tempDefault = "''";
        }
        script.append("validate( mapping , " + tempDefault + ", " + regexArray + "));");
        return script.toString();
    }

    public String getPreScript(boolean loadFiles, LinkedList<IteratorProperties<Step>> ancestors) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        script.append("var _").append(JavaScriptSharedUtil.convertIdentifier((String)this.variable)).append(" = Lists.list();");
        return script.toString();
    }

    public String getIterationScript(boolean loadFiles, LinkedList<IteratorProperties<Step>> ancestors) throws ScriptBuilderException {
        String regexArray = this.buildRegexArray();
        StringBuilder script = new StringBuilder();
        script.append("var mapping;\n\n");
        script.append("try {\n\tmapping = ").append((String)StringUtils.defaultIfBlank((CharSequence)this.mapping, (CharSequence)"''")).append("; \n} ");
        script.append("catch (e) {\n\tmapping = '';\n}\n\n");
        String tempDefault = this.defaultValue;
        if (tempDefault.length() == 0) {
            tempDefault = "''";
        }
        script.append('_').append(JavaScriptSharedUtil.convertIdentifier((String)this.variable)).append(".add(validate( mapping , ").append(tempDefault).append(", ").append(regexArray).append("));");
        return script.toString();
    }

    public String getPostScript(boolean loadFiles, LinkedList<IteratorProperties<Step>> ancestors) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        script.append(this.scope != null ? this.scope.map : Scope.CHANNEL.map).append(".put('").append(this.variable).append("', _").append(JavaScriptSharedUtil.convertIdentifier((String)this.variable)).append(".toArray());");
        return script.toString();
    }

    private String buildRegexArray() {
        StringBuilder regexArray = new StringBuilder();
        regexArray.append("new Array(");
        if (this.replacements != null && this.replacements.size() > 0) {
            for (int i = 0; i < this.replacements.size(); ++i) {
                regexArray.append("new Array(" + (String)this.replacements.get(i).getLeft() + ", " + (String)this.replacements.get(i).getRight() + ")");
                if (i + 1 == this.replacements.size()) {
                    regexArray.append(")");
                    continue;
                }
                regexArray.append(",");
            }
        } else {
            regexArray.append(")");
        }
        return regexArray.toString();
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<Pair<String, String>> getReplacements() {
        return this.replacements;
    }

    public void setReplacements(List<Pair<String, String>> replacements) {
        this.replacements = replacements;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getType() {
        return PLUGIN_POINT;
    }

    public Step clone() {
        return new MapperStep(this);
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        if (this.replacements != null) {
            purgedProperties.put("replacementsCount", this.replacements.size());
        }
        purgedProperties.put("scope", this.scope);
        return purgedProperties;
    }

    public static enum Scope {
        CONNECTOR("Connector Map", "connectorMap"),
        CHANNEL("Channel Map", "channelMap"),
        GLOBAL_CHANNEL("Global Channel Map", "globalChannelMap"),
        GLOBAL("Global Map", "globalMap"),
        RESPONSE("Response Map", "responseMap");

        public String label;
        public String map;

        private Scope(String label, String map) {
            this.label = label;
            this.map = map;
        }

        public String toString() {
            return this.label;
        }
    }
}

