/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.segment.ADJ;
import ca.uhn.hl7v2.model.v27.segment.PSL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E10_PRODUCT_SERVICE_LINE_INFO
extends AbstractGroup {
    public EHC_E10_PRODUCT_SERVICE_LINE_INFO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSL.class, true, false, false);
            this.add(ADJ.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E10_PRODUCT_SERVICE_LINE_INFO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public PSL getPSL() {
        PSL retVal = (PSL)this.getTyped("PSL", PSL.class);
        return retVal;
    }

    public ADJ getADJ() {
        ADJ retVal = (ADJ)this.getTyped("ADJ", ADJ.class);
        return retVal;
    }

    public ADJ getADJ(int rep) {
        ADJ retVal = (ADJ)this.getTyped("ADJ", rep, ADJ.class);
        return retVal;
    }

    public int getADJReps() {
        return this.getReps("ADJ");
    }

    public List<ADJ> getADJAll() throws HL7Exception {
        return this.getAllAsList("ADJ", ADJ.class);
    }

    public void insertADJ(ADJ structure, int rep) throws HL7Exception {
        super.insertRepetition("ADJ", (Structure)structure, rep);
    }

    public ADJ insertADJ(int rep) throws HL7Exception {
        return (ADJ)super.insertRepetition("ADJ", rep);
    }

    public ADJ removeADJ(int rep) throws HL7Exception {
        return (ADJ)super.removeRepetition("ADJ", rep);
    }
}

