/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.EHC_E24_PAYER_ADJUSTMENT;
import ca.uhn.hl7v2.model.v27.segment.AUT;
import ca.uhn.hl7v2.model.v27.segment.PSL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E24_PSL_ITEM_INFO
extends AbstractGroup {
    public EHC_E24_PSL_ITEM_INFO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSL.class, true, false, true);
            this.add(AUT.class, false, false, true);
            this.add(EHC_E24_PAYER_ADJUSTMENT.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E24_PSL_ITEM_INFO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public PSL getPSL() {
        PSL retVal = (PSL)this.getTyped("PSL", PSL.class);
        return retVal;
    }

    public AUT getAUT() {
        AUT retVal = (AUT)this.getTyped("AUT", AUT.class);
        return retVal;
    }

    public EHC_E24_PAYER_ADJUSTMENT getPAYER_ADJUSTMENT() {
        EHC_E24_PAYER_ADJUSTMENT retVal = (EHC_E24_PAYER_ADJUSTMENT)this.getTyped("PAYER_ADJUSTMENT", EHC_E24_PAYER_ADJUSTMENT.class);
        return retVal;
    }

    public EHC_E24_PAYER_ADJUSTMENT getPAYER_ADJUSTMENT(int rep) {
        EHC_E24_PAYER_ADJUSTMENT retVal = (EHC_E24_PAYER_ADJUSTMENT)this.getTyped("PAYER_ADJUSTMENT", rep, EHC_E24_PAYER_ADJUSTMENT.class);
        return retVal;
    }

    public int getPAYER_ADJUSTMENTReps() {
        return this.getReps("PAYER_ADJUSTMENT");
    }

    public List<EHC_E24_PAYER_ADJUSTMENT> getPAYER_ADJUSTMENTAll() throws HL7Exception {
        return this.getAllAsList("PAYER_ADJUSTMENT", EHC_E24_PAYER_ADJUSTMENT.class);
    }

    public void insertPAYER_ADJUSTMENT(EHC_E24_PAYER_ADJUSTMENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PAYER_ADJUSTMENT", (Structure)structure, rep);
    }

    public EHC_E24_PAYER_ADJUSTMENT insertPAYER_ADJUSTMENT(int rep) throws HL7Exception {
        return (EHC_E24_PAYER_ADJUSTMENT)super.insertRepetition("PAYER_ADJUSTMENT", rep);
    }

    public EHC_E24_PAYER_ADJUSTMENT removePAYER_ADJUSTMENT(int rep) throws HL7Exception {
        return (EHC_E24_PAYER_ADJUSTMENT)super.removeRepetition("PAYER_ADJUSTMENT", rep);
    }
}

