/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.OUL_R24_CONTAINER;
import ca.uhn.hl7v2.model.v27.group.OUL_R24_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v27.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OUL_R24_SPECIMEN
extends AbstractGroup {
    public OUL_R24_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(OUL_R24_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(OUL_R24_CONTAINER.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OUL_R24_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public SPM getSPM() {
        SPM retVal = (SPM)this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OUL_R24_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        OUL_R24_SPECIMEN_OBSERVATION retVal = (OUL_R24_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", OUL_R24_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public OUL_R24_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        OUL_R24_SPECIMEN_OBSERVATION retVal = (OUL_R24_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", rep, OUL_R24_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<OUL_R24_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", OUL_R24_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(OUL_R24_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", (Structure)structure, rep);
    }

    public OUL_R24_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OUL_R24_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OUL_R24_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OUL_R24_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OUL_R24_CONTAINER getCONTAINER() {
        OUL_R24_CONTAINER retVal = (OUL_R24_CONTAINER)this.getTyped("CONTAINER", OUL_R24_CONTAINER.class);
        return retVal;
    }

    public OUL_R24_CONTAINER getCONTAINER(int rep) {
        OUL_R24_CONTAINER retVal = (OUL_R24_CONTAINER)this.getTyped("CONTAINER", rep, OUL_R24_CONTAINER.class);
        return retVal;
    }

    public int getCONTAINERReps() {
        return this.getReps("CONTAINER");
    }

    public List<OUL_R24_CONTAINER> getCONTAINERAll() throws HL7Exception {
        return this.getAllAsList("CONTAINER", OUL_R24_CONTAINER.class);
    }

    public void insertCONTAINER(OUL_R24_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("CONTAINER", (Structure)structure, rep);
    }

    public OUL_R24_CONTAINER insertCONTAINER(int rep) throws HL7Exception {
        return (OUL_R24_CONTAINER)super.insertRepetition("CONTAINER", rep);
    }

    public OUL_R24_CONTAINER removeCONTAINER(int rep) throws HL7Exception {
        return (OUL_R24_CONTAINER)super.removeRepetition("CONTAINER", rep);
    }
}

