/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.RAS_O17_ORDER;
import ca.uhn.hl7v2.model.v27.group.RAS_O17_PATIENT;
import ca.uhn.hl7v2.model.v27.segment.MSH;
import ca.uhn.hl7v2.model.v27.segment.NTE;
import ca.uhn.hl7v2.model.v27.segment.SFT;
import ca.uhn.hl7v2.model.v27.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RAS_O17
extends AbstractMessage {
    public RAS_O17() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RAS_O17(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(NTE.class, false, true);
            this.add(RAS_O17_PATIENT.class, false, false);
            this.add(RAS_O17_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RAS_O17 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RAS_O17_PATIENT getPATIENT() {
        return (RAS_O17_PATIENT)this.getTyped("PATIENT", RAS_O17_PATIENT.class);
    }

    public RAS_O17_ORDER getORDER() {
        return (RAS_O17_ORDER)this.getTyped("ORDER", RAS_O17_ORDER.class);
    }

    public RAS_O17_ORDER getORDER(int rep) {
        return (RAS_O17_ORDER)this.getTyped("ORDER", rep, RAS_O17_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<RAS_O17_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RAS_O17_ORDER.class);
    }

    public void insertORDER(RAS_O17_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public RAS_O17_ORDER insertORDER(int rep) throws HL7Exception {
        return (RAS_O17_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RAS_O17_ORDER removeORDER(int rep) throws HL7Exception {
        return (RAS_O17_ORDER)super.removeRepetition("ORDER", rep);
    }
}

