/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM3
extends AbstractSegment {
    public OM3(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Preferred Coding System");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Valid Coded \"Answers\"");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Normal Text/Codes for Categorical Observations");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Abnormal Text/Codes for Categorical Observations");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Critical Text/Codes for Categorical Observations");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(125)}, "Value Type");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM3 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm31_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getPreferredCodingSystem() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getOm32_PreferredCodingSystem() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE[] getValidCodedAnswers() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getOm33_ValidCodedAnswers() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public int getValidCodedAnswersReps() {
        return this.getReps(3);
    }

    public CWE getValidCodedAnswers(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getOm33_ValidCodedAnswers(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOm33_ValidCodedAnswersReps() {
        return this.getReps(3);
    }

    public CWE insertValidCodedAnswers(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertOm33_ValidCodedAnswers(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removeValidCodedAnswers(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removeOm33_ValidCodedAnswers(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE[] getNormalTextCodesForCategoricalObservations() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getOm34_NormalTextCodesForCategoricalObservations() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public int getNormalTextCodesForCategoricalObservationsReps() {
        return this.getReps(4);
    }

    public CWE getNormalTextCodesForCategoricalObservations(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public CWE getOm34_NormalTextCodesForCategoricalObservations(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getOm34_NormalTextCodesForCategoricalObservationsReps() {
        return this.getReps(4);
    }

    public CWE insertNormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE insertOm34_NormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE removeNormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE removeOm34_NormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE[] getAbnormalTextCodesForCategoricalObservations() {
        CWE[] retVal = (CWE[])this.getTypedField(5, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getOm35_AbnormalTextCodesForCategoricalObservations() {
        CWE[] retVal = (CWE[])this.getTypedField(5, (Type[])new CWE[0]);
        return retVal;
    }

    public int getAbnormalTextCodesForCategoricalObservationsReps() {
        return this.getReps(5);
    }

    public CWE getAbnormalTextCodesForCategoricalObservations(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public CWE getOm35_AbnormalTextCodesForCategoricalObservations(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getOm35_AbnormalTextCodesForCategoricalObservationsReps() {
        return this.getReps(5);
    }

    public CWE insertAbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE insertOm35_AbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE removeAbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public CWE removeOm35_AbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public CWE[] getCriticalTextCodesForCategoricalObservations() {
        CWE[] retVal = (CWE[])this.getTypedField(6, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getOm36_CriticalTextCodesForCategoricalObservations() {
        CWE[] retVal = (CWE[])this.getTypedField(6, (Type[])new CWE[0]);
        return retVal;
    }

    public int getCriticalTextCodesForCategoricalObservationsReps() {
        return this.getReps(6);
    }

    public CWE getCriticalTextCodesForCategoricalObservations(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public CWE getOm36_CriticalTextCodesForCategoricalObservations(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getOm36_CriticalTextCodesForCategoricalObservationsReps() {
        return this.getReps(6);
    }

    public CWE insertCriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE insertOm36_CriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE removeCriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE removeOm36_CriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public ID getValueType() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getOm37_ValueType() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(125));
            }
        }
        return null;
    }
}

