/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.EI;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.model.v27.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SHP
extends AbstractSegment {
    public SHP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Shipment ID");
            this.add(EI.class, false, 0, 0, new Object[]{this.getMessage()}, "Internal Shipment ID");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Shipment Status");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Shipment Status Date/Time");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Shipment Status Reason");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Shipment Priority");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Shipment Confidentiality");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Packages in Shipment");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Shipment Condition");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Shipment Handling Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Shipment Risk Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SHP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getShipmentID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getShp1_ShipmentID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI[] getInternalShipmentID() {
        EI[] retVal = (EI[])this.getTypedField(2, (Type[])new EI[0]);
        return retVal;
    }

    public EI[] getShp2_InternalShipmentID() {
        EI[] retVal = (EI[])this.getTypedField(2, (Type[])new EI[0]);
        return retVal;
    }

    public int getInternalShipmentIDReps() {
        return this.getReps(2);
    }

    public EI getInternalShipmentID(int rep) {
        EI retVal = (EI)this.getTypedField(2, rep);
        return retVal;
    }

    public EI getShp2_InternalShipmentID(int rep) {
        EI retVal = (EI)this.getTypedField(2, rep);
        return retVal;
    }

    public int getShp2_InternalShipmentIDReps() {
        return this.getReps(2);
    }

    public EI insertInternalShipmentID(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(2, rep);
    }

    public EI insertShp2_InternalShipmentID(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(2, rep);
    }

    public EI removeInternalShipmentID(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(2, rep);
    }

    public EI removeShp2_InternalShipmentID(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(2, rep);
    }

    public CWE getShipmentStatus() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getShp3_ShipmentStatus() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getShipmentStatusDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getShp4_ShipmentStatusDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public TX getShipmentStatusReason() {
        TX retVal = (TX)this.getTypedField(5, 0);
        return retVal;
    }

    public TX getShp5_ShipmentStatusReason() {
        TX retVal = (TX)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getShipmentPriority() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getShp6_ShipmentPriority() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE[] getShipmentConfidentiality() {
        CWE[] retVal = (CWE[])this.getTypedField(7, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getShp7_ShipmentConfidentiality() {
        CWE[] retVal = (CWE[])this.getTypedField(7, (Type[])new CWE[0]);
        return retVal;
    }

    public int getShipmentConfidentialityReps() {
        return this.getReps(7);
    }

    public CWE getShipmentConfidentiality(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public CWE getShp7_ShipmentConfidentiality(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getShp7_ShipmentConfidentialityReps() {
        return this.getReps(7);
    }

    public CWE insertShipmentConfidentiality(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE insertShp7_ShipmentConfidentiality(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE removeShipmentConfidentiality(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public CWE removeShp7_ShipmentConfidentiality(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public NM getNumberOfPackagesInShipment() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getShp8_NumberOfPackagesInShipment() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE[] getShipmentCondition() {
        CWE[] retVal = (CWE[])this.getTypedField(9, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getShp9_ShipmentCondition() {
        CWE[] retVal = (CWE[])this.getTypedField(9, (Type[])new CWE[0]);
        return retVal;
    }

    public int getShipmentConditionReps() {
        return this.getReps(9);
    }

    public CWE getShipmentCondition(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public CWE getShp9_ShipmentCondition(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getShp9_ShipmentConditionReps() {
        return this.getReps(9);
    }

    public CWE insertShipmentCondition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE insertShp9_ShipmentCondition(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE removeShipmentCondition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE removeShp9_ShipmentCondition(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE[] getShipmentHandlingCode() {
        CWE[] retVal = (CWE[])this.getTypedField(10, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getShp10_ShipmentHandlingCode() {
        CWE[] retVal = (CWE[])this.getTypedField(10, (Type[])new CWE[0]);
        return retVal;
    }

    public int getShipmentHandlingCodeReps() {
        return this.getReps(10);
    }

    public CWE getShipmentHandlingCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(10, rep);
        return retVal;
    }

    public CWE getShp10_ShipmentHandlingCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(10, rep);
        return retVal;
    }

    public int getShp10_ShipmentHandlingCodeReps() {
        return this.getReps(10);
    }

    public CWE insertShipmentHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(10, rep);
    }

    public CWE insertShp10_ShipmentHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(10, rep);
    }

    public CWE removeShipmentHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(10, rep);
    }

    public CWE removeShp10_ShipmentHandlingCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(10, rep);
    }

    public CWE[] getShipmentRiskCode() {
        CWE[] retVal = (CWE[])this.getTypedField(11, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getShp11_ShipmentRiskCode() {
        CWE[] retVal = (CWE[])this.getTypedField(11, (Type[])new CWE[0]);
        return retVal;
    }

    public int getShipmentRiskCodeReps() {
        return this.getReps(11);
    }

    public CWE getShipmentRiskCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public CWE getShp11_ShipmentRiskCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getShp11_ShipmentRiskCodeReps() {
        return this.getReps(11);
    }

    public CWE insertShipmentRiskCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE insertShp11_ShipmentRiskCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(11, rep);
    }

    public CWE removeShipmentRiskCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    public CWE removeShp11_ShipmentRiskCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(11, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new TX(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

