/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.MO;
import ca.uhn.hl7v2.model.v281.datatype.NM;

public class UVC
extends AbstractComposite {
    private Type[] data;

    public UVC(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[4];
        this.data[0] = new CWE(this.getMessage());
        this.data[1] = new MO(this.getMessage());
        this.data[2] = new NM(this.getMessage());
        this.data[3] = new CWE(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CWE getValueCode() {
        return (CWE)this.getTyped(0, CWE.class);
    }

    public CWE getUvc1_ValueCode() {
        return (CWE)this.getTyped(0, CWE.class);
    }

    public MO getValueAmount() {
        return (MO)this.getTyped(1, MO.class);
    }

    public MO getUvc2_ValueAmount() {
        return (MO)this.getTyped(1, MO.class);
    }

    public NM getNonMonetaryValueAmountQuantity() {
        return (NM)this.getTyped(2, NM.class);
    }

    public NM getUvc3_NonMonetaryValueAmountQuantity() {
        return (NM)this.getTyped(2, NM.class);
    }

    public CWE getNonMonetaryValueAmountUnits() {
        return (CWE)this.getTyped(3, CWE.class);
    }

    public CWE getUvc4_NonMonetaryValueAmountUnits() {
        return (CWE)this.getTyped(3, CWE.class);
    }
}

