/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.SRM_S01_OBXPRT;
import ca.uhn.hl7v2.model.v281.segment.DG1;
import ca.uhn.hl7v2.model.v281.segment.PID;
import ca.uhn.hl7v2.model.v281.segment.PV1;
import ca.uhn.hl7v2.model.v281.segment.PV2;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SRM_S01_PATIENT
extends AbstractGroup {
    public SRM_S01_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PV1.class, false, false, false);
            this.add(PV2.class, false, false, false);
            this.add(SRM_S01_OBXPRT.class, false, true, false);
            this.add(DG1.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SRM_S01_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public PID getPID() {
        PID retVal = (PID)this.getTyped("PID", PID.class);
        return retVal;
    }

    public PV1 getPV1() {
        PV1 retVal = (PV1)this.getTyped("PV1", PV1.class);
        return retVal;
    }

    public PV2 getPV2() {
        PV2 retVal = (PV2)this.getTyped("PV2", PV2.class);
        return retVal;
    }

    public SRM_S01_OBXPRT getOBXPRT() {
        SRM_S01_OBXPRT retVal = (SRM_S01_OBXPRT)this.getTyped("OBXPRT", SRM_S01_OBXPRT.class);
        return retVal;
    }

    public SRM_S01_OBXPRT getOBXPRT(int rep) {
        SRM_S01_OBXPRT retVal = (SRM_S01_OBXPRT)this.getTyped("OBXPRT", rep, SRM_S01_OBXPRT.class);
        return retVal;
    }

    public int getOBXPRTReps() {
        return this.getReps("OBXPRT");
    }

    public List<SRM_S01_OBXPRT> getOBXPRTAll() throws HL7Exception {
        return this.getAllAsList("OBXPRT", SRM_S01_OBXPRT.class);
    }

    public void insertOBXPRT(SRM_S01_OBXPRT structure, int rep) throws HL7Exception {
        super.insertRepetition("OBXPRT", (Structure)structure, rep);
    }

    public SRM_S01_OBXPRT insertOBXPRT(int rep) throws HL7Exception {
        return (SRM_S01_OBXPRT)super.insertRepetition("OBXPRT", rep);
    }

    public SRM_S01_OBXPRT removeOBXPRT(int rep) throws HL7Exception {
        return (SRM_S01_OBXPRT)super.removeRepetition("OBXPRT", rep);
    }

    public DG1 getDG1() {
        DG1 retVal = (DG1)this.getTyped("DG1", DG1.class);
        return retVal;
    }

    public DG1 getDG1(int rep) {
        DG1 retVal = (DG1)this.getTyped("DG1", rep, DG1.class);
        return retVal;
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }
}

