/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CNS
extends AbstractSegment {
    public CNS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Starting Notification Reference Number");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Ending Notification Reference Number");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Starting Notification Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Ending Notification Date/Time");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Starting Notification Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Ending Notification Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CNS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getStartingNotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getCns1_StartingNotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getEndingNotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getCns2_EndingNotificationReferenceNumber() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getStartingNotificationDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getCns3_StartingNotificationDateTime() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getEndingNotificationDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public DTM getCns4_EndingNotificationDateTime() {
        DTM retVal = (DTM)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getStartingNotificationCode() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getCns5_StartingNotificationCode() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getEndingNotificationCode() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getCns6_EndingNotificationCode() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

