/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.PL;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LCH
extends AbstractSegment {
    public LCH(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, true, 1, 0, new Object[]{this.getMessage()}, "Primary Key Value - LCH");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Segment Unique Key");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Location Characteristic ID");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Location Characteristic Value - LCH");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating LCH - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PL getPrimaryKeyValueLCH() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getLch1_PrimaryKeyValueLCH() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getLch2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getSegmentUniqueKey() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getLch3_SegmentUniqueKey() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getLocationCharacteristicID() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getLch4_LocationCharacteristicID() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getLocationCharacteristicValueLCH() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getLch5_LocationCharacteristicValueLCH() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

