/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.connectors.jdbc.DatabaseDispatcherDelegate;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherException;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherProperties;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherQuery;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherScript;
import com.mirth.connect.connectors.jdbc.JdbcUtils;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.util.ArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseDispatcher
extends DestinationConnector {
    private DatabaseDispatcherDelegate delegate;
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private EventController eventController = ControllerFactory.getFactory().createEventController();

    public void onDeploy() throws ConnectorTaskException {
        this.delegate = ((DatabaseDispatcherProperties)this.getConnectorProperties()).isUseScript() ? new DatabaseDispatcherScript(this) : new DatabaseDispatcherQuery(this);
        this.delegate.deploy();
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
    }

    public void onUndeploy() throws ConnectorTaskException {
        this.delegate.undeploy();
    }

    public void onStart() throws ConnectorTaskException {
        this.delegate.start();
    }

    public void onStop() throws ConnectorTaskException {
        this.delegate.stop();
    }

    public void onHalt() throws ConnectorTaskException {
        this.delegate.halt();
    }

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage message) {
        DatabaseDispatcherProperties databaseDispatcherProperties = (DatabaseDispatcherProperties)connectorProperties;
        databaseDispatcherProperties.setUrl(this.replacer.replaceValues(databaseDispatcherProperties.getUrl(), message));
        databaseDispatcherProperties.setUsername(this.replacer.replaceValues(databaseDispatcherProperties.getUsername(), message));
        databaseDispatcherProperties.setPassword(this.replacer.replaceValues(databaseDispatcherProperties.getPassword(), message));
        ArrayList<String> paramNames = new ArrayList<String>();
        databaseDispatcherProperties.setQuery(JdbcUtils.extractParameters(databaseDispatcherProperties.getQuery(), paramNames));
        databaseDispatcherProperties.setParameters(JdbcUtils.getParameters(paramNames, this.getChannelId(), this.getChannel().getName(), message, null, this.getAttachmentHandlerProvider(), databaseDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(ConnectorProperties connectorProperties, ConnectorMessage message) throws InterruptedException {
        DatabaseDispatcherProperties databaseDispatcherProperties = (DatabaseDispatcherProperties)connectorProperties;
        String info = "URL: " + databaseDispatcherProperties.getUrl();
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.READING, info));
        try {
            Response response = this.delegate.send(databaseDispatcherProperties, message);
            response.setValidate(databaseDispatcherProperties.getDestinationConnectorProperties().isValidateResponse());
            Response response2 = response;
            return response2;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (DatabaseDispatcherException e) {
            String logMessage = "An error occurred in channel \"" + ChannelController.getInstance().getDeployedChannelById(this.getChannelId()).getName() + "\": " + e.getMessage();
            if (this.isQueueEnabled()) {
                this.logger.warn(logMessage, ExceptionUtils.getRootCause((Throwable)e));
            } else {
                this.logger.error(logMessage, ExceptionUtils.getRootCause((Throwable)e));
            }
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(message.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), e.getMessage(), (Throwable)e));
            Response response = new Response(Status.QUEUED, null, ErrorMessageBuilder.buildErrorResponse((String)"Error writing to database.", (Throwable)e), ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)e.getMessage(), (Throwable)e));
            return response;
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
        }
    }
}

