/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.connectors.jdbc.DatabaseReceiver;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverDelegate;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverException;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverProperties;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class DatabaseReceiverScript
implements DatabaseReceiverDelegate {
    private DatabaseReceiver connector;
    private String selectScriptId;
    private String updateScriptId;
    private DatabaseReceiverProperties connectorProperties;
    private final TemplateValueReplacer replacer = new TemplateValueReplacer();
    private Logger scriptLogger = LogManager.getLogger((String)"db-connector");
    private Logger logger = LogManager.getLogger(this.getClass());
    private ContextFactoryController contextFactoryController = this.getContextFactoryController();
    private String contextFactoryId;
    private List<String> contextFactoryIdList = new ArrayList<String>();
    private MirthMain debugger;
    private Boolean debug;
    private Boolean update = false;
    private boolean ignoreBreakpoints = false;
    private MirthScopeProvider scopeProvider = new MirthScopeProvider();

    public DatabaseReceiverScript(DatabaseReceiver connector) {
        this.connector = connector;
    }

    @Override
    public void deploy() throws ConnectorTaskException {
        MirthContextFactory contextFactory;
        Channel channel = this.connector.getChannel();
        DebugOptions debugOptions = channel.getDebugOptions();
        this.debug = debugOptions != null && debugOptions.isSourceConnectorScripts();
        this.connectorProperties = (DatabaseReceiverProperties)this.connector.getConnectorProperties();
        this.selectScriptId = ScriptController.getScriptId((String)"Database_Reader_Select", (String)this.connector.getChannelId());
        try {
            if (this.debug.booleanValue()) {
                contextFactory = this.contextFactoryController.getDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.selectScriptId);
                contextFactory.setContextType(ContextType.SOURCE_RECEIVER);
                contextFactory.setScriptText(this.connectorProperties.getSelect());
                contextFactory.setDebugType(Boolean.valueOf(true));
                this.debugger = this.getDebugger(channel, contextFactory);
            } else {
                contextFactory = this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
            }
            this.contextFactoryId = contextFactory.getId();
            this.contextFactoryIdList.add(this.contextFactoryId);
            this.compileAndAddScript(this.connector.getChannelId(), contextFactory, this.selectScriptId, this.connectorProperties.getSelect(), ContextType.SOURCE_RECEIVER);
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Error compiling select script " + this.selectScriptId + ".", (Throwable)e);
        }
        if (this.connectorProperties.getUpdateMode() != 1) {
            this.updateScriptId = ScriptController.getScriptId((String)"Database_Reader_Update", (String)this.connector.getChannelId());
            try {
                this.compileAndAddScript(this.connector.getChannelId(), contextFactory, this.updateScriptId, this.connectorProperties.getUpdate(), ContextType.SOURCE_RECEIVER);
            }
            catch (Exception e) {
                throw new ConnectorTaskException("Error compiling update script " + this.updateScriptId + ".", (Throwable)e);
            }
        }
    }

    @Override
    public void start() throws ConnectorTaskException {
        this.ignoreBreakpoints = false;
        if (this.debug.booleanValue() && this.debugger != null) {
            this.debugger.enableDebugging();
        }
    }

    @Override
    public void stop() throws ConnectorTaskException {
        if (this.debug.booleanValue() && this.debugger != null) {
            this.debugger.finishScriptExecution();
        }
    }

    @Override
    public void undeploy() {
        if (this.selectScriptId != null) {
            this.removeScriptFromCache(this.selectScriptId);
        }
        if (this.updateScriptId != null) {
            this.removeScriptFromCache(this.updateScriptId);
        }
        if (this.debug.booleanValue() && this.debugger != null) {
            this.debugger.detach();
            this.contextFactoryController.removeDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.selectScriptId);
            this.contextFactoryController.removeDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.updateScriptId);
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    protected ContextFactoryController getContextFactoryController() {
        return ControllerFactory.getFactory().createContextFactoryController();
    }

    protected MirthMain getDebugger(Channel channel, MirthContextFactory contextFactory) {
        return JavaScriptUtil.getDebugger((MirthContextFactory)contextFactory, (MirthScopeProvider)this.scopeProvider, (Channel)channel, (String)this.selectScriptId);
    }

    protected void compileAndAddScript(String channelId, MirthContextFactory contextFactory, String scriptId, String selectOrUpdate, ContextType contextType) throws Exception {
        JavaScriptUtil.compileAndAddScript((String)channelId, (MirthContextFactory)contextFactory, (String)scriptId, (String)selectOrUpdate, (ContextType)contextType, null, null);
    }

    protected void removeScriptFromCache(String scriptId) {
        JavaScriptUtil.removeScriptFromCache((String)scriptId);
    }

    @Override
    public Object poll() throws DatabaseReceiverException, InterruptedException {
        Object finalResult = null;
        int attempts = 0;
        String channelId = this.connector.getChannelId();
        String channelName = this.connector.getChannel().getName();
        int maxRetryCount = NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getRetryCount(), channelId, channelName), (int)0);
        int retryInterval = NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getRetryInterval(), channelId, channelName), (int)0);
        boolean done = false;
        while (!done && !this.connector.isTerminated()) {
            try {
                this.update = false;
                Object result = JavaScriptUtil.execute((JavaScriptTask)new SelectTask(this.getContextFactory()));
                if (result instanceof NativeJavaObject) {
                    Object unwrappedResult = ((NativeJavaObject)result).unwrap();
                    if (unwrappedResult instanceof ResultSet) {
                        finalResult = (ResultSet)unwrappedResult;
                    } else if (unwrappedResult instanceof List) {
                        finalResult = (List)unwrappedResult;
                    } else {
                        throw new DatabaseReceiverException("Unrecognized value returned from script in channel \"" + ChannelController.getInstance().getDeployedChannelById(this.connector.getChannelId()).getName() + "\", expected ResultSet or List<Map<String, Object>>: " + unwrappedResult.toString());
                    }
                    done = true;
                    continue;
                }
                throw new DatabaseReceiverException("Unrecognized value returned from script in channel \"" + ChannelController.getInstance().getDeployedChannelById(this.connector.getChannelId()).getName() + "\", expected ResultSet or List<Map<String, Object>>: " + result.toString());
            }
            catch (Exception e) {
                if (attempts++ < maxRetryCount && !this.connector.isTerminated()) {
                    this.logger.error("An error occurred while polling for messages, retrying after " + retryInterval + " ms...", (Throwable)e);
                    Thread.sleep(retryInterval);
                    continue;
                }
                throw new DatabaseReceiverException("Error executing script " + this.selectScriptId + ".", e.getCause());
            }
        }
        return finalResult;
    }

    @Override
    public void runPostProcess(Map<String, Object> resultMap, ConnectorMessage mergedConnectorMessage) throws DatabaseReceiverException, InterruptedException {
        if (this.connectorProperties.getUpdateMode() == 3) {
            try {
                this.update = true;
                JavaScriptUtil.execute((JavaScriptTask)new UpdateTask(this.getContextFactory(), resultMap, mergedConnectorMessage));
            }
            catch (Exception e) {
                throw new DatabaseReceiverException(e);
            }
        }
    }

    @Override
    public void runAggregatePostProcess(List<Map<String, Object>> resultsList, ConnectorMessage mergedConnectorMessage) throws DatabaseReceiverException, InterruptedException {
        try {
            this.update = true;
            JavaScriptUtil.execute((JavaScriptTask)new UpdateTask(this.getContextFactory(), resultsList, mergedConnectorMessage));
        }
        catch (Exception e) {
            throw new DatabaseReceiverException(e);
        }
    }

    @Override
    public void afterPoll() throws InterruptedException, DatabaseReceiverException {
        if (this.connectorProperties.getUpdateMode() == 2 && !this.connectorProperties.isAggregateResults()) {
            try {
                this.update = true;
                JavaScriptUtil.execute((JavaScriptTask)new UpdateTask(this.getContextFactory(), null, null, null));
            }
            catch (Exception e) {
                throw new DatabaseReceiverException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MirthContextFactory getContextFactory() throws Exception {
        MirthContextFactory contextFactory;
        MirthContextFactory mirthContextFactory = contextFactory = this.debug != false ? this.contextFactoryController.getDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.selectScriptId) : this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
        if (!this.contextFactoryIdList.contains(contextFactory.getId())) {
            DatabaseReceiverScript databaseReceiverScript = this;
            synchronized (databaseReceiverScript) {
                MirthContextFactory mirthContextFactory2 = contextFactory = this.debug != false ? this.contextFactoryController.getDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.selectScriptId) : this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
                if (!this.contextFactoryIdList.contains(contextFactory.getId())) {
                    JavaScriptUtil.recompileGeneratedScript((MirthContextFactory)contextFactory, (String)this.selectScriptId);
                    if (this.connectorProperties.getUpdateMode() != 1) {
                        JavaScriptUtil.recompileGeneratedScript((MirthContextFactory)contextFactory, (String)this.updateScriptId);
                    }
                    this.contextFactoryIdList.add(contextFactory.getId());
                }
            }
        }
        return contextFactory;
    }

    private class SelectTask
    extends JavaScriptTask<Object> {
        public SelectTask(MirthContextFactory contextFactory) {
            super(contextFactory, DatabaseReceiverScript.this.connector.getConnectorProperties().getName() + " Select", (SourceConnector)DatabaseReceiverScript.this.connector);
        }

        public Object doCall() throws Exception {
            try {
                Scriptable scope = JavaScriptScopeUtil.getMessageReceiverScope((ContextFactory)this.getContextFactory(), (Object)DatabaseReceiverScript.this.scriptLogger, (String)DatabaseReceiverScript.this.connector.getChannelId(), (String)DatabaseReceiverScript.this.connector.getChannel().getName());
                if (DatabaseReceiverScript.this.debug.booleanValue()) {
                    DatabaseReceiverScript.this.scopeProvider.setScope(scope);
                    if (DatabaseReceiverScript.this.debugger != null && !DatabaseReceiverScript.this.ignoreBreakpoints) {
                        DatabaseReceiverScript.this.debugger.doBreak();
                        if (!DatabaseReceiverScript.this.debugger.isVisible()) {
                            DatabaseReceiverScript.this.debugger.setVisible(true);
                        }
                    }
                }
                Object object = JavaScriptUtil.executeScript((JavaScriptTask)this, (String)DatabaseReceiverScript.this.selectScriptId, (Scriptable)scope, (String)DatabaseReceiverScript.this.connector.getChannelId(), (String)"Source");
                return object;
            }
            finally {
                Context.exit();
            }
        }
    }

    private class UpdateTask
    extends JavaScriptTask<Object> {
        private Map<String, Object> resultMap;
        private List<Map<String, Object>> resultsList;
        private ConnectorMessage mergedConnectorMessage;

        public UpdateTask(MirthContextFactory contextFactory, Map<String, Object> resultMap, ConnectorMessage mergedConnectorMessage) {
            this(contextFactory, resultMap, null, mergedConnectorMessage);
        }

        public UpdateTask(MirthContextFactory contextFactory, List<Map<String, Object>> resultsList, ConnectorMessage mergedConnectorMessage) {
            this(contextFactory, null, resultsList, mergedConnectorMessage);
        }

        public UpdateTask(MirthContextFactory contextFactory, Map<String, Object> resultMap, List<Map<String, Object>> resultsList, ConnectorMessage mergedConnectorMessage) {
            super(contextFactory, DatabaseReceiverScript.this.connector.getConnectorProperties().getName() + " Update", (SourceConnector)DatabaseReceiverScript.this.connector);
            this.resultMap = resultMap;
            this.resultsList = resultsList;
            this.mergedConnectorMessage = mergedConnectorMessage;
        }

        public Object doCall() throws Exception {
            try {
                Scriptable scope = null;
                scope = this.mergedConnectorMessage == null ? JavaScriptScopeUtil.getMessageReceiverScope((ContextFactory)this.getContextFactory(), (Object)DatabaseReceiverScript.this.scriptLogger, (String)DatabaseReceiverScript.this.connector.getChannelId(), (String)DatabaseReceiverScript.this.connector.getChannel().getName()) : JavaScriptScopeUtil.getMessageReceiverScope((ContextFactory)this.getContextFactory(), (Object)DatabaseReceiverScript.this.scriptLogger, (String)DatabaseReceiverScript.this.connector.getChannelId(), (ImmutableConnectorMessage)new ImmutableConnectorMessage(this.mergedConnectorMessage, true, DatabaseReceiverScript.this.connector.getDestinationIdMap()));
                if (this.resultMap != null) {
                    scope.put("resultMap", scope, Context.javaToJS(this.resultMap, (Scriptable)scope));
                }
                if (this.resultsList != null) {
                    scope.put("results", scope, Context.javaToJS(this.resultsList, (Scriptable)scope));
                }
                if (DatabaseReceiverScript.this.debug.booleanValue()) {
                    DatabaseReceiverScript.this.scopeProvider.setScope(scope);
                    if (DatabaseReceiverScript.this.debugger != null && !DatabaseReceiverScript.this.ignoreBreakpoints) {
                        DatabaseReceiverScript.this.debugger.doBreak();
                        if (!DatabaseReceiverScript.this.debugger.isVisible()) {
                            DatabaseReceiverScript.this.debugger.setVisible(true);
                        }
                    }
                }
                Object object = JavaScriptUtil.executeScript((JavaScriptTask)this, (String)DatabaseReceiverScript.this.updateScriptId, (Scriptable)scope, (String)DatabaseReceiverScript.this.connector.getChannelId(), (String)"Source");
                return object;
            }
            finally {
                Context.exit();
            }
        }
    }
}

