/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import org.apache.commons.ssl.SSLClient;
import org.apache.commons.ssl.TrustMaterial;

public class CRLSocket
extends SSLClient {
    private static final CRLSocket secureInstance;
    private static final CRLSocket plainInstance;

    private CRLSocket() throws GeneralSecurityException, IOException {
        if (TrustMaterial.JSSE_CACERTS != null) {
            this.setTrustMaterial(TrustMaterial.JSSE_CACERTS);
        } else {
            this.setTrustMaterial(TrustMaterial.CACERTS);
        }
        this.setConnectTimeout(5000);
        this.setSoTimeout(5000);
        this.setCheckCRL(false);
    }

    public static SocketFactory getDefault() {
        return CRLSocket.getSecureInstance();
    }

    public static CRLSocket getSecureInstance() {
        return secureInstance;
    }

    public static CRLSocket getPlainInstance() {
        return plainInstance;
    }

    public static void main(String[] args) throws Exception {
        String host = args[0];
        String port = args[1];
        String hello = "HEAD / HTTP/1.1\r\nHost:" + host + ":" + port + "\r\n\r\n";
        byte[] helloBytes = hello.getBytes("UTF-8");
        System.out.println("About to getInstance() ");
        CRLSocket sf = CRLSocket.getPlainInstance();
        long now = System.currentTimeMillis();
        System.out.println("About to create socket: [" + host + ":" + port + "]");
        Socket s = sf.createSocket(host, Integer.parseInt(port));
        long delay = System.currentTimeMillis() - now;
        System.out.println("Created socket! took " + delay + "ms ");
        OutputStream out = s.getOutputStream();
        out.write(helloBytes);
        out.flush();
        System.out.println("\n" + new String(helloBytes, "UTF-8"));
        InputStream in = s.getInputStream();
        int c = in.read();
        StringBuffer buf = new StringBuffer();
        System.out.println("Reading: ");
        System.out.println("================================================================================");
        while (c >= 0) {
            byte b = (byte)c;
            buf.append((char)b);
            System.out.print((char)b);
            if (-1 != buf.toString().indexOf("\r\n\r\n")) break;
            c = in.read();
        }
        in.close();
        out.close();
        s.close();
    }

    static {
        CRLSocket sf1 = null;
        CRLSocket sf2 = null;
        try {
            sf1 = new CRLSocket();
            sf2 = new CRLSocket();
            sf2.setIsSecure(false);
        }
        catch (Exception e) {
            System.out.println("could not create CRLSocket: " + e);
            e.printStackTrace();
        }
        finally {
            secureInstance = sf1;
            plainInstance = sf2;
        }
    }
}

