/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import org.apache.commons.ssl.SSLClient;
import org.apache.commons.ssl.TrustMaterial;

public class LDAPSocket
extends SSLClient {
    private static final LDAPSocket instance;

    private LDAPSocket() throws GeneralSecurityException, IOException {
        if (TrustMaterial.JSSE_CACERTS != null) {
            this.setTrustMaterial(TrustMaterial.JSSE_CACERTS);
        } else {
            this.setTrustMaterial(TrustMaterial.CACERTS);
        }
    }

    public static SocketFactory getDefault() {
        return LDAPSocket.getInstance();
    }

    public static LDAPSocket getInstance() {
        return instance;
    }

    static {
        LDAPSocket sf = null;
        try {
            sf = new LDAPSocket();
        }
        catch (Exception e) {
            System.out.println("could not create LDAPSocket: " + e);
            e.printStackTrace();
        }
        finally {
            instance = sf;
        }
    }
}

