/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.maintenance;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractScheduledTask {
    private static final Logger logger = LogManager.getLogger(AbstractScheduledTask.class);
    private final String taskName;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> future;
    private boolean enabled;
    private long intervalSec;
    private long initialDelaySec;

    protected AbstractScheduledTask(String string) {
        this.taskName = string;
    }

    protected abstract void runOnce() throws Exception;

    public synchronized void refresh(boolean bl, long l, long l2) {
        boolean bl2;
        if (bl && l <= 0L) {
            this.logWarn("Interval <= 0; disabling task.");
            bl = false;
        }
        boolean bl3 = bl2 = this.enabled == bl && this.intervalSec == l && this.initialDelaySec == l2 && this.isRunning();
        if (bl2) {
            this.logDebug("No config change; keeping current schedule.");
            return;
        }
        this.enabled = bl;
        this.intervalSec = l;
        this.initialDelaySec = Math.max(0L, l2);
        this.stopInternal();
        if (!bl) {
            this.logInfo("Disabled.");
            return;
        }
        this.executor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "Lookup-" + this.taskName);
            thread.setDaemon(true);
            return thread;
        });
        this.future = this.executor.scheduleAtFixedRate(this::safeRunOnce, this.initialDelaySec, this.intervalSec, TimeUnit.SECONDS);
        this.logInfo(String.format("Scheduled: interval=%ds, initialDelay=%ds", this.intervalSec, this.initialDelaySec));
    }

    public synchronized void stop() {
        this.stopInternal();
        this.logInfo("Stopped.");
    }

    public synchronized boolean isRunning() {
        return this.future != null && !this.future.isCancelled() && !this.future.isDone();
    }

    private void safeRunOnce() {
        try {
            this.runOnce();
        }
        catch (Throwable throwable) {
            this.logError("Task execution failed", throwable);
        }
    }

    private void stopInternal() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
            finally {
                this.executor = null;
            }
        }
    }

    protected void logDebug(String string) {
        logger.debug("[{}] {}", (Object)this.taskName, (Object)string);
    }

    protected void logInfo(String string) {
        logger.info("[{}] {}", (Object)this.taskName, (Object)string);
    }

    protected void logWarn(String string) {
        logger.warn("[{}] {}", (Object)this.taskName, (Object)string);
    }

    protected void logError(String string, Throwable throwable) {
        logger.error("[{}] {}", (Object)this.taskName, (Object)string, (Object)throwable);
    }
}

