/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.service;

import com.google.common.cache.CacheStats;
import com.mirth.connect.plugins.dynamiclookup.server.cache.LookupCacheManager;
import com.mirth.connect.plugins.dynamiclookup.server.dao.LookupAuditDao;
import com.mirth.connect.plugins.dynamiclookup.server.dao.LookupGroupDao;
import com.mirth.connect.plugins.dynamiclookup.server.dao.LookupStatisticsDao;
import com.mirth.connect.plugins.dynamiclookup.server.dao.LookupValueDao;
import com.mirth.connect.plugins.dynamiclookup.server.exception.DuplicateGroupNameException;
import com.mirth.connect.plugins.dynamiclookup.server.exception.GroupNotFoundException;
import com.mirth.connect.plugins.dynamiclookup.server.exception.ValueOperationException;
import com.mirth.connect.plugins.dynamiclookup.server.exception.ValueTableCreationException;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.CacheStatistics;
import com.mirth.connect.plugins.dynamiclookup.shared.model.HistoryFilterState;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupAudit;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupStatistics;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import com.mirth.connect.plugins.dynamiclookup.shared.util.TtlUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupService {
    private static LookupService instance = null;
    private LookupGroupDao groupDao;
    private LookupValueDao valueDao;
    private LookupAuditDao auditDao;
    private LookupStatisticsDao statisticsDao;
    private LookupCacheManager cacheManager;
    private final Logger logger = LogManager.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LookupService getInstance() {
        Class<LookupService> clazz = LookupService.class;
        synchronized (LookupService.class) {
            if (instance == null) {
                instance = new LookupService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public LookupService() {
    }

    public LookupService(LookupGroupDao lookupGroupDao, LookupValueDao lookupValueDao, LookupAuditDao lookupAuditDao, LookupStatisticsDao lookupStatisticsDao, LookupCacheManager lookupCacheManager) {
        this.groupDao = lookupGroupDao;
        this.valueDao = lookupValueDao;
        this.auditDao = lookupAuditDao;
        this.statisticsDao = lookupStatisticsDao;
        this.cacheManager = lookupCacheManager;
    }

    public void init(LookupGroupDao lookupGroupDao, LookupValueDao lookupValueDao, LookupAuditDao lookupAuditDao, LookupStatisticsDao lookupStatisticsDao, LookupCacheManager lookupCacheManager) {
        this.groupDao = lookupGroupDao;
        this.valueDao = lookupValueDao;
        this.auditDao = lookupAuditDao;
        this.statisticsDao = lookupStatisticsDao;
        this.cacheManager = lookupCacheManager;
    }

    public List<LookupGroup> getAllGroups() {
        return this.groupDao.getAllGroups();
    }

    public LookupGroup getGroupById(int n) {
        return this.groupDao.getGroupById(n);
    }

    public LookupGroup getGroupByName(String string) {
        return this.groupDao.getGroupByName(string);
    }

    public int createGroup(LookupGroup lookupGroup) {
        this.validateGroup(lookupGroup);
        if (this.groupDao.getGroupByName(lookupGroup.getName()) != null) {
            throw new DuplicateGroupNameException("Group name already exists: " + lookupGroup.getName());
        }
        if (lookupGroup.getCachePolicy() == null || lookupGroup.getCachePolicy().isEmpty()) {
            lookupGroup.setCachePolicy("LRU");
        }
        int n = this.groupDao.insertGroup(lookupGroup);
        lookupGroup.setId(n);
        try {
            String string = this.getTableNameForGroup(n);
            this.groupDao.createValueTable(string);
            this.statisticsDao.insertStatistics(n);
            this.cacheManager.createOrRebuildGroupCache(lookupGroup);
            this.logger.info("Created lookup group: {} (ID: {})", (Object)lookupGroup.getName(), (Object)n);
            return n;
        }
        catch (Exception exception) {
            try {
                this.groupDao.deleteGroup(n);
            }
            catch (Exception exception2) {
                this.logger.error("Failed to rollback group creation after table creation error", (Throwable)exception2);
            }
            throw new ValueTableCreationException("Failed to create value table for group: " + exception.getMessage(), exception);
        }
    }

    public void updateGroup(LookupGroup lookupGroup) {
        boolean bl;
        LookupGroup lookupGroup2;
        this.validateGroup(lookupGroup);
        LookupGroup lookupGroup3 = this.groupDao.getGroupById(lookupGroup.getId());
        if (lookupGroup3 == null) {
            throw new GroupNotFoundException("Group not found with ID: " + lookupGroup.getId());
        }
        if (!lookupGroup3.getName().equals(lookupGroup.getName()) && (lookupGroup2 = this.groupDao.getGroupByName(lookupGroup.getName())) != null && lookupGroup2.getId() != lookupGroup.getId()) {
            throw new DuplicateGroupNameException("Group name already exists: " + lookupGroup.getName());
        }
        this.groupDao.updateGroup(lookupGroup);
        boolean bl2 = lookupGroup3.getCacheSize() != lookupGroup.getCacheSize();
        boolean bl3 = bl = !lookupGroup3.getCachePolicy().equals(lookupGroup.getCachePolicy());
        if (bl2 || bl) {
            this.logger.info("Cache settings changed for group {} (ID: {}): size {} -> {}, policy {} -> {}", (Object)lookupGroup.getName(), (Object)lookupGroup.getId(), (Object)lookupGroup3.getCacheSize(), (Object)lookupGroup.getCacheSize(), (Object)lookupGroup3.getCachePolicy(), (Object)lookupGroup.getCachePolicy());
            this.cacheManager.createOrRebuildGroupCache(lookupGroup);
        }
        this.logger.info("Updated lookup group: {} (ID: {})", (Object)lookupGroup.getName(), (Object)lookupGroup.getId());
    }

    public void deleteGroup(int n) {
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        if (lookupGroup == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string = lookupGroup.getName();
        String string2 = this.getTableNameForGroup(n);
        this.groupDao.dropValueTable(string2);
        this.groupDao.deleteGroup(n);
        this.cacheManager.removeGroupCache(n);
        this.logger.info("Deleted lookup group: {} (ID: {})", (Object)string, (Object)n);
    }

    public int importGroup(LookupGroup lookupGroup, Map<String, String> map, boolean bl, String string) {
        try {
            String string2;
            int n;
            LookupGroup lookupGroup2 = this.groupDao.getGroupByName(lookupGroup.getName());
            if (lookupGroup2 != null) {
                if (!bl) {
                    throw new DuplicateGroupNameException("Group name already exists: " + lookupGroup.getName());
                }
                n = lookupGroup2.getId();
                lookupGroup.setId(n);
                this.updateGroup(lookupGroup);
                string2 = this.getTableNameForGroup(n);
                long l = this.valueDao.getValueCount(string2);
                this.valueDao.deleteAllValues(string2);
                this.recordAudit(n, string2, "*", "DELETE_ALL", l + " values", null, string);
                this.cacheManager.clearGroupCache(n);
            } else {
                n = this.createGroup(lookupGroup);
                lookupGroup.setId(n);
                string2 = this.getTableNameForGroup(n);
            }
            int n2 = this.valueDao.importValues(string2, map);
            this.recordAudit(n, string2, "*", "IMPORT", null, n2 + " values imported", string);
            this.logger.info("Imported {} values into group: {} (ID: {})", (Object)n2, (Object)lookupGroup.getName(), (Object)n);
            return n2;
        }
        catch (DuplicateGroupNameException duplicateGroupNameException) {
            throw duplicateGroupNameException;
        }
        catch (Exception exception) {
            this.logger.error("Failed to import lookup group: " + exception.getMessage(), (Throwable)exception);
            throw new ValueOperationException("Failed to import lookup group: " + exception.getMessage(), exception);
        }
    }

    public LookupValue getLookupValue(int n, String string) {
        this.validateKey(string);
        if (this.groupDao.getGroupById(n) == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string2 = this.getTableNameForGroup(n);
        return this.valueDao.getLookupValue(string2, string);
    }

    public String getValue(int n, String string) {
        return this.getValue(n, string, 0L);
    }

    public String getValue(int n, String string, long l) {
        String string2;
        LookupValue lookupValue;
        boolean bl;
        this.validateKey(string);
        if (this.groupDao.getGroupById(n) == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string3 = this.cacheManager.getValue(n, string, l);
        boolean bl2 = bl = string3 != null;
        if (!bl && (lookupValue = this.valueDao.getLookupValue(string2 = this.getTableNameForGroup(n), string)) != null) {
            string3 = lookupValue.getValueData();
            Date date = lookupValue.getUpdatedDate();
            if (string3 != null && date != null) {
                this.cacheManager.putValue(n, string, string3, date);
                if (!TtlUtils.isWithinTtlSeconds((Date)date, (long)l)) {
                    string3 = null;
                }
            }
        }
        try {
            this.statisticsDao.updateStatistics(n, bl);
        }
        catch (Exception exception) {
            this.logger.warn("Failed to update statistics: {}", (Object)exception.getMessage());
        }
        return string3;
    }

    public Map<String, String> getAllValues(int n) {
        if (this.groupDao.getGroupById(n) == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string = this.getTableNameForGroup(n);
        List<LookupValue> list = this.valueDao.getAllValues(string);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (LookupValue lookupValue : list) {
            linkedHashMap.put(lookupValue.getKeyValue(), lookupValue.getValueData());
        }
        return linkedHashMap;
    }

    public int searchLookupValuesCount(int n, String string) {
        if (this.groupDao.getGroupById(n) == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string2 = this.getTableNameForGroup(n);
        long l = this.valueDao.searchLookupValuesCount(string2, string);
        return Math.toIntExact(l);
    }

    public List<LookupValue> searchLookupValues(Integer n, Integer n2, Integer n3, String string) {
        if (this.groupDao.getGroupById(n) == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string2 = this.getTableNameForGroup(n);
        return this.valueDao.searchLookupValues(string2, n2, n3, string);
    }

    public Map<String, String> getMatchingValues(int n, String string) {
        if (this.groupDao.getGroupById(n) == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string2 = this.getTableNameForGroup(n);
        List<LookupValue> list = this.valueDao.getMatchingValues(string2, string);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (LookupValue lookupValue : list) {
            linkedHashMap.put(lookupValue.getKeyValue(), lookupValue.getValueData());
        }
        return linkedHashMap;
    }

    public Map<String, String> getBatchValues(int n, List<String> list) {
        return this.getBatchValues(n, list, 0L);
    }

    public Map<String, String> getBatchValues(int n, List<String> list, long l) {
        String string;
        if (this.groupDao.getGroupById(n) == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.getTableNameForGroup(n);
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : list) {
            string = this.cacheManager.getValue(n, string3, l);
            if (string != null) {
                hashMap.put(string3, string);
                ++n2;
                continue;
            }
            arrayList.add(string3);
        }
        if (!arrayList.isEmpty()) {
            for (String string3 : arrayList) {
                string = this.valueDao.getLookupValue(string2, string3);
                if (string == null) continue;
                String string4 = string.getValueData();
                Date date = string.getUpdatedDate();
                if (string4 == null || date == null) continue;
                this.cacheManager.putValue(n, string3, string4, date);
                if (TtlUtils.isWithinTtlSeconds((Date)date, (long)l)) {
                    hashMap.put(string3, string4);
                    continue;
                }
                this.logger.debug("DB value for key '{}' excluded due to TTL (updatedAt={}, ttlSeconds={})", (Object)string3, (Object)date, (Object)l);
            }
        }
        try {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                this.statisticsDao.updateStatistics(n, true);
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                this.statisticsDao.updateStatistics(n, false);
            }
        }
        catch (Exception exception) {
            this.logger.warn("Failed to update statistics: {}", (Object)exception.getMessage());
        }
        return hashMap;
    }

    public void setValue(int n, String string, String string2, String string3) {
        this.validateKey(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        if (lookupGroup == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string4 = this.getTableNameForGroup(n);
        String string5 = this.valueDao.getValue(string4, string);
        try {
            if (string5 == null) {
                this.valueDao.insertValue(string4, string, string2);
                this.recordAudit(n, string4, string, "CREATE", null, string2, string3);
                this.logger.debug("Created lookup value - Group: {}, Key: {}", (Object)lookupGroup.getName(), (Object)string);
            } else {
                this.valueDao.updateValue(string4, string, string2);
                this.recordAudit(n, string4, string, "UPDATE", string5, string2, string3);
                this.logger.debug("Updated lookup value - Group: {}, Key: {}", (Object)lookupGroup.getName(), (Object)string);
            }
            LookupValue lookupValue = this.valueDao.getLookupValue(string4, string);
            this.cacheManager.putValue(n, string, string2, lookupValue.getUpdatedDate());
        }
        catch (Exception exception) {
            throw new ValueOperationException("Failed to set value: " + exception.getMessage(), exception);
        }
    }

    public void deleteValue(int n, String string, String string2) {
        this.validateKey(string);
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        if (lookupGroup == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string3 = this.getTableNameForGroup(n);
        String string4 = this.valueDao.getValue(string3, string);
        if (string4 != null) {
            try {
                this.valueDao.deleteValue(string3, string);
                this.recordAudit(n, string3, string, "DELETE", string4, null, string2);
                this.cacheManager.removeValue(n, string);
                this.logger.debug("Deleted lookup value - Group: {}, Key: {}", (Object)lookupGroup.getName(), (Object)string);
            }
            catch (Exception exception) {
                throw new ValueOperationException("Failed to delete value: " + exception.getMessage(), exception);
            }
        } else {
            this.logger.debug("No value found to delete - Group: {}, Key: {}", (Object)lookupGroup.getName(), (Object)string);
        }
    }

    public void deleteAllValues(int n, String string) {
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        if (lookupGroup == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string2 = this.getTableNameForGroup(n);
        try {
            long l = this.valueDao.getValueCount(string2);
            this.valueDao.deleteAllValues(string2);
            this.recordAudit(n, string2, "*", "DELETE_ALL", l + " values", null, string);
            this.cacheManager.clearGroupCache(n);
            this.logger.info("Deleted all values from group: {} (ID: {}), count: {}", (Object)lookupGroup.getName(), (Object)n, (Object)l);
        }
        catch (Exception exception) {
            throw new ValueOperationException("Failed to delete all values: " + exception.getMessage(), exception);
        }
    }

    public int importValues(int n, Map<String, String> map, boolean bl, String string) {
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        if (lookupGroup == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        if (map == null || map.isEmpty()) {
            return 0;
        }
        String string2 = this.getTableNameForGroup(n);
        try {
            if (bl) {
                this.valueDao.deleteAllValues(string2);
                this.recordAudit(n, string2, "*", "CLEAR_ALL", "Before import", null, string);
            }
            int n2 = this.valueDao.importValues(string2, map);
            this.recordAudit(n, string2, "*", "IMPORT", null, n2 + " values imported", string);
            this.cacheManager.clearGroupCache(n);
            this.logger.info("Imported {} values into group: {} (ID: {})", (Object)n2, (Object)lookupGroup.getName(), (Object)n);
            return n2;
        }
        catch (Exception exception) {
            throw new ValueOperationException("Failed to import values: " + exception.getMessage(), exception);
        }
    }

    public boolean putIfAbsent(int n, String string, String string2, String string3) {
        this.validateKey(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        if (lookupGroup == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string4 = this.getTableNameForGroup(n);
        try {
            boolean bl = this.valueDao.putIfAbsent(string4, string, string2);
            if (bl) {
                this.recordAudit(n, string4, string, "CREATE", null, string2, string3);
                this.logger.debug("Created lookup value - Group: {}, Key: {}", (Object)lookupGroup.getName(), (Object)string);
                LookupValue lookupValue = this.valueDao.getLookupValue(string4, string);
                if (lookupValue != null) {
                    this.cacheManager.putValue(n, string, string2, lookupValue.getUpdatedDate());
                }
            }
            return bl;
        }
        catch (Exception exception) {
            throw new ValueOperationException("Failed to putIfAbsent value: " + exception.getMessage(), exception);
        }
    }

    public boolean compareAndSwap(int n, String string, String string2, String string3, String string4) {
        this.validateKey(string);
        if (string2 == null) {
            throw new IllegalArgumentException("expectedValue cannot be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("newValue cannot be null");
        }
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        if (lookupGroup == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string5 = this.getTableNameForGroup(n);
        try {
            boolean bl = this.valueDao.compareAndSwap(string5, string, string2, string3);
            if (bl) {
                this.recordAudit(n, string5, string, "UPDATE", string2, string3, string4);
                this.logger.debug("Compare and swap lookup value - Group: {}, Key: {}", (Object)lookupGroup.getName(), (Object)string);
                LookupValue lookupValue = this.valueDao.getLookupValue(string5, string);
                if (lookupValue != null) {
                    this.cacheManager.putValue(n, string, string3, lookupValue.getUpdatedDate());
                }
            }
            return bl;
        }
        catch (Exception exception) {
            throw new ValueOperationException("Failed to compareAndSwap value: " + exception.getMessage(), exception);
        }
    }

    public boolean updateValueByDelta(int n, String string, long l, String string2) {
        long l2;
        this.validateKey(string);
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        if (lookupGroup == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        String string3 = this.getTableNameForGroup(n);
        String string4 = this.valueDao.getValue(string3, string);
        if (string4 == null) {
            this.logger.error("Value not found with key: {}", (Object)string);
            return false;
        }
        try {
            l2 = Long.parseLong(string4.trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.error("Current value is not a valid number for key: {} (value='{}')", (Object)string, (Object)string4);
            return false;
        }
        try {
            long l3 = Math.addExact(l2, l);
        }
        catch (ArithmeticException arithmeticException) {
            this.logger.error("Overflow when applying delta {} to current value {}", (Object)l, (Object)l2);
            return false;
        }
        try {
            boolean bl = this.valueDao.updateValueByDelta(string3, string, l);
            if (bl) {
                this.recordAudit(n, string3, string, "UPDATE", string4, "delta: " + l, string2);
                this.logger.debug("Update lookup value by delta - Group: {}, Key: {}, Delta: {}", (Object)lookupGroup.getName(), (Object)string, (Object)l);
                LookupValue lookupValue = this.valueDao.getLookupValue(string3, string);
                if (lookupValue != null) {
                    this.cacheManager.putValue(n, string, lookupValue.getValueData(), lookupValue.getUpdatedDate());
                }
            }
            return bl;
        }
        catch (Exception exception) {
            throw new ValueOperationException("Failed to updateValueByDelta. Error: " + exception.getMessage(), exception);
        }
    }

    public LookupStatistics getStatistics(int n) {
        if (this.groupDao.getGroupById(n) == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        return this.statisticsDao.getStatistics(n);
    }

    public CacheStatistics getCacheStatistics(int n) {
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        if (lookupGroup == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        CacheStats cacheStats = this.cacheManager.getCacheStats(n);
        boolean bl = cacheStats != null;
        return new CacheStatistics(bl, lookupGroup.getCachePolicy(), this.cacheManager.getCacheSize(n), lookupGroup.getCacheSize(), bl ? cacheStats.hitCount() : 0L, bl ? cacheStats.missCount() : 0L, bl ? cacheStats.loadSuccessCount() : 0L, bl ? cacheStats.loadExceptionCount() : 0L, bl ? cacheStats.totalLoadTime() : 0L, bl ? cacheStats.evictionCount() : 0L);
    }

    public void resetStatistics(int n) {
        if (this.groupDao.getGroupById(n) == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        this.statisticsDao.resetStatistics(n);
        this.logger.info("Reset statistics for group ID: {}", (Object)n);
    }

    public List<LookupAudit> getAuditEntries(int n, int n2, int n3) {
        return this.auditDao.getAuditEntriesByGroup(n, n2, n3);
    }

    public List<LookupAudit> searchAuditEntries(int n, int n2, int n3, HistoryFilterState historyFilterState) {
        return this.auditDao.searchAuditEntriesByGroup(n, n2, n3, historyFilterState);
    }

    public int getAuditEntryCount(int n) {
        long l = this.auditDao.getAuditEntryCount(n);
        return Math.toIntExact(l);
    }

    public int searchAuditEntryCount(int n, HistoryFilterState historyFilterState) {
        long l = this.auditDao.searchAuditEntryCount(n, historyFilterState);
        return Math.toIntExact(l);
    }

    public int deleteAuditEntriesBefore(Date date) {
        long l = this.auditDao.deleteAuditEntriesBefore(date);
        return Math.toIntExact(l);
    }

    public void clearGroupCache(int n) {
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        if (lookupGroup == null) {
            throw new GroupNotFoundException("Group not found with ID: " + n);
        }
        this.cacheManager.clearGroupCache(n);
    }

    public void clearAllCaches() {
        this.cacheManager.clearAllCaches();
    }

    private String getTableNameForGroup(int n) {
        return "LOOKUP_VALUE_" + n;
    }

    private void recordAudit(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            LookupAudit lookupAudit = new LookupAudit();
            lookupAudit.setGroupId(n);
            lookupAudit.setTableName(string);
            lookupAudit.setKeyValue(string2);
            lookupAudit.setAction(string3);
            lookupAudit.setOldValue(string4);
            lookupAudit.setNewValue(string5);
            lookupAudit.setUserId(string6);
            this.auditDao.insertAuditEntry(lookupAudit);
        }
        catch (Exception exception) {
            this.logger.warn("Failed to record audit entry: {}", (Object)exception.getMessage());
        }
    }

    private void validateGroup(LookupGroup lookupGroup) {
        if (lookupGroup == null) {
            throw new IllegalArgumentException("Group cannot be null");
        }
        if (lookupGroup.getName() == null || lookupGroup.getName().trim().isEmpty()) {
            throw new IllegalArgumentException("Group name cannot be empty");
        }
        if (lookupGroup.getName().length() > 255) {
            throw new IllegalArgumentException("Group name cannot exceed 255 characters");
        }
        String string = lookupGroup.getCachePolicy();
        if (!(string == null || string.isEmpty() || string.equalsIgnoreCase("LRU") || string.equalsIgnoreCase("FIFO"))) {
            throw new IllegalArgumentException("Invalid cache policy: " + string + ". Must be LRU or FIFO");
        }
        if (lookupGroup.getCacheSize() < 0) {
            throw new IllegalArgumentException("Cache size must be >= 0");
        }
    }

    private void validateKey(String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("Key cannot be empty");
        }
        if (string.length() > 255) {
            throw new IllegalArgumentException("Key cannot exceed 255 characters");
        }
    }
}

