/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.reloading.PeriodicReloadingTrigger;

public class PropertiesConfigurationUtil {
    public static FileBasedConfigurationBuilder<PropertiesConfiguration> createBuilder() {
        return new Configurations().propertiesBuilder(PropertiesConfigurationUtil.getDefaultParameters());
    }

    public static FileBasedConfigurationBuilder<PropertiesConfiguration> createBuilder(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        return new Configurations().propertiesBuilder((PropertiesBuilderParameters)PropertiesConfigurationUtil.getDefaultParameters().setFile(file));
    }

    public static PropertiesConfiguration create() {
        try {
            return (PropertiesConfiguration)PropertiesConfigurationUtil.createBuilder().getConfiguration();
        }
        catch (ConfigurationException e) {
            return new PropertiesConfiguration();
        }
    }

    public static PropertiesConfiguration create(File file) throws ConfigurationException, IOException {
        return (PropertiesConfiguration)PropertiesConfigurationUtil.createBuilder(file).getConfiguration();
    }

    public static PropertiesConfiguration create(InputStream is) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        builder.configure(new BuilderParameters[]{PropertiesConfigurationUtil.getDefaultParameters()});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        FileHandler handler = new FileHandler((FileBased)config);
        handler.load(is);
        return config;
    }

    public static ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> createReloadingBuilder(File file) {
        return PropertiesConfigurationUtil.createReloadingBuilder(file, false);
    }

    public static ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> createReloadingBuilder(File file, boolean commaDelimited) {
        PropertiesBuilderParameters params = (PropertiesBuilderParameters)PropertiesConfigurationUtil.getDefaultParameters().setFile(file);
        if (commaDelimited) {
            params.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        }
        return new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{params});
    }

    public static PeriodicReloadingTrigger createReloadTrigger(ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> builder) {
        return new PeriodicReloadingTrigger(builder.getReloadingController(), null, 1L, TimeUnit.SECONDS);
    }

    public static void saveTo(PropertiesConfiguration config, File file) throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)config);
        handler.save(file);
    }

    public static void saveTo(PropertiesConfiguration config, OutputStream os) throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)config);
        handler.save(os);
    }

    private static PropertiesBuilderParameters getDefaultParameters() {
        return new Parameters().properties();
    }
}

