/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/channels")
@Tag(name="Channel Deployment Operations")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface EngineServletInterface
extends BaseServletInterface {
    @POST
    @Path(value="/_redeployAll")
    @Operation(summary="Redeploys all channels.")
    @MirthOperation(name="redeployAllChannels", display="Redeploy all channels", permission="deployUndeployChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void redeployAllChannels(@Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var1) throws ClientException;

    @POST
    @Path(value="/{channelId}/_deploy")
    @Operation(summary="Deploys (or redeploys) a single channel.")
    @MirthOperation(name="deployChannels", display="Deploy channels", permission="deployUndeployChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void deployChannel(@Param(value="channelId") @Parameter(description="The ID of the channel to deploy.", required=true) @PathParam(value="channelId") String var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2, @Param(value="debugOptions") @Parameter(description="If present, the channel will deploy in debug mode and use these options. The input should be a comma-separated list of 't' and 'f' values that indicate whether to debug Deploy/Undeploy/Preprocessor/Postprocessor scripts, Attachment/Batch scripts, Source Connectors scripts, Source Filter/Transformer scripts, Destination Filter/Transformer scripts, Destination Connector scripts, and Destination Response Transformer scripts, in that order. Example: \"f,f,f,f,f,f,f\")", example="f,f,f,f,f,f,f") @QueryParam(value="debugOptions") String var3) throws ClientException;

    @POST
    @Path(value="/_deploy")
    @Operation(summary="Deploys (or redeploys) selected channels.")
    @MirthOperation(name="deployChannels", display="Deploy channels", permission="deployUndeployChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void deployChannels(@Param(value="channelIds") @RequestBody(description="The ID of the channel(s) to deploy. If absent, all channels will be deployed.", content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel_set", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel_set", ref="../apiexamples/guid_set_json")})}) Set<String> var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/{channelId}/_undeploy")
    @Operation(summary="Undeploys a single channel.")
    @MirthOperation(name="undeployChannels", display="Undeploy channels", permission="deployUndeployChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void undeployChannel(@Param(value="channelId") @Parameter(description="The ID of the channel to undeploy.", required=true) @PathParam(value="channelId") String var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;

    @POST
    @Path(value="/_undeploy")
    @Operation(summary="Undeploys selected channels.")
    @MirthOperation(name="undeployChannels", display="Undeploy channels", permission="deployUndeployChannels", type=Operation.ExecuteType.ABORT_PENDING)
    public void undeployChannels(@Param(value="channelIds") @RequestBody(description="The IDs of the channels to retrieve. If absent, all channels will be retrieved.", content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channel_set", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channel_set", ref="../apiexamples/guid_set_json")})}) Set<String> var1, @Param(value="returnErrors") @Parameter(description="If true, an error response code and the exception will be returned.") @QueryParam(value="returnErrors") boolean var2) throws ClientException;
}

