/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.converters;

import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.InvalidConnectorPluginProperties;
import com.mirth.connect.model.converters.MigratableConverter;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.DocumentReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class PluginPropertiesConverter
extends MigratableConverter {
    private HierarchicalStreamCopier copier = new HierarchicalStreamCopier();

    public PluginPropertiesConverter(String currentVersion, Mapper mapper) {
        super(currentVersion, mapper);
    }

    @Override
    public boolean canConvert(Class type) {
        return true;
    }

    @Override
    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        for (ConnectorPluginProperties properties : (Collection)value) {
            String propertiesXml;
            if (properties instanceof InvalidConnectorPluginProperties) {
                try {
                    propertiesXml = ((InvalidConnectorPluginProperties)properties).getPropertiesXml();
                }
                catch (Exception e) {
                    throw new SerializerException((Throwable)e);
                }
            } else {
                propertiesXml = ObjectXMLSerializer.getInstance().serialize(properties);
            }
            this.copier.copy((HierarchicalStreamReader)new XppReader((Reader)new StringReader(propertiesXml), (XmlPullParser)new MXParser()), writer);
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (reader.underlyingReader() instanceof DocumentReader) {
            DonkeyElement element = new DonkeyElement((Element)((DocumentReader)reader.underlyingReader()).getCurrent());
            HashSet<ConnectorPluginProperties> propertiesSet = new HashSet<ConnectorPluginProperties>();
            for (DonkeyElement child : element.getChildElements()) {
                ConnectorPluginProperties properties;
                String preUnmarshalXml = null;
                try {
                    try {
                        preUnmarshalXml = child.toXml();
                    }
                    catch (DonkeyElement.DonkeyElementException donkeyElementException) {
                        // empty catch block
                    }
                    properties = ObjectXMLSerializer.getInstance().deserialize(preUnmarshalXml, ConnectorPluginProperties.class);
                }
                catch (LinkageError e) {
                    properties = new InvalidConnectorPluginProperties(preUnmarshalXml, child, e);
                }
                catch (Exception e) {
                    properties = new InvalidConnectorPluginProperties(preUnmarshalXml, child, e);
                }
                propertiesSet.add(properties);
            }
            return propertiesSet;
        }
        return super.unmarshal(reader, context);
    }
}

